/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.link.rake;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.model.LinkServices;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.figures.routers.RakeConstraint;
import com.modeliosoft.modelio.diagram.elements.core.helpers.AuthHelper;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLink;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLinkRake;
import com.modeliosoft.modelio.diagram.elements.core.link.GmPath;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLink;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLinkRake;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLinkable;
import com.modeliosoft.modelio.diagram.styles.core.MetaKey;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import org.eclipse.draw2d.XYAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.commands.Command;

public class RakeLinkOnTargetCommand
extends Command {
    private final GmLink toConnect;
    private final GmLink rakeLink;
    private final Point rakeLocation;
    private Object gmTargetAnchor;

    public RakeLinkOnTargetCommand(GmLink toConnect, GmLink rakeLink, Point loc, Object gmTargetAnchor) {
        this.rakeLink = rakeLink;
        this.toConnect = toConnect;
        this.rakeLocation = loc;
        this.gmTargetAnchor = gmTargetAnchor;
    }

    public void execute() {
        this.updateLinkTarget();
        if (this.rakeLink.getPath().getTargetRake() == null) {
            this.setRakeMode();
        }
        GmPath newConnectPath = new GmPath(this.toConnect.getPath());
        newConnectPath.setPathData(this.rakeLink.getPath().getPathData());
        newConnectPath.setRouterKind(StyleKey.ConnectionRouterId.ORTHOGONAL);
        newConnectPath.setTargetAnchor(this.rakeLink.getPath().getTargetAnchor());
        newConnectPath.setTargetRake(this.rakeLink.getPath().getTargetRake());
        this.toConnect.setLayoutData((Object)newConnectPath);
    }

    private void setRakeMode() {
        GmLinkRake targetRake = new GmLinkRake();
        targetRake.setSharedAnchor(this.gmTargetAnchor);
        RakeConstraint rakeData = new RakeConstraint();
        rakeData.setTargetRakeAnchor(new XYAnchor(this.rakeLocation));
        GmPath path = new GmPath(this.rakeLink.getPath());
        path.setPathData((Object)rakeData);
        path.setRouterKind(StyleKey.ConnectionRouterId.ORTHOGONAL);
        path.setTargetAnchor(this.gmTargetAnchor);
        path.setTargetRake((IGmLinkRake)targetRake);
        this.rakeLink.setLayoutData((Object)path);
    }

    public boolean canExecute() {
        if (this.toConnect.getStyleKey(MetaKey.CONNECTIONROUTER) != null && this.rakeLink.getStyleKey(MetaKey.CONNECTIONROUTER) != null && (this.toConnect == null || this.toConnect.getClass() == this.rakeLink.getClass())) {
            return AuthHelper.canModifyDiagram((GmAbstractDiagram)this.toConnect.getDiagram());
        }
        return false;
    }

    protected void updateLinkTarget() {
        IElement link = this.toConnect.getRelatedIElement();
        IElement newDest = this.rakeLink.getToElement();
        IGmLinkable oldTargetNode = this.toConnect.getTo();
        if (oldTargetNode != null) {
            IElement oldDest = oldTargetNode.getRelatedIElement();
            if (!newDest.equals((Object)oldDest)) {
                LinkServices.changeTarget((IElement)link, (IElement)oldDest, (IElement)newDest);
            }
            oldTargetNode.removeEndingLink((IGmLink)this.toConnect);
        } else {
            LinkServices.changeTarget((IElement)link, null, (IElement)newDest);
        }
        this.rakeLink.getTo().addEndingLink((IGmLink)this.toConnect);
    }
}

