/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.model;

import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmObject;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import com.modeliosoft.modelio.diagram.styles.core.IStyle;
import com.modeliosoft.modelio.diagram.styles.core.IStyleChangeListener;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public abstract class GmAbstractObject
implements IGmObject,
IStyleChangeListener {
    private Object layoutData = null;
    private PropertyChangeSupport listeners = null;
    private IStyle style = null;
    private GmAbstractDiagram diagram;
    protected static final String MINOR_VERSION_PROPERTY = "version";
    private final int minorVersion = 0;
    private static final int MAJOR_VERSION = 0;

    public GmAbstractObject(GmAbstractDiagram diagram) {
        this.diagram = diagram;
        this.listeners = new PropertyChangeSupport(this);
    }

    public GmAbstractObject() {
        this.listeners = new PropertyChangeSupport(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    public void delete() {
        this.firePropertyChange("Delete", null, null);
        if (this.style != null) {
            this.style.removeListener((IStyleChangeListener)this);
        }
    }

    public GmAbstractDiagram getDiagram() {
        return this.diagram;
    }

    public Object getLayoutData() {
        return this.layoutData;
    }

    public final IStyle getStyle() {
        if (this.style == null && this.getDiagram() != null) {
            this.style = this.createStyle(this.getDiagram());
            this.style.addListener((IStyleChangeListener)this);
        }
        return this.style;
    }

    public boolean isExternal(IDiagramWriter out) {
        return false;
    }

    public void read(IDiagramReader in) {
        Object versionProperty = in.readProperty("GmAbstractObject.version");
        int readVersion = versionProperty == null ? 0 : (Integer)versionProperty;
        switch (readVersion) {
            case 0: {
                this.read_0(in);
                break;
            }
            default: {
                assert (false) : "version number not covered!";
                this.read_0(in);
            }
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    public void setLayoutData(Object layoutData) {
        Object oldData = this.layoutData;
        this.layoutData = layoutData;
        this.firePropertyChange("LayoutData", oldData, layoutData);
    }

    public void styleChanged(StyleKey property, Object newValue) {
        this.firePropertyChange("Style", null, (Object)this.getStyle());
    }

    public void styleChanged(IStyle changedStyle) {
        this.firePropertyChange("Style", null, (Object)changedStyle);
    }

    public void write(IDiagramWriter out) {
        out.writeProperty("layoutData", this.getLayoutData());
        out.writeProperty("Style", (Object)this.style);
        if (false) {
            out.writeProperty("GmAbstractObject.version", (Object)0);
        }
    }

    protected abstract IStyle createStyle(GmAbstractDiagram var1);

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.listeners.firePropertyChange(propertyName, oldValue, newValue);
    }

    public int getMajorVersion() {
        return 0;
    }

    private void read_0(IDiagramReader in) {
        this.layoutData = in.readProperty("layoutData");
        this.style = (IStyle)in.readProperty("Style");
        this.diagram = (GmAbstractDiagram)in.getRoot();
        if (this.style != null) {
            this.style.addListener((IStyleChangeListener)this);
        }
    }

    public boolean isEditable() {
        return this.diagram.isEditable();
    }
}

