/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.model;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.model.GmAbstractObject;
import com.modeliosoft.modelio.diagram.elements.core.model.IEditableText;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmModelRelated;
import com.modeliosoft.modelio.diagram.elements.core.model.IObModelChangeListener;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import com.modeliosoft.modelio.diagram.styles.core.IStyle;
import com.modeliosoft.modelio.diagram.styles.core.Style;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import com.modeliosoft.modelio.diagram.styles.plugin.DiagramStyles;

public abstract class GmModel
extends GmAbstractObject
implements IObModelChangeListener,
IGmModelRelated {
    private ObRef relatedRef;
    private String lastKnownLabel;
    private static final String RAMC_STYLE = "ramc";
    private final int minorVersion = 0;
    private static final int MAJOR_VERSION = 0;

    public GmModel(GmAbstractDiagram diagram, ObRef relatedRef) {
        super(diagram);
        assert (relatedRef != null) : "Error: a GmModel should never be instantiated with a null reference.";
        this.relatedRef = relatedRef;
        this.init();
    }

    public GmModel() {
    }

    public abstract boolean canCreate(Class<? extends IElement> var1);

    public abstract boolean canUnmask(IElement var1);

    public void delete() {
        super.delete();
        if (this.getDiagram() != null) {
            this.getDiagram().removeGraphicModel(this);
        }
    }

    public IEditableText getEditableText() {
        return null;
    }

    public String getGhostId() {
        return this.relatedRef.uuid;
    }

    public String getGhostLabel() {
        return this.lastKnownLabel;
    }

    public String getGhostMetaclass() {
        return this.relatedRef.mc;
    }

    public abstract GmModel getParent();

    public IElement getRelatedIElement() {
        if (this.getRepresentedIElement() != null) {
            return this.getRepresentedIElement();
        }
        if (this.getParent() != null) {
            return this.getParent().getRelatedIElement();
        }
        return null;
    }

    public abstract StyleKey.RepresentationMode getRepresentationMode();

    public IElement getRepresentedIElement() {
        return null;
    }

    public final ObRef getRepresentedRef() {
        return this.relatedRef;
    }

    public void obElementAdded(IElement movedEl) {
    }

    public void obElementDeleted() {
        this.delete();
    }

    public void obElementResolved(IElement ev) {
        if (this.getRelatedIElement() != null && this.getRelatedIElement().isValid()) {
            this.lastKnownLabel = this.getRelatedIElement().getName();
        }
        this.refreshFromObModel();
    }

    public void obElementsUpdated() {
        if (this.getRelatedIElement() != null && this.getRelatedIElement().isValid()) {
            this.lastKnownLabel = this.getRelatedIElement().getName();
        }
        this.refreshFromObModel();
    }

    public void read(IDiagramReader in) {
        Object versionProperty = in.readProperty("GmModel.version");
        int readVersion = versionProperty == null ? 0 : (Integer)versionProperty;
        switch (readVersion) {
            case 0: {
                this.read_0(in);
                break;
            }
            default: {
                assert (false) : "version number not covered!";
                this.read_0(in);
            }
        }
    }

    public void write(IDiagramWriter out) {
        super.write(out);
        out.writeProperty("relatedRef", this.relatedRef);
        out.writeProperty("lastKnownLabel", this.lastKnownLabel);
        if (false) {
            out.writeProperty("GmModel.version", (Object)0);
        }
    }

    protected IStyle createStyle(GmAbstractDiagram aDiagram) {
        IStyle baseStyle;
        IElement el = this.getRelatedIElement();
        if (el != null && el.getElementStatus().isRamcObject()) {
            baseStyle = DiagramStyles.getInstance().getStyleManager().getStyle(RAMC_STYLE);
            if (baseStyle == null) {
                baseStyle = aDiagram.getStyle();
            }
        } else {
            baseStyle = aDiagram.getStyle();
        }
        return new Style(baseStyle);
    }

    protected abstract void refreshFromObModel();

    protected final IElement resolveRef(ObRef ref) {
        return this.getDiagram().getModelManager().resolveRef(ref);
    }

    private void init() {
        if (this.getDiagram() != null) {
            this.getDiagram().addGraphicModel(this);
        }
    }

    private void read_0(IDiagramReader in) {
        super.read(in);
        this.relatedRef = (ObRef)in.readProperty("relatedRef");
        this.lastKnownLabel = (String)in.readProperty("lastKnownLabel");
        this.init();
    }

    public int getMajorVersion() {
        return 0;
    }
}

