/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.node;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.model.IEditableText;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import java.util.ArrayList;
import java.util.List;

public abstract class GmCompositeNode
extends GmNodeModel {
    private List<GmNodeModel> children = new ArrayList();
    private final int minorVersion = 0;
    private static final int MAJOR_VERSION = 0;

    public GmCompositeNode() {
    }

    public GmCompositeNode(GmAbstractDiagram diagram, ObRef relatedRef) {
        super(diagram, relatedRef);
    }

    public void addChild(GmNodeModel child) {
        this.children.add(child);
        child.setParent(this);
        this.firePropertyChange("Children", null, (Object)child);
    }

    public boolean canContain(Class<? extends GmNodeModel> nodeClass) {
        return true;
    }

    public void delete() {
        int i = this.children.size() - 1;
        while (i >= 0) {
            GmNodeModel child = (GmNodeModel)this.children.get(i);
            child.delete();
            if (i > this.children.size()) {
                i = this.children.size();
            }
            --i;
        }
        assert (this.children.isEmpty()) : "All children should have been deleted";
        super.delete();
    }

    public void fireChildVisibilityChanged(GmNodeModel child) {
        this.firePropertyChange("Children", null, (Object)child);
    }

    public final GmNodeModel getChild(ObRef ref) {
        for (GmNodeModel child : this.children) {
            if (!child.getRepresentedRef().equals((Object)ref)) continue;
            return child;
        }
        return null;
    }

    public final List<GmNodeModel> getChildren(String role) {
        ArrayList<GmNodeModel> ret = new ArrayList<GmNodeModel>(this.children.size());
        for (GmNodeModel c : this.children) {
            if (!role.equals(c.getRoleInComposition())) continue;
            ret.add(c);
        }
        return ret;
    }

    public final List<GmNodeModel> getChildren() {
        return new ArrayList<GmNodeModel>(this.children);
    }

    public abstract GmCompositeNode getCompositeFor(Class<? extends IElement> var1);

    public IEditableText getEditableText() {
        for (GmNodeModel child : this.getChildren()) {
            if (child.getEditableText() == null) continue;
            return child.getEditableText();
        }
        return super.getEditableText();
    }

    public final GmNodeModel getFirstChild(String role) {
        for (GmNodeModel c : this.children) {
            if (!role.equals(c.getRoleInComposition())) continue;
            return c;
        }
        return null;
    }

    public List<GmNodeModel> getVisibleChildren() {
        ArrayList<GmNodeModel> ret = new ArrayList<GmNodeModel>(this.children.size());
        for (GmNodeModel childNode : this.children) {
            if (!childNode.isVisible()) continue;
            ret.add(childNode);
        }
        return ret;
    }

    public final boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public final void moveChild(GmNodeModel child, int index) {
        int oldIndex = this.children.indexOf(child);
        if (oldIndex == -1) {
            throw new IllegalArgumentException("The element is not in the children list");
        }
        if (index == oldIndex) {
            return;
        }
        if (index == -1 && oldIndex == this.children.size() - 1) {
            return;
        }
        this.children.remove(child);
        if (index == -1) {
            this.children.add(child);
        } else if (index > oldIndex) {
            this.children.add(index - 1, child);
        } else {
            this.children.add(index, child);
        }
        this.firePropertyChange("Children", null, (Object)child);
    }

    public void read(IDiagramReader in) {
        Object versionProperty = in.readProperty("GmCompositeNode.version");
        int readVersion = versionProperty == null ? 0 : (Integer)versionProperty;
        switch (readVersion) {
            case 0: {
                this.read_0(in);
                break;
            }
            default: {
                assert (false) : "version number not covered!";
                this.read_0(in);
            }
        }
    }

    public void refreshFromObModel() {
        if (this.getRelatedIElement() != null) {
            for (GmNodeModel gm : this.getChildren()) {
                if (this.isValidChild(gm)) continue;
                gm.delete();
            }
        }
    }

    public void removeChild(GmNodeModel child) {
        if (this.children.remove(child)) {
            this.firePropertyChange("Children", (Object)child, null);
            child.setParent(null);
        } else assert (false) : "Child is not a valid child";
    }

    public void write(IDiagramWriter out) {
        super.write(out);
        out.writeProperty("Children", this.getChildren());
        if (false) {
            out.writeProperty("GmCompositeNode.version", (Object)0);
        }
    }

    protected boolean isValidChild(GmNodeModel node) {
        return true;
    }

    public void addChild(GmNodeModel child, int index) {
        this.children.add(index, child);
        child.setParent(this);
        this.firePropertyChange("Children", null, (Object)child);
    }

    public final int getChildIndex(GmNodeModel child) {
        return this.children.indexOf(child);
    }

    private void read_0(IDiagramReader in) {
        super.read(in);
        List listProperty = in.readListProperty("Children");
        for (Object c : listProperty) {
            GmNodeModel childNode = (GmNodeModel)c;
            this.children.add(childNode);
            childNode.setParent(this);
        }
        this.firePropertyChange("Children", null, (Object)this.children);
    }

    public int getMajorVersion() {
        return 0;
    }
}

