/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.node;

import com.modeliosoft.modelio.diagram.elements.core.commands.DefaultReparentElementCommand;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLinkEditPart;
import com.modeliosoft.modelio.ui.gef.SharedCursors2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.gef.util.EditPartUtilities;
import org.eclipse.swt.graphics.Cursor;

public class GmNodeDragTracker
extends DragEditPartsTracker {
    private ArrayList<IFigure> exclusionSet = null;

    public GmNodeDragTracker(EditPart sourceEditPart) {
        super(sourceEditPart);
    }

    protected Cursor calculateCursor() {
        if (this.isInState(36) && !this.isMove() && !this.isCloneActive()) {
            Command currentCommand = this.getCurrentCommand();
            return this.getReparentCursor(currentCommand);
        }
        return super.calculateCursor();
    }

    private Cursor getReparentCursor(Command command) {
        DefaultReparentElementCommand reparentCmd = this.getReparentCommand(command);
        if (reparentCmd != null) {
            if (reparentCmd.canExecute()) {
                return SharedCursors2.CURSOR_REPARENT;
            }
            return SharedCursors2.CURSOR_REPARENT_NOT;
        }
        return super.calculateCursor();
    }

    protected Collection<?> getExclusionSet() {
        if (this.exclusionSet == null) {
            List set = this.getOperationSet();
            this.exclusionSet = new ArrayList(set.size() + 1);
            int i = 0;
            while (i < set.size()) {
                GraphicalEditPart editpart = (GraphicalEditPart)set.get(i);
                this.exclusionSet.add(editpart.getFigure());
                ++i;
            }
        }
        return this.exclusionSet;
    }

    protected List<?> createOperationSet() {
        List operationSet = super.createOperationSet();
        HashSet linksToAdd = new HashSet();
        do {
            linksToAdd.clear();
            this.computeAllLinksFor(operationSet, linksToAdd);
            operationSet.addAll(linksToAdd);
        } while (linksToAdd.size() != 0);
        return operationSet;
    }

    private void computeAllLinksFor(List<Object> operationSet, Set<Object> linksToAdd) {
        for (Object object : operationSet) {
            if (!(object instanceof GraphicalEditPart)) continue;
            GraphicalEditPart graphicalEditPart = (GraphicalEditPart)object;
            HashSet allLinks = EditPartUtilities.getAllNestedConnectionEditParts((GraphicalEditPart)graphicalEditPart);
            for (Object link : allLinks) {
                if (!(link instanceof GmLinkEditPart) || operationSet.contains(link)) continue;
                GmLinkEditPart linkEditPart = (GmLinkEditPart)link;
                boolean sourceInSet = ToolUtilities.isAncestorContainedIn(operationSet, (EditPart)linkEditPart.getSource());
                boolean targetInSet = ToolUtilities.isAncestorContainedIn(operationSet, (EditPart)linkEditPart.getTarget());
                if (!sourceInSet || !targetInSet || !linkEditPart.understandsRequest(this.getTargetRequest())) continue;
                linksToAdd.add(linkEditPart);
            }
        }
    }

    private DefaultReparentElementCommand getReparentCommand(Command command) {
        if (command instanceof DefaultReparentElementCommand) {
            return (DefaultReparentElementCommand)command;
        }
        if (command instanceof CompoundCommand) {
            List nestedCommands = ((CompoundCommand)command).getCommands();
            for (Command nested : nestedCommands) {
                DefaultReparentElementCommand ret = this.getReparentCommand(nested);
                if (ret == null) continue;
                return ret;
            }
        }
        return null;
    }
}

