/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.node;

import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.IGmNode;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLink;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLink;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLinkable;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import com.modeliosoft.modelio.diagram.styles.core.MetaKey;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import java.util.ArrayList;
import java.util.List;

public abstract class GmNodeModel
extends GmModel
implements IGmNode {
    private GmCompositeNode parentNode = null;
    private GmLink parentLink = null;
    protected String roleInComposition = "";
    private final List<IGmLink> startingLinks = new ArrayList();
    private final List<IGmLink> endingLinks = new ArrayList();
    private final int minorVersion = 0;
    private static final int MAJOR_VERSION = 0;

    public GmNodeModel() {
    }

    public GmNodeModel(GmAbstractDiagram diagram, ObRef relatedRef) {
        super(diagram, relatedRef);
    }

    public void addEndingLink(IGmLink link) {
        this.endingLinks.add(link);
        link.setTo((IGmLinkable)this);
        this.firePropertyChange("Link target", null, (Object)link);
    }

    public void addStartingLink(IGmLink link) {
        this.startingLinks.add(link);
        link.setFrom((IGmLinkable)this);
        this.firePropertyChange("Link source", null, (Object)link);
    }

    public void delete() {
        GmLink gmLink;
        for (IGmLink l : new ArrayList(this.startingLinks)) {
            l.delete();
        }
        for (IGmLink l : new ArrayList(this.endingLinks)) {
            l.delete();
        }
        GmCompositeNode gmParent = this.getParentNode();
        if (gmParent != null) {
            gmParent.removeChild(this);
        }
        if ((gmLink = this.getParentLink()) != null) {
            gmLink.removeExtension(this);
        }
        super.delete();
    }

    public List<IGmLink> getEndingLinks() {
        return this.endingLinks;
    }

    public final GmLink getParentLink() {
        return this.parentLink;
    }

    public final GmCompositeNode getParentNode() {
        return this.parentNode;
    }

    public final GmModel getParent() {
        if (this.parentNode != null) {
            return this.parentNode;
        }
        return this.parentLink;
    }

    public final String getRoleInComposition() {
        return this.roleInComposition;
    }

    public final StyleKey getStyleKeyStrict(MetaKey metakey) throws IllegalStateException {
        StyleKey ret = this.getStyleKey(metakey);
        if (ret == null) {
            if (this.getParent() == null) {
                throw new IllegalStateException("No style key for '" + metakey.getKey() + "' MetaKey on " + this.toString());
            }
            throw new IllegalStateException("No style key for '" + metakey.getKey() + "' MetaKey on " + this.toString() + " in " + this.getParent().toString());
        }
        return ret;
    }

    public boolean isVisible() {
        if (this.getParentNode() != null) {
            return this.getParentNode().isVisible();
        }
        return true;
    }

    public void read(IDiagramReader in) {
        Object versionProperty = in.readProperty("GmNodeModel.version");
        int readVersion = versionProperty == null ? 0 : (Integer)versionProperty;
        switch (readVersion) {
            case 0: {
                this.read_0(in);
                break;
            }
            default: {
                assert (false) : "version number not covered!";
                this.read_0(in);
            }
        }
    }

    public void removeEndingLink(IGmLink gmLink) {
        this.endingLinks.remove(gmLink);
        gmLink.setTo(null);
        this.firePropertyChange("Link target", (Object)gmLink, null);
    }

    public void removeStartingLink(IGmLink gmLink) {
        this.startingLinks.remove(gmLink);
        gmLink.setFrom(null);
        this.firePropertyChange("Link source", (Object)gmLink, null);
    }

    public void setParentLink(GmLink parentLink) throws IllegalStateException {
        if (this.parentNode != null) {
            throw new IllegalStateException("The node has already " + this.parentNode + " as parent node");
        }
        this.parentLink = parentLink;
    }

    public final void setRoleInComposition(String value) {
        this.roleInComposition = value;
    }

    public final void setVisible(boolean visible) {
        this.doSetVisible(visible);
        this.fireVisibilityChanged();
    }

    public void write(IDiagramWriter out) {
        super.write(out);
        out.writeProperty("roleInComposition", this.roleInComposition);
        if (false) {
            out.writeProperty("GmNodeModel.version", (Object)0);
        }
    }

    protected void doSetVisible(boolean visible) {
    }

    protected final void fireVisibilityChanged() {
        GmLink link;
        GmCompositeNode parent = this.getParentNode();
        if (parent != null) {
            parent.fireChildVisibilityChanged(this);
        }
        if ((link = this.getParentLink()) != null) {
            link.fireChildVisibilityChanged(this);
        }
    }

    protected void setParent(GmCompositeNode parent) throws IllegalStateException {
        if (this.parentLink != null) {
            throw new IllegalStateException("The node has already " + this.parentLink + " as parent link");
        }
        this.parentNode = parent;
    }

    public List<IGmLink> getStartingLinks() {
        return this.startingLinks;
    }

    private void read_0(IDiagramReader in) {
        super.read(in);
        this.roleInComposition = (String)in.readProperty("roleInComposition");
    }

    public int getMajorVersion() {
        return 0;
    }

    public void setParentNode(GmCompositeNode parentNode) {
        this.parentNode = parentNode;
    }
}

