/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.node;

import com.modeliosoft.modelio.diagram.elements.core.figures.anchors.BorderAnchor;
import com.modeliosoft.modelio.diagram.elements.core.figures.anchors.DelegateAnchor;
import com.modeliosoft.modelio.diagram.elements.core.figures.anchors.NodeAnchor;
import com.modeliosoft.modelio.diagram.elements.core.figures.anchors.PointAnchor;
import com.modeliosoft.modelio.diagram.elements.core.figures.anchors.RaySlidableAnchor;
import com.modeliosoft.modelio.diagram.elements.core.figures.anchors.SatelliteAnchor;
import com.modeliosoft.modelio.diagram.elements.core.figures.routers.OrthogonalRouter;
import com.modeliosoft.modelio.diagram.elements.core.figures.routers.RakeRouter;
import com.modeliosoft.modelio.diagram.elements.core.link.CreateBendedConnectionRequest;
import com.modeliosoft.modelio.diagram.elements.core.link.GmAbstractLinkAnchor;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLink;
import com.modeliosoft.modelio.diagram.elements.core.link.anchors.AnchorRegistry;
import com.modeliosoft.modelio.diagram.elements.core.link.anchors.GmBorderAnchor;
import com.modeliosoft.modelio.diagram.elements.core.link.anchors.GmNodeAnchor;
import com.modeliosoft.modelio.diagram.elements.core.link.anchors.GmPointAnchor;
import com.modeliosoft.modelio.diagram.elements.core.link.anchors.GmRaySlidableAnchor;
import com.modeliosoft.modelio.diagram.elements.core.link.anchors.GmSourceSatelliteAnchor;
import com.modeliosoft.modelio.diagram.elements.core.link.anchors.GmXYAnchor;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmPath;
import com.modeliosoft.modelio.diagram.elements.core.tools.multipoint.CreateMultiPointRequest;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.XYAnchor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.ReconnectRequest;

public class RectangleNodeAnchorProvider {
    private static RectangleNodeAnchorProvider singleton = new RectangleNodeAnchorProvider();
    private GmLink gmLink;
    private Object gmSourceAnchor;
    private Object gmTargetAnchor;
    private ConnectionEditPart connectionEditPart;
    private boolean raked;

    public static RectangleNodeAnchorProvider get() {
        return singleton;
    }

    private RectangleNodeAnchorProvider() {
    }

    public Object createAnchorModel(ConnectionAnchor anchor) {
        Object gmAnchor = AnchorRegistry.getGmAnchor((ConnectionAnchor)anchor);
        if (anchor instanceof BorderAnchor) {
            BorderAnchor a = (BorderAnchor)anchor;
            if (gmAnchor instanceof GmBorderAnchor) {
                GmBorderAnchor gmBorder = (GmBorderAnchor)gmAnchor;
                gmBorder.setBorder(a.getBorder());
                gmBorder.setOffset(a.getOffset());
                return gmBorder;
            }
            return new GmBorderAnchor(a.getBorder(), a.getOffset());
        }
        if (anchor instanceof ChopboxAnchor) {
            return null;
        }
        if (anchor instanceof RaySlidableAnchor) {
            RaySlidableAnchor a = (RaySlidableAnchor)anchor;
            Point anchorPoint = a.getReferencePoint().getCopy();
            Point figureLocation = a.getOwner().getBounds().getTopLeft();
            a.getOwner().translateToAbsolute((Translatable)figureLocation);
            Dimension difference = anchorPoint.getDifference(figureLocation);
            a.getOwner().translateToRelative((Translatable)difference);
            if (gmAnchor instanceof GmRaySlidableAnchor) {
                GmRaySlidableAnchor gmRay = (GmRaySlidableAnchor)gmAnchor;
                gmRay.setDifference(difference);
                return gmRay;
            }
            return new GmRaySlidableAnchor(difference);
        }
        if (anchor instanceof NodeAnchor) {
            NodeAnchor a = (NodeAnchor)anchor;
            Point anchorPoint = a.getReferencePoint().getCopy();
            Point figureLocation = a.getOwner().getBounds().getTopLeft();
            a.getOwner().translateToAbsolute((Translatable)figureLocation);
            Dimension difference = anchorPoint.getDifference(figureLocation);
            a.getOwner().translateToRelative((Translatable)difference);
            if (gmAnchor instanceof GmNodeAnchor) {
                GmNodeAnchor gmNodeAnchor = (GmNodeAnchor)gmAnchor;
                gmNodeAnchor.setDifference(difference);
                return gmNodeAnchor;
            }
            return new GmNodeAnchor(difference);
        }
        if (anchor instanceof XYAnchor) {
            XYAnchor xy = (XYAnchor)anchor;
            if (gmAnchor instanceof GmXYAnchor) {
                GmXYAnchor gmXy = (GmXYAnchor)gmAnchor;
                gmXy.setReferencePoint(xy.getReferencePoint());
                return gmXy;
            }
            return new GmXYAnchor(xy.getReferencePoint());
        }
        if (anchor instanceof DelegateAnchor) {
            DelegateAnchor a = (DelegateAnchor)anchor;
            return this.createAnchorModel(a.getDelegate());
        }
        if (anchor instanceof SatelliteAnchor) {
            SatelliteAnchor sa = (SatelliteAnchor)anchor;
            if (gmAnchor instanceof GmSourceSatelliteAnchor) {
                GmSourceSatelliteAnchor ret = (GmSourceSatelliteAnchor)gmAnchor;
                ret.setLocation(sa.getDistance());
                return ret;
            }
            GmSourceSatelliteAnchor ret = new GmSourceSatelliteAnchor();
            ret.setLocation(sa.getDistance());
            return ret;
        }
        throw new IllegalArgumentException(anchor + " not handled");
    }

    public ConnectionAnchor getSourceConnectionAnchor(GraphicalEditPart nodeEditPart, ConnectionEditPart connEditpart) {
        ConnectionAnchor ret;
        this.init(connEditpart);
        if (this.gmSourceAnchor == null) {
            return new ChopboxAnchor(nodeEditPart.getFigure());
        }
        ConnectionAnchor old = AnchorRegistry.getFigAnchor((Object)this.gmSourceAnchor);
        if (old != (ret = this.updateConnectionAnchor(old, this.gmSourceAnchor, nodeEditPart, false))) {
            AnchorRegistry.put((Object)this.gmSourceAnchor, (ConnectionAnchor)ret);
        }
        return ret;
    }

    public ConnectionAnchor getSourceConnectionAnchor(GraphicalEditPart nodeEditPart, Request request) {
        if (request instanceof CreateBendedConnectionRequest) {
            IFigure fig = nodeEditPart.getFigure();
            Point figLocation = fig.getBounds().getTopLeft();
            fig.translateToAbsolute((Translatable)figLocation);
            CreateBendedConnectionRequest req = (CreateBendedConnectionRequest)request;
            if (this.needSlidableAnchor(req.getData().getRoutingMode())) {
                Dimension r = req.getData().getSrcPoint().getDifference(figLocation);
                fig.translateToRelative((Translatable)r);
                return new RaySlidableAnchor(fig, r);
            }
            Dimension r = req.getData().getSrcPoint().getDifference(figLocation);
            fig.translateToRelative((Translatable)r);
            return new NodeAnchor(fig, r);
        }
        if (request instanceof CreateMultiPointRequest) {
            return this.getMPConnectionAnchor(nodeEditPart, (CreateMultiPointRequest)request, true);
        }
        if (request instanceof ReconnectRequest) {
            return this.getConnectionAnchor(nodeEditPart, (ReconnectRequest)request, true);
        }
        if (request instanceof CreateRequest) {
            return this.getConnectionAnchor(nodeEditPart, (CreateRequest)request, true);
        }
        throw new IllegalArgumentException(request + " not handled.");
    }

    public ConnectionAnchor getTargetConnectionAnchor(GraphicalEditPart nodeEditPart, Request request) {
        if (request instanceof CreateBendedConnectionRequest) {
            this.raked = request.getExtendedData().get("rake") == Boolean.TRUE;
            IFigure fig = nodeEditPart.getFigure();
            Point figLocation = fig.getBounds().getTopLeft();
            fig.translateToAbsolute((Translatable)figLocation);
            CreateBendedConnectionRequest req = (CreateBendedConnectionRequest)request;
            if (this.needSlidableAnchor(req.getData().getRoutingMode())) {
                Dimension r = req.getLocation().getDifference(figLocation);
                fig.translateToRelative((Translatable)r);
                return new RaySlidableAnchor(fig, r);
            }
            Dimension r = req.getLocation().getDifference(figLocation);
            fig.translateToRelative((Translatable)r);
            return new NodeAnchor(fig, r);
        }
        if (request instanceof CreateMultiPointRequest) {
            return this.getMPConnectionAnchor(nodeEditPart, (CreateMultiPointRequest)request, false);
        }
        if (request instanceof ReconnectRequest) {
            return this.getConnectionAnchor(nodeEditPart, (ReconnectRequest)request, false);
        }
        if (request instanceof CreateRequest) {
            return this.getConnectionAnchor(nodeEditPart, (CreateRequest)request, false);
        }
        throw new IllegalArgumentException(request + " not handled.");
    }

    public ConnectionAnchor getTargetConnectionAnchor(GraphicalEditPart nodeEditPart, ConnectionEditPart connEditpart) {
        this.init(connEditpart);
        if (this.gmTargetAnchor == null) {
            return new ChopboxAnchor(nodeEditPart.getFigure());
        }
        ConnectionAnchor old = AnchorRegistry.getFigAnchor((Object)this.gmTargetAnchor);
        ConnectionAnchor ret = this.updateConnectionAnchor(old, this.gmTargetAnchor, nodeEditPart, true);
        if (ret != old) {
            AnchorRegistry.put((Object)this.gmTargetAnchor, (ConnectionAnchor)ret);
        }
        return ret;
    }

    public ConnectionAnchor updateConnectionAnchor(ConnectionAnchor anchor, Object gmLinkAnchor, GraphicalEditPart nodeEditPart, boolean isTargetAnchor) {
        IFigure nodeFigure = nodeEditPart.getFigure();
        if (gmLinkAnchor instanceof GmRaySlidableAnchor) {
            GmRaySlidableAnchor a = (GmRaySlidableAnchor)gmLinkAnchor;
            return this.updateConnectionAnchor(anchor, a.getDifference(), nodeFigure);
        }
        if (gmLinkAnchor instanceof GmNodeAnchor) {
            GmNodeAnchor a = (GmNodeAnchor)gmLinkAnchor;
            return this.updateConnectionAnchor(anchor, a.getDifference(), nodeFigure);
        }
        if (gmLinkAnchor instanceof GmBorderAnchor) {
            GmBorderAnchor a = (GmBorderAnchor)gmLinkAnchor;
            if (anchor instanceof BorderAnchor && anchor.getOwner() == nodeFigure) {
                BorderAnchor ret = (BorderAnchor)anchor;
                ret.setBorder(a.getBorder());
                ret.setOffset(a.getOffset());
                return ret;
            }
            return new BorderAnchor(nodeFigure, a.getBorder(), a.getOffset());
        }
        if (gmLinkAnchor instanceof GmPointAnchor) {
            GmPointAnchor pa = (GmPointAnchor)gmLinkAnchor;
            Dimension d = pa.getLocation();
            Point p = new Point(d.width, d.height);
            if (anchor instanceof PointAnchor && anchor.getOwner() == nodeFigure) {
                PointAnchor ret = (PointAnchor)anchor;
                ret.setLocation(p);
                return ret;
            }
            return new PointAnchor(nodeFigure, p);
        }
        if (gmLinkAnchor instanceof GmXYAnchor) {
            GmXYAnchor pa = (GmXYAnchor)gmLinkAnchor;
            Point p = pa.getReferencePoint();
            if (anchor instanceof XYAnchor) {
                XYAnchor ret = (XYAnchor)anchor;
                ret.setLocation(p);
                return ret;
            }
            return new XYAnchor(p);
        }
        if (gmLinkAnchor instanceof GmSourceSatelliteAnchor) {
            GmSourceSatelliteAnchor sa = (GmSourceSatelliteAnchor)gmLinkAnchor;
            IFigure srcFig = isTargetAnchor ? ((GraphicalEditPart)this.connectionEditPart.getSource()).getFigure() : ((GraphicalEditPart)this.connectionEditPart.getTarget()).getFigure();
            return new SatelliteAnchor(srcFig, sa.getLocation());
        }
        System.err.println("RectangleNodeAnchorProvider.updateConnectionAnchor(...): Obsolete " + gmLinkAnchor.getClass().getSimpleName() + " anchor used on" + (isTargetAnchor ? " target of:" : " source of:") + this.connectionEditPart.getModel());
        GmAbstractLinkAnchor a = (GmAbstractLinkAnchor)gmLinkAnchor;
        return this.updateConnectionAnchor(anchor, a.getLocation(), nodeFigure);
    }

    protected ConnectionAnchor getConnectionAnchor(GraphicalEditPart nodeEditPart, ReconnectRequest request, boolean source) throws IllegalArgumentException {
        IFigure fig = nodeEditPart.getFigure();
        Point figLocation = fig.getBounds().getTopLeft();
        fig.translateToAbsolute((Translatable)figLocation);
        Point requestLocation = request.getLocation();
        if (requestLocation == null) {
            throw new IllegalArgumentException(request + " has no location.");
        }
        this.init(request.getConnectionEditPart());
        Object gmLinkAnchor = source ? this.gmSourceAnchor : this.gmTargetAnchor;
        EditPart oldNodeEditPart = source ? this.connectionEditPart.getSource() : this.connectionEditPart.getTarget();
        Dimension r = requestLocation.getDifference(figLocation);
        fig.translateToRelative((Translatable)r);
        StyleKey.ConnectionRouterId router = this.getFigureRoutingMode();
        if (oldNodeEditPart == nodeEditPart) {
            ConnectionAnchor ret = AnchorRegistry.getFigAnchor((Object)gmLinkAnchor);
            if (this.needSlidableAnchor(router)) {
                if (ret instanceof RaySlidableAnchor && ret.getOwner() == fig) {
                    RaySlidableAnchor nodeAnchor = (RaySlidableAnchor)ret;
                    nodeAnchor.setReference(r);
                    return nodeAnchor;
                }
                ret = new RaySlidableAnchor(fig, r);
                AnchorRegistry.put((Object)gmLinkAnchor, (ConnectionAnchor)ret);
                return ret;
            }
            if (ret != null && ret.getClass() == NodeAnchor.class && ret.getOwner() == fig) {
                NodeAnchor nodeAnchor = (NodeAnchor)ret;
                nodeAnchor.setReference(r);
                return nodeAnchor;
            }
            ret = new NodeAnchor(fig, r);
            AnchorRegistry.put((Object)gmLinkAnchor, (ConnectionAnchor)ret);
            return ret;
        }
        if (this.needSlidableAnchor(router)) {
            return new RaySlidableAnchor(fig, r);
        }
        return new NodeAnchor(fig, r);
    }

    protected ConnectionAnchor getConnectionAnchor(GraphicalEditPart nodeEditPart, CreateRequest request, boolean source) throws IllegalArgumentException {
        IFigure fig = nodeEditPart.getFigure();
        Point figLocation = fig.getBounds().getTopLeft();
        fig.translateToAbsolute((Translatable)figLocation);
        Point p = request.getLocation();
        Dimension r = p.getDifference(figLocation);
        fig.translateToRelative((Translatable)r);
        if (source) {
            return new RaySlidableAnchor(fig, r);
        }
        return new NodeAnchor(fig, r);
    }

    protected boolean needSlidableAnchor(StyleKey.ConnectionRouterId router) {
        return router == StyleKey.ConnectionRouterId.ORTHOGONAL && !this.raked;
    }

    protected ConnectionAnchor updateConnectionAnchor(ConnectionAnchor anchor, Dimension pos, IFigure nodeFigure) {
        StyleKey.ConnectionRouterId routerKind;
        StyleKey.ConnectionRouterId connectionRouterId = routerKind = this.raked ? StyleKey.ConnectionRouterId.BENDPOINT : this.gmLink.getPath().getRouterKind();
        if (this.needSlidableAnchor(routerKind)) {
            IFigure fig = nodeFigure;
            if (anchor instanceof RaySlidableAnchor && anchor.getOwner() == nodeFigure) {
                RaySlidableAnchor ret = (RaySlidableAnchor)anchor;
                ret.setReference(pos);
                return ret;
            }
            return new RaySlidableAnchor(fig, pos);
        }
        if (anchor instanceof NodeAnchor && anchor.getOwner() == nodeFigure) {
            NodeAnchor ret = (NodeAnchor)anchor;
            ret.setReference(pos);
            return ret;
        }
        return new NodeAnchor(nodeFigure, pos);
    }

    private StyleKey.ConnectionRouterId getFigureRoutingMode() {
        Connection conn = (Connection)this.connectionEditPart.getFigure();
        ConnectionRouter router = conn.getConnectionRouter();
        if (router instanceof OrthogonalRouter) {
            return StyleKey.ConnectionRouterId.ORTHOGONAL;
        }
        if (router instanceof BendpointConnectionRouter) {
            return StyleKey.ConnectionRouterId.BENDPOINT;
        }
        if (router == null || router instanceof ConnectionRouter.NullConnectionRouter) {
            return StyleKey.ConnectionRouterId.DIRECT;
        }
        if (router instanceof RakeRouter) {
            return StyleKey.ConnectionRouterId.ORTHOGONAL;
        }
        throw new IllegalArgumentException(router + " not handled.");
    }

    private void init(ConnectionEditPart aConnectionEditPart) {
        this.connectionEditPart = aConnectionEditPart;
        this.gmLink = (GmLink)aConnectionEditPart.getModel();
        IGmPath path = this.gmLink.getPath();
        this.gmSourceAnchor = path.getSourceAnchor();
        this.gmTargetAnchor = path.getTargetAnchor();
        this.raked = this.isRaked(path);
    }

    private boolean isRaked(IGmPath p) {
        return p.getSourceRake() != null || p.getTargetRake() != null;
    }

    protected ConnectionAnchor getMPConnectionAnchor(GraphicalEditPart nodeEditPart, CreateMultiPointRequest request, boolean source) throws IllegalArgumentException {
        IFigure fig = nodeEditPart.getFigure();
        Point figLocation = fig.getBounds().getTopLeft();
        fig.translateToAbsolute((Translatable)figLocation);
        Point p = request.getLocation();
        Dimension r = p.getDifference(figLocation);
        fig.translateToRelative((Translatable)r);
        return new NodeAnchor(fig, r);
    }
}

