/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.policies;

import com.modeliosoft.modelio.diagram.elements.core.commands.DefaultAddBendPointCommand;
import com.modeliosoft.modelio.diagram.elements.core.commands.DefaultDeleteBendPointCommand;
import com.modeliosoft.modelio.diagram.elements.core.commands.DefaultMoveBendPointCommand;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLink;
import com.modeliosoft.modelio.diagram.elements.core.link.ortho.TranslateBendpointsCommand;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmPath;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.XYAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.BendpointEditPolicy;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class DefaultBendpointEditPolicy
extends BendpointEditPolicy {
    private ConnectionAnchor originalSourceAnchor;
    private ConnectionAnchor originalTargetAnchor;
    private List<Bendpoint> originalConstraint;
    private static final List<Bendpoint> NULL_CONSTRAINT = new ArrayList();

    protected Command getCreateBendpointCommand(BendpointRequest request) {
        int index = request.getIndex();
        Point point = request.getLocation().getCopy();
        this.getConnection().translateToRelative((Translatable)point);
        AbsoluteBendpoint newpoint = new AbsoluteBendpoint(point);
        return new DefaultAddBendPointCommand((GmLink)request.getSource().getModel(), index, (Bendpoint)newpoint);
    }

    protected Command getDeleteBendpointCommand(BendpointRequest request) {
        int index = request.getIndex();
        return new DefaultDeleteBendPointCommand((GmLink)request.getSource().getModel(), index);
    }

    protected Command getMoveBendpointCommand(BendpointRequest request) {
        int index = request.getIndex();
        Point point = request.getLocation().getCopy();
        this.getConnection().translateToRelative((Translatable)point);
        AbsoluteBendpoint newpoint = new AbsoluteBendpoint(point);
        return new DefaultMoveBendPointCommand((GmLink)request.getSource().getModel(), index, (Bendpoint)newpoint);
    }

    public Command getCommand(Request request) {
        if ("move".equals(request.getType()) || "add children".equals(request.getType())) {
            return this.getMoveCommand((ChangeBoundsRequest)request);
        }
        return super.getCommand(request);
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        ConnectionAnchor currentSourceAnchor = this.getConnection().getSourceAnchor();
        ConnectionAnchor currentTargetAnchor = this.getConnection().getTargetAnchor();
        this.getConnection().setSourceAnchor(this.originalSourceAnchor);
        this.getConnection().setTargetAnchor(this.originalTargetAnchor);
        ConnectionEditPart hostEP = (ConnectionEditPart)this.getHost();
        IGmPath path = ((GmLink)hostEP.getModel()).getPath();
        TranslateBendpointsCommand command = new TranslateBendpointsCommand(path, hostEP);
        this.getConnection().setSourceAnchor(currentSourceAnchor);
        this.getConnection().setTargetAnchor(currentTargetAnchor);
        return command;
    }

    public boolean understandsRequest(Request req) {
        if ("move".equals(req.getType())) {
            return true;
        }
        return super.understandsRequest(req);
    }

    protected void eraseConnectionFeedback(BendpointRequest request) {
        super.eraseConnectionFeedback(request);
        this.originalConstraint = null;
        this.originalSourceAnchor = null;
        this.originalTargetAnchor = null;
    }

    public void eraseSourceFeedback(Request request) {
        if ("move".equals(request.getType()) || "add children".equals(request.getType())) {
            this.eraseChangeBoundsFeedback((ChangeBoundsRequest)request);
        } else {
            super.eraseSourceFeedback(request);
        }
    }

    protected void restoreOriginalConstraint() {
        if (this.originalConstraint != null) {
            if (this.originalConstraint == NULL_CONSTRAINT) {
                this.getConnection().setRoutingConstraint(null);
            } else {
                this.getConnection().setRoutingConstraint((Object)this.originalConstraint);
            }
        }
        this.getConnection().setSourceAnchor(this.originalSourceAnchor);
        this.getConnection().setTargetAnchor(this.originalTargetAnchor);
        super.restoreOriginalConstraint();
    }

    protected void saveOriginalConstraint() {
        super.saveOriginalConstraint();
        this.originalConstraint = (List)this.getConnection().getRoutingConstraint();
        if (this.originalConstraint == null) {
            this.originalConstraint = NULL_CONSTRAINT;
        }
        this.getConnection().setRoutingConstraint(new ArrayList(this.originalConstraint));
        this.originalSourceAnchor = this.getConnection().getSourceAnchor();
        this.originalTargetAnchor = this.getConnection().getTargetAnchor();
    }

    public void showSourceFeedback(Request request) {
        if ("move".equals(request.getType()) || "add children".equals(request.getType())) {
            this.showChangeBoundsFeedback((ChangeBoundsRequest)request);
        } else {
            super.showSourceFeedback(request);
        }
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        if (this.originalConstraint == null) {
            this.saveOriginalConstraint();
        }
        Connection connection = this.getConnection();
        ArrayList<AbsoluteBendpoint> newConstraint = new ArrayList<AbsoluteBendpoint>();
        for (Bendpoint bendpoint : this.originalConstraint) {
            Point location = Point.SINGLETON;
            location.setLocation(bendpoint.getLocation());
            connection.translateToAbsolute((Translatable)location);
            location.translate(request.getMoveDelta());
            connection.translateToRelative((Translatable)location);
            newConstraint.add(new AbsoluteBendpoint(location));
        }
        this.getConnection().setSourceAnchor((ConnectionAnchor)new XYAnchor(this.originalSourceAnchor.getReferencePoint().getTranslated(request.getMoveDelta())));
        this.getConnection().setTargetAnchor((ConnectionAnchor)new XYAnchor(this.originalTargetAnchor.getReferencePoint().getTranslated(request.getMoveDelta())));
        this.getConnection().setRoutingConstraint(newConstraint);
    }

    protected void eraseChangeBoundsFeedback(ChangeBoundsRequest request) {
        this.restoreOriginalConstraint();
        this.originalConstraint = null;
        this.originalSourceAnchor = null;
        this.originalTargetAnchor = null;
    }
}

