/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.policies;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.commands.ModelioCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.figures.FigureUtilities2;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import com.modeliosoft.modelio.diagram.elements.core.policies.RevealEditPartCommand;
import com.modeliosoft.modelio.diagram.elements.core.requests.ModelElementDropRequest;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.InputEvent;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SelectionRequest;

public class DefaultElementDropEditPolicy
extends GraphicalEditPolicy {
    protected IFigure highlight;
    protected FigureUtilities2.HighlightType highlightType;

    public EditPart getTargetEditPart(Request request) {
        if (request.getType().equals("DROPELEMENT")) {
            return this.getDropTargetEditPart((ModelElementDropRequest)request);
        }
        return null;
    }

    public Command getCommand(Request request) {
        if (request.getType().equals("DROPELEMENT")) {
            Command command = this.getSmartDropCommand((ModelElementDropRequest)request);
            if (command == null) {
                return this.getDropCommand((ModelElementDropRequest)request);
            }
            return command;
        }
        return null;
    }

    protected Command getDropCommand(ModelElementDropRequest request) {
        CompoundCommand command = new CompoundCommand();
        Point dropLocation = request.getDropLocation();
        IElement[] iElementArray = request.getDroppedElements();
        int n = iElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IElement toUnmask = iElementArray[n2];
            GmModel hostModel = (GmModel)this.getHost().getModel();
            GmAbstractDiagram gmDiagram = hostModel.getDiagram();
            GmModel previousUnmask = this.getVisibleModelFor(toUnmask, gmDiagram);
            if (previousUnmask == null) {
                this.createDropCommandForNode(command, dropLocation, toUnmask);
                dropLocation = dropLocation.getTranslated(20, 20);
            } else {
                this.createSelectionCommand(command, previousUnmask);
            }
            ++n2;
        }
        return command.unwrap();
    }

    protected EditPart getDropTargetEditPart(ModelElementDropRequest request) {
        IElement[] iElementArray = request.getDroppedElements();
        int n = iElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IElement droppedElement = iElementArray[n2];
            GmModel hostModel = (GmModel)this.getHost().getModel();
            if (!hostModel.canUnmask(droppedElement)) {
                return null;
            }
            ++n2;
        }
        return this.getHost();
    }

    public void showTargetFeedback(Request request) {
        if (request.getType().equals("DROPELEMENT")) {
            Command c = this.getCommand(request);
            FigureUtilities2.HighlightType newHighlightType = FigureUtilities2.HighlightType.INFO;
            newHighlightType = c == null ? FigureUtilities2.HighlightType.ERROR : (c.canExecute() ? FigureUtilities2.HighlightType.SUCCESS : FigureUtilities2.HighlightType.WARNING);
            if (newHighlightType != this.highlightType) {
                this.highlightType = newHighlightType;
                if (this.highlight == null) {
                    this.highlight = FigureUtilities2.createHighlightFigure((IFigure)this.getFeedbackLayer(), (IFigure)this.getHostFigure(), (FigureUtilities2.HighlightType)this.highlightType);
                    this.getFeedbackLayer().add(this.highlight);
                }
                FigureUtilities2.updateHighlightType((IFigure)this.highlight, (FigureUtilities2.HighlightType)this.highlightType);
            }
        }
        super.showTargetFeedback(request);
    }

    public void eraseTargetFeedback(Request request) {
        if (request.getType().equals("DROPELEMENT") && this.highlight != null) {
            this.removeFeedback(this.highlight);
            this.highlight = null;
            this.highlightType = null;
        }
        super.eraseTargetFeedback(request);
    }

    protected Command getSmartDropCommand(ModelElementDropRequest request) {
        return null;
    }

    protected void createSelectionCommand(CompoundCommand command, GmModel toSelect) {
        SelectionRequest request = new SelectionRequest();
        request.setType((Object)"selection");
        request.setLastButtonPressed(InputEvent.ANY_BUTTON);
        EditPart toSelectEditPart = (EditPart)this.getHost().getViewer().getEditPartRegistry().get(toSelect);
        EditPart target = null;
        if (toSelectEditPart != null) {
            Command selectionCommand;
            target = toSelectEditPart.getTargetEditPart((Request)request);
            if (target == null) {
                target = toSelectEditPart;
            }
            if ((selectionCommand = target.getCommand((Request)request)) == null) {
                selectionCommand = new RevealEditPartCommand(target);
            }
            command.add(selectionCommand);
        }
    }

    protected void createDropCommandForNode(CompoundCommand command, Point dropLocation, IElement toUnmask) {
        CreateRequest req = new CreateRequest();
        req.setLocation(dropLocation);
        req.setSize(new Dimension(-1, -1));
        req.setFactory((CreationFactory)new ModelioCreationContext(toUnmask));
        EditPart targetPart = this.getHost().getTargetEditPart((Request)req);
        if (targetPart != null) {
            command.add(targetPart.getCommand((Request)req));
        }
    }

    protected GmModel getVisibleModelFor(IElement element, GmAbstractDiagram inDiagram) {
        List allGMRepresenting = inDiagram.getAllGMRepresenting(new ObRef(element));
        for (GmModel gmRepresenting : allGMRepresenting) {
            if (gmRepresenting instanceof GmNodeModel && !((GmNodeModel)gmRepresenting).isVisible()) continue;
            return gmRepresenting;
        }
        return null;
    }
}

