/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.policies;

import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.diagram.elements.core.policies.DefaultNodeResizableEditPolicy;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class SmallNodeNonResizeableEditPolicy
extends DefaultNodeResizableEditPolicy {
    protected List<IFigure> feedbackFigures = new ArrayList();

    protected IFigure createDragSourceFeedbackFigure() {
        IFigure fig = this.getHostFigure();
        try {
            Connection connFig;
            Connection origConn;
            GraphicalEditPart connPart;
            IFigure feed = (IFigure)fig.getClass().newInstance();
            feed.setBounds(fig.getBounds());
            if (feed instanceof Shape) {
                ((Shape)feed).setLineStyle(2);
            }
            this.getFeedbackLayer().add(feed);
            GraphicalEditPart host = (GraphicalEditPart)this.getHost();
            for (Object c : host.getSourceConnections()) {
                connPart = (GraphicalEditPart)c;
                origConn = (Connection)connPart.getFigure();
                connFig = (Connection)origConn.getClass().newInstance();
                connFig.setSourceAnchor((ConnectionAnchor)new ChopboxAnchor(feed));
                connFig.setTargetAnchor(origConn.getTargetAnchor());
                connFig.setConnectionRouter(origConn.getConnectionRouter());
                connFig.setRoutingConstraint(origConn.getRoutingConstraint());
                if (connFig instanceof Shape) {
                    ((Shape)connFig).setLineStyle(2);
                }
                this.feedbackFigures.add(connFig);
                this.getFeedbackLayer().add((IFigure)connFig);
            }
            for (Object c : host.getTargetConnections()) {
                connPart = (GraphicalEditPart)c;
                origConn = (Connection)connPart.getFigure();
                connFig = (Connection)origConn.getClass().newInstance();
                connFig.setSourceAnchor(origConn.getSourceAnchor());
                connFig.setTargetAnchor((ConnectionAnchor)new ChopboxAnchor(feed));
                connFig.setConnectionRouter(origConn.getConnectionRouter());
                connFig.setRoutingConstraint(origConn.getRoutingConstraint());
                if (connFig instanceof Shape) {
                    ((Shape)connFig).setLineStyle(2);
                }
                this.feedbackFigures.add(connFig);
                this.getFeedbackLayer().add((IFigure)connFig);
            }
            return feed;
        }
        catch (InstantiationException e) {
            LOG.error((String)"org.modelio.diagram.elements", (Throwable)e);
            return super.createDragSourceFeedbackFigure();
        }
        catch (IllegalAccessException e) {
            LOG.error((String)"org.modelio.diagram.elements", (Throwable)e);
            return super.createDragSourceFeedbackFigure();
        }
    }

    protected List<?> createSelectionHandles() {
        ArrayList<MoveHandle> ret = new ArrayList<MoveHandle>();
        ret.add(new MoveHandle((GraphicalEditPart)this.getHost()));
        return ret;
    }

    protected void eraseChangeBoundsFeedback(ChangeBoundsRequest request) {
        super.eraseChangeBoundsFeedback(request);
        for (IFigure f : this.feedbackFigures) {
            f.getParent().remove(f);
        }
        this.feedbackFigures.clear();
    }

    protected Command getResizeCommand(ChangeBoundsRequest request) {
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"resize children");
        req.setEditParts(this.getHost());
        req.setMoveDelta(request.getMoveDelta());
        req.setSizeDelta(this.computeSizeDelta());
        req.setLocation(request.getLocation());
        req.setExtendedData(request.getExtendedData());
        req.setResizeDirection(request.getResizeDirection());
        return this.getHost().getParent().getCommand((Request)req);
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        super.showChangeBoundsFeedback(request);
    }

    private Dimension computeSizeDelta() {
        IFigure fig = this.getHostFigure();
        return fig.getPreferredSize().getDifference(fig.getBounds().getSize());
    }
}

