/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.tools.multipoint;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.model.MetaModelExpert;
import com.modeliosoft.modelio.diagram.elements.core.figures.FigureUtilities2;
import com.modeliosoft.modelio.diagram.elements.core.link.ModelioLinkCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.tools.multipoint.CreateMultiPointRequest;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.FeedbackHelper;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;

public abstract class MultiPointCreationEditPolicy
extends GraphicalEditPolicy {
    private boolean isOpaque = true;
    protected List<FeedbackHelper> feedbackHelpers = new ArrayList();
    protected List<Connection> connectionFeedbacks = new ArrayList();
    private static final String HIGHLIGHTKEY = "HIGHLIGHTKEY";

    public MultiPointCreationEditPolicy() {
        this(true);
    }

    public MultiPointCreationEditPolicy(boolean isOpaque) {
        this.isOpaque = isOpaque;
    }

    public void deactivate() {
        if (!this.connectionFeedbacks.isEmpty()) {
            for (Connection connectionFeedback : this.connectionFeedbacks) {
                this.removeFeedback((IFigure)connectionFeedback);
            }
            this.feedbackHelpers.clear();
            this.connectionFeedbacks.clear();
        }
        super.deactivate();
    }

    public void eraseSourceFeedback(Request request) {
        if ("MultiPoint Additional".equals(request.getType()) || "MultiPoint Last".equals(request.getType())) {
            this.eraseCreationFeedback((CreateMultiPointRequest)request);
        }
    }

    public void eraseTargetFeedback(Request request) {
        if ("Multipoint First".equals(request.getType()) || "MultiPoint Additional".equals(request.getType()) || "MultiPoint Last".equals(request.getType())) {
            this.eraseTargetConnectionFeedback((CreateMultiPointRequest)request);
        }
    }

    public Command getCommand(Request request) {
        if ("Multipoint First".equals(request.getType())) {
            CreateMultiPointRequest multiPointRequest = (CreateMultiPointRequest)request;
            return this.getMultiPointFirstCommand(multiPointRequest);
        }
        if ("MultiPoint Additional".equals(request.getType())) {
            CreateMultiPointRequest multiPointRequest = (CreateMultiPointRequest)request;
            return this.getMultiPointAdditionalCommand(multiPointRequest);
        }
        if ("MultiPoint Last".equals(request.getType())) {
            CreateMultiPointRequest multiPointRequest = (CreateMultiPointRequest)request;
            return this.buildMultiPointFinalCommand(multiPointRequest);
        }
        return null;
    }

    public EditPart getTargetEditPart(Request request) {
        if ("Multipoint First".equals(request.getType())) {
            return this.isOpaque ? this.getHost() : this.getTargetEditPartFirst((CreateMultiPointRequest)request);
        }
        if ("MultiPoint Additional".equals(request.getType())) {
            return this.isOpaque ? this.getHost() : this.getTargetEditPartAdditional((CreateMultiPointRequest)request);
        }
        if ("MultiPoint Last".equals(request.getType())) {
            return this.isOpaque ? this.getHost() : this.getTargetEditPartLast((CreateMultiPointRequest)request);
        }
        return null;
    }

    public void showSourceFeedback(Request request) {
        if ("MultiPoint Last".equals(request.getType())) {
            this.showCreationFeedback((CreateMultiPointRequest)request);
        }
    }

    public void showTargetFeedback(Request request) {
        if ("Multipoint First".equals(request.getType()) || "MultiPoint Additional".equals(request.getType()) || "MultiPoint Last".equals(request.getType())) {
            this.showTargetConnectionFeedback((CreateMultiPointRequest)request);
        }
    }

    public boolean understandsRequest(Request req) {
        return super.understandsRequest(req);
    }

    protected Connection createDummyConnection(CreateMultiPointRequest req, EditPart source) {
        return new PolylineConnection();
    }

    protected void eraseCreationFeedback(CreateMultiPointRequest request) {
        if (!this.connectionFeedbacks.isEmpty()) {
            for (Connection connectionFeedback : this.connectionFeedbacks) {
                this.removeFeedback((IFigure)connectionFeedback);
            }
            this.feedbackHelpers.clear();
            this.connectionFeedbacks.clear();
        }
    }

    protected void eraseTargetConnectionFeedback(CreateMultiPointRequest request) {
        IFigure highlight = (IFigure)request.getExtendedData().get(HIGHLIGHTKEY);
        if (highlight != null) {
            IFigure feedbackLayer = this.getFeedbackLayer();
            if (highlight.getParent() == feedbackLayer) {
                feedbackLayer.remove(highlight);
                if (feedbackLayer.getLayoutManager() != null) {
                    feedbackLayer.getLayoutManager().remove(highlight);
                }
                request.getExtendedData().remove(HIGHLIGHTKEY);
            }
        }
    }

    protected final Class<? extends IElement> getCreationMetaclass(CreateMultiPointRequest request) {
        ModelioLinkCreationContext ctx = (ModelioLinkCreationContext)request.getNewObject();
        Class metaclass = MetaModelExpert.getMetaclass((String)ctx.getMetaclass());
        return metaclass;
    }

    protected ConnectionRouter getDummyConnectionRouter(CreateMultiPointRequest request, EditPart source) {
        return ((ConnectionLayer)this.getLayer((Object)"Connection Layer")).getConnectionRouter();
    }

    protected List<FeedbackHelper> getFeedbackHelper(CreateMultiPointRequest request) {
        if (this.feedbackHelpers.isEmpty()) {
            EditPart sourceNode = this.getHost();
            FeedbackHelper feedbackHelper = new FeedbackHelper();
            Connection connectionFeedback = this.createDummyConnection(request, sourceNode);
            connectionFeedback.setConnectionRouter(this.getDummyConnectionRouter(request, sourceNode));
            connectionFeedback.setSourceAnchor(this.getSourceConnectionAnchor(request, sourceNode));
            feedbackHelper.setConnection(connectionFeedback);
            this.addFeedback((IFigure)connectionFeedback);
            feedbackHelper.update(null, request.getLocation());
            this.connectionFeedbacks.add(connectionFeedback);
            this.feedbackHelpers.add(feedbackHelper);
        }
        return this.feedbackHelpers;
    }

    protected abstract Command getMultiPointAdditionalCommand(CreateMultiPointRequest var1);

    protected abstract Command getMultiPointFinalCommand(CreateMultiPointRequest var1);

    protected abstract Command getMultiPointFirstCommand(CreateMultiPointRequest var1);

    protected ConnectionAnchor getSourceConnectionAnchor(CreateMultiPointRequest request, EditPart source) {
        return source instanceof NodeEditPart ? ((NodeEditPart)source).getSourceConnectionAnchor((Request)request) : null;
    }

    protected ConnectionAnchor getTargetConnectionAnchor(CreateMultiPointRequest request) {
        EditPart target = request.getTargetEditPart();
        return target instanceof NodeEditPart ? ((NodeEditPart)target).getTargetConnectionAnchor((Request)request) : null;
    }

    protected EditPart getTargetEditPartAdditional(CreateMultiPointRequest request) {
        return this.getHost();
    }

    protected EditPart getTargetEditPartFirst(CreateMultiPointRequest request) {
        return this.getHost();
    }

    protected EditPart getTargetEditPartLast(CreateMultiPointRequest request) {
        return this.getHost();
    }

    protected final boolean isCreationOf(CreateMultiPointRequest request, Class<?> c) {
        Class metaclass = this.getCreationMetaclass(request);
        return c.isAssignableFrom(metaclass);
    }

    protected void showCreationFeedback(CreateMultiPointRequest request) {
        Point p = new Point(request.getLocation());
        for (FeedbackHelper helper : this.getFeedbackHelper(request)) {
            helper.update(this.getTargetConnectionAnchor(request), p);
        }
    }

    protected void showTargetConnectionFeedback(CreateMultiPointRequest request) {
        Command c = this.getHost().getCommand((Request)request);
        FigureUtilities2.HighlightType hightlightType = FigureUtilities2.HighlightType.INFO;
        hightlightType = c == null ? FigureUtilities2.HighlightType.ERROR : (c.canExecute() ? FigureUtilities2.HighlightType.SUCCESS : FigureUtilities2.HighlightType.WARNING);
        IFigure highlight = (IFigure)request.getExtendedData().get(HIGHLIGHTKEY);
        if (highlight == null) {
            highlight = FigureUtilities2.createHighlightFigure((IFigure)this.getFeedbackLayer(), (IFigure)this.getHostFigure(), (FigureUtilities2.HighlightType)hightlightType);
            this.getFeedbackLayer().add(highlight);
            request.getExtendedData().put(HIGHLIGHTKEY, highlight);
        }
        FigureUtilities2.updateHighlightType((IFigure)highlight, (FigureUtilities2.HighlightType)hightlightType);
    }

    private Command buildMultiPointFinalCommand(CreateMultiPointRequest multiPointRequest) {
        CompoundCommand compound = new CompoundCommand();
        for (Command command : multiPointRequest.getStartCommands()) {
            if (command == null || !command.canExecute()) continue;
            compound.add(command);
        }
        compound.add(this.getMultiPointFinalCommand(multiPointRequest));
        return compound.unwrap();
    }
}

