/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.tools.multipoint;

import com.modeliosoft.modelio.diagram.elements.core.tools.multipoint.CreateMultiPointRequest;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.tools.TargetingTool;
import org.eclipse.swt.graphics.Cursor;

public class MultiPointCreationTool
extends TargetingTool {
    protected static final int STATE_MULTIPOINT_STARTED = 64;
    protected static final int MAX_STATE = 64;
    private static final int FLAG_SOURCE_FEEDBACK = 64;
    protected static final int MAX_FLAG = 64;
    private List<EditPart> connectionSources = new ArrayList();
    private CreationFactory factory;
    private EditPartViewer viewer;
    private EditPartListener.Stub deactivationListener = new /* Unavailable Anonymous Inner Class!! */;

    public MultiPointCreationTool() {
        this.setDefaultCursor(SharedCursors.CURSOR_PLUG);
        this.setDisabledCursor(SharedCursors.CURSOR_PLUG_NOT);
    }

    public MultiPointCreationTool(CreationFactory factory) {
        this();
        this.setFactory(factory);
    }

    public void deactivate() {
        this.eraseSourceFeedback();
        this.clearConnectionSources();
        super.deactivate();
        this.setState(0x40000000);
        this.viewer = null;
    }

    public void setFactory(CreationFactory factory) {
        this.factory = factory;
    }

    protected void addConnectionSource(EditPart source) {
        if (source != null) {
            source.addEditPartListener((EditPartListener)this.deactivationListener);
            this.connectionSources.add(source);
        }
    }

    protected Cursor calculateCursor() {
        if (this.isInState(1) && this.getCurrentCommand() != null) {
            return this.getDefaultCursor();
        }
        return super.calculateCursor();
    }

    protected void clearConnectionSources() {
        for (EditPart connectionSource : this.connectionSources) {
            connectionSource.removeEditPartListener((EditPartListener)this.deactivationListener);
        }
        this.connectionSources.clear();
    }

    protected Request createTargetRequest() {
        CreateMultiPointRequest req = new CreateMultiPointRequest();
        req.setFactory(this.getFactory());
        return req;
    }

    protected void eraseSourceFeedback() {
        if (!this.isShowingSourceFeedback()) {
            return;
        }
        this.setFlag(64, false);
        for (EditPart connectionSource : this.connectionSources) {
            connectionSource.eraseSourceFeedback(this.getSourceRequest());
        }
    }

    protected String getCommandName() {
        assert (false) : "this method should never get called!";
        return null;
    }

    protected String getDebugName() {
        return "MultiPoint Creation Tool";
    }

    protected String getDebugNameForState(int s) {
        if (s == 64 || s == 32) {
            return "Multi Point Started";
        }
        return super.getDebugNameForState(s);
    }

    protected CreationFactory getFactory() {
        return this.factory;
    }

    protected Request getSourceRequest() {
        return this.getTargetRequest();
    }

    protected CreateMultiPointRequest getTargetRequest() {
        return (CreateMultiPointRequest)super.getTargetRequest();
    }

    protected boolean handleButtonDown(int button) {
        Object reqType = this.getTargetRequest().getType();
        if (button == 1 && "MultiPoint Last".equals(reqType)) {
            this.setState(0x40000000);
            return this.handleCreation();
        }
        if (this.isInState(65) && button == 1) {
            Command command;
            this.updateTargetRequest();
            this.updateTargetUnderMouse();
            if (this.getTargetEditPart() != null && (command = this.getCommand()) != null) {
                if ("Multipoint First".equals(reqType) || "MultiPoint Additional".equals(reqType)) {
                    this.addConnectionSource(this.getTargetEditPart());
                    this.getTargetRequest().addSourceEditPart(this.getTargetEditPart());
                }
                this.getTargetRequest().addStartCommand(command);
                this.setState(64);
                this.setCurrentCommand(command);
                this.viewer = this.getCurrentViewer();
            }
        }
        if (this.isInState(1) && button != 1) {
            this.setState(8);
            this.handleInvalidInput();
        }
        if (this.isInState(64)) {
            this.handleDrag();
        }
        return true;
    }

    protected boolean handleButtonUp(int button) {
        if (this.isInState(0x40000008)) {
            this.handleFinished();
        }
        return true;
    }

    protected boolean handleCommandStackChanged() {
        if (!this.isInState(1)) {
            if (this.getCurrentInput().isMouseButtonDown(1)) {
                this.setState(8);
            } else {
                this.setState(1);
            }
            this.handleInvalidInput();
            return true;
        }
        return false;
    }

    protected boolean handleCreation() {
        this.eraseSourceFeedback();
        Command endCommand = this.getCommand();
        this.setCurrentCommand(endCommand);
        this.executeCurrentCommand();
        return true;
    }

    protected boolean handleDrag() {
        if (this.isInState(64)) {
            return this.handleMove();
        }
        return false;
    }

    protected boolean handleDragInProgress() {
        if (this.isInState(32)) {
            return this.handleMove();
        }
        return false;
    }

    protected boolean handleEnteredEditPart() {
        this.showTargetFeedback();
        return true;
    }

    protected boolean handleFocusLost() {
        if (this.isInState(64)) {
            this.eraseSourceFeedback();
            this.eraseTargetFeedback();
            this.setState(8);
            this.handleFinished();
        }
        return super.handleFocusLost();
    }

    protected boolean handleHover() {
        if (this.isInState(64)) {
            this.updateAutoexposeHelper();
        }
        return true;
    }

    protected boolean handleInvalidInput() {
        this.eraseSourceFeedback();
        this.clearConnectionSources();
        return super.handleInvalidInput();
    }

    protected boolean handleMove() {
        if (this.isInState(64) && this.viewer != this.getCurrentViewer()) {
            return false;
        }
        if (this.isInState(97)) {
            this.updateTargetRequest();
            this.updateTargetUnderMouse();
            this.showSourceFeedback();
            this.showTargetFeedback();
            this.setCurrentCommand(this.getCommand());
        }
        return true;
    }

    protected void handleSourceDeactivated() {
        this.setState(8);
        this.handleInvalidInput();
        this.handleFinished();
    }

    protected boolean isShowingSourceFeedback() {
        return this.getFlag(64);
    }

    protected void showSourceFeedback() {
        for (EditPart connectionSource : this.connectionSources) {
            connectionSource.showSourceFeedback(this.getSourceRequest());
        }
        this.setFlag(64, true);
    }

    protected void updateTargetRequest() {
        CreateMultiPointRequest request = this.getTargetRequest();
        if (this.isInState(1)) {
            request.setType((Object)"Multipoint First");
        } else {
            request.setType((Object)"MultiPoint Additional");
        }
        request.setLocation(this.getLocation());
    }

    protected boolean updateTargetUnderMouse() {
        if (!this.isTargetLocked()) {
            EditPart editPart = this.getCurrentViewer().findObjectAtExcluding(this.getLocation(), this.getExclusionSet(), this.getTargetingConditional());
            if (editPart == null || editPart.getTargetEditPart((Request)this.getTargetRequest()) == null) {
                this.getTargetRequest().setType((Object)"MultiPoint Last");
                editPart = this.getCurrentViewer().findObjectAtExcluding(this.getLocation(), this.getExclusionSet(), this.getTargetingConditional());
            }
            if (editPart != null) {
                editPart = editPart.getTargetEditPart((Request)this.getTargetRequest());
            }
            boolean changed = this.getTargetEditPart() != editPart;
            this.setTargetEditPart(editPart);
            return changed;
        }
        return false;
    }
}

