/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.gmfactory;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITagParameter;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITaggedValue;
import com.modeliosoft.modelio.api.model.uml.statik.IParameter;
import com.modeliosoft.modelio.api.utils.IMetamodelVisitor;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.common.group.GmGroup;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmNodeFactory;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import com.modeliosoft.modelio.diagram.elements.gmfactory.GmNodeFactory;
import java.util.HashMap;
import java.util.Map;

public class GmNodeFactory
implements IGmNodeFactory {
    private Map<String, IGmNodeFactory> cascadedFactories = new HashMap();
    private static final GmNodeFactory instance = new GmNodeFactory();

    public static IGmNodeFactory getInstance() {
        return instance;
    }

    private GmNodeFactory() {
    }

    public GmNodeModel create(GmAbstractDiagram diagram, GmCompositeNode parent, IElement newElement, Object initialLayoutData) {
        GmNodeModel child;
        GroupElementFactoryVisitor v;
        for (IGmNodeFactory factory : this.cascadedFactories.values()) {
            GmNodeModel nodeModel = factory.create(diagram, parent, newElement, initialLayoutData);
            if (nodeModel == null) continue;
            return nodeModel;
        }
        if (parent instanceof GmGroup) {
            v = new GroupElementFactoryVisitor(this, diagram, initialLayoutData);
            child = (GmNodeModel)newElement.accept((IMetamodelVisitor)v);
            parent.addChild(child);
            return child;
        }
        v = new NodeFactoryVisitor(this, diagram, parent, initialLayoutData);
        child = (GmNodeModel)newElement.accept((IMetamodelVisitor)v);
        parent.addChild(child);
        return child;
    }

    public Class<?> getClass(String className) {
        Class ret = null;
        for (IGmNodeFactory f : this.cascadedFactories.values()) {
            ret = f.getClass(className);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public boolean isRepresentable(Class<? extends IElement> metaclass) {
        return metaclass != ITaggedValue.class && metaclass != ITagParameter.class && metaclass != IParameter.class;
    }

    public void registerFactory(String id, IGmNodeFactory factory) {
        this.cascadedFactories.put(id, factory);
    }

    public void unregisterFactory(String id) {
        this.cascadedFactories.remove(id);
    }
}

