/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.persistence;

import com.modeliosoft.modelio.diagram.elements.plugin.DiagramElement;
import com.modeliosoft.modelio.diagram.persistence.IExtReferenceResolver;
import com.modeliosoft.modelio.diagram.persistence.IPersistent;
import com.modeliosoft.modelio.diagram.persistence.PersistenceException;
import com.modeliosoft.modelio.diagram.styles.core.FactoryStyle;
import com.modeliosoft.modelio.diagram.styles.core.NamedStyle;
import com.modeliosoft.modelio.diagram.styles.manager.StyleManager;
import com.modeliosoft.modelio.diagram.styles.plugin.DiagramStyles;

public class ExtReferenceResolver
implements IExtReferenceResolver {
    public IPersistent resolveReference(String type, String dbId, String extId) throws PersistenceException {
        try {
            Class<?> clazz = Class.forName(type);
            return this.resolveReference(clazz, extId);
        }
        catch (ClassNotFoundException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    private IPersistent resolveReference(Class<?> clazz, String extId) {
        if (clazz == FactoryStyle.class) {
            return FactoryStyle.getInstance();
        }
        if (clazz == NamedStyle.class) {
            StyleManager repo = DiagramStyles.getInstance().getStyleManager();
            NamedStyle ret = repo.getStyle(extId);
            if (ret == null) {
                ret = repo.createStyle(DiagramElement.getInstance().getModelingSession().getProjectSpacePath(), extId);
            }
            return ret;
        }
        throw new PersistenceException("External references for '" + clazz.getSimpleName() + "' not handled");
    }
}

