/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.persistence;

import com.modeliosoft.modelio.diagram.elements.gmfactory.GmNodeFactory;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IInstanceFactory;
import com.modeliosoft.modelio.diagram.persistence.PersistenceException;
import com.modeliosoft.modelio.diagram.styles.core.FactoryStyle;
import com.modeliosoft.modelio.diagram.styles.core.IStyle;
import com.modeliosoft.modelio.diagram.styles.core.NamedStyle;
import com.modeliosoft.modelio.diagram.styles.core.Style;

public class InstanceFactory
implements IInstanceFactory {
    private Class<?> getClass(String elementType) throws PersistenceException {
        Class clazz = null;
        try {
            clazz = Class.forName(elementType);
        }
        catch (ClassNotFoundException e) {
            clazz = GmNodeFactory.getInstance().getClass(elementType);
            if (clazz != null) {
                return clazz;
            }
            throw new PersistenceException(String.valueOf(elementType) + " class cannot be found.", (Exception)e);
        }
        return clazz;
    }

    public Object createInstance(String elementType, IDiagramReader in) throws PersistenceException {
        Class clazz = this.getClass(elementType);
        if (clazz == FactoryStyle.class) {
            return FactoryStyle.getInstance();
        }
        if (clazz == NamedStyle.class) {
            throw new IllegalArgumentException("NamedStyle not supported: should be an external reference.");
        }
        if (clazz == Style.class) {
            return new Style((IStyle)FactoryStyle.getInstance());
        }
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new PersistenceException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public <T extends Enum<T>> Class<T> getEnumClass(String enumType) {
        return this.getClass(enumType);
    }
}

