/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.umlcommon.constraint;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.elements.core.figures.GradientFigure;
import com.modeliosoft.modelio.diagram.elements.core.link.DefaultCreateLinkCommand;
import com.modeliosoft.modelio.diagram.elements.core.link.ModelioLinkCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.model.GmAbstractObject;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLink;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLinkable;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeEditPart;
import com.modeliosoft.modelio.diagram.elements.umlcommon.constraint.GmConstraintLink;
import java.beans.PropertyChangeEvent;
import java.util.List;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreationFactory;

public class ConstraintBodyEditPart
extends GmNodeEditPart {
    public void propertyChange(PropertyChangeEvent evt) {
        Object newValue;
        if (evt.getPropertyName().equals("Link source") && (newValue = evt.getNewValue()) != null && newValue instanceof IModelElement) {
            this.createMissingLinkForElement((IModelElement)newValue);
        }
        super.propertyChange(evt);
    }

    private void createMissingLinkForElement(IModelElement constrainedElement) {
        IGmLinkable sourceModel = (IGmLinkable)this.getModel();
        GmConstraintLink link = new GmConstraintLink(sourceModel.getDiagram(), new ObRef(sourceModel.getRelatedIElement()), constrainedElement, new ObRef((IElement)constrainedElement));
        sourceModel.addStartingLink((IGmLink)link);
        CreateConnectionRequest request = new CreateConnectionRequest();
        request.setType((Object)"connection end");
        request.setSourceEditPart((EditPart)this);
        request.setLocation(new Point(0, 0));
        ModelioLinkCreationContext context = new ModelioLinkCreationContext(sourceModel.getRelatedIElement());
        request.setFactory((CreationFactory)context);
        DefaultCreateLinkCommand startCommand = new DefaultCreateLinkCommand(context);
        startCommand.setSource(sourceModel);
        request.setStartCommand((Command)startCommand);
        List constrainedElementModels = sourceModel.getDiagram().getAllGMRelatedTo(new ObRef((IElement)constrainedElement));
        for (GmModel constrainedElementModel : constrainedElementModels) {
            EditPart targetEditPart;
            EditPart editPart = (EditPart)this.getViewer().getEditPartRegistry().get(constrainedElementModel);
            if (editPart == null || (targetEditPart = editPart.getTargetEditPart((Request)request)) == null) continue;
            IGmLinkable targetModel = (IGmLinkable)targetEditPart.getModel();
            targetModel.addEndingLink((IGmLink)link);
            break;
        }
    }

    protected IFigure createFigure() {
        GradientFigure fig = new GradientFigure();
        fig.setOpaque(false);
        fig.setLayoutManager((LayoutManager)new BorderLayout());
        this.refreshFromStyle((IFigure)fig, this.getModelStyle());
        return fig;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        this.getContentPane().add(child, (Object)BorderLayout.CENTER, index);
    }

    protected void refreshVisuals() {
        GmAbstractObject model = (GmAbstractObject)this.getModel();
        this.getFigure().getParent().setConstraint(this.getFigure(), model.getLayoutData());
    }
}

