/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.umlcommon.diagramholder;

import com.modeliosoft.modelio.diagram.elements.core.figures.GradientFigure;
import com.modeliosoft.modelio.diagram.elements.core.figures.ToolbarLayoutWithGrab;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Display;

public class DiagramHolderFigure
extends GradientFigure {
    private static final PointList foldTemplate;
    static final int FOLDSIZE = 12;

    static {
        int[] nArray = new int[6];
        nArray[0] = -12;
        nArray[1] = -12;
        nArray[3] = -12;
        nArray[4] = -12;
        foldTemplate = new PointList(nArray);
    }

    public DiagramHolderFigure() {
        ToolbarLayoutWithGrab layout = new ToolbarLayoutWithGrab(false);
        layout.setStretchMinorAxis(true);
        this.setLayoutManager((LayoutManager)layout);
    }

    protected void paintFigure(Graphics graphics) {
        Rectangle figBounds = this.getBounds().getResized(-1, -1);
        Point p0 = figBounds.getTopLeft();
        Point p1 = figBounds.getTopRight();
        Point p2 = new Point(figBounds.right(), figBounds.bottom() - 12);
        Point p3 = new Point(figBounds.right() - 12, figBounds.bottom() - 12);
        Point p4 = new Point(figBounds.right() - 12, figBounds.bottom());
        Point p5 = figBounds.getBottomLeft();
        if (this.isOpaque()) {
            Rectangle originalClip = new Rectangle();
            graphics.getClip(originalClip);
            Path path = new Path((Device)Display.getCurrent());
            path.moveTo((float)p0.x, (float)p0.y);
            path.lineTo((float)p1.x, (float)p1.y);
            path.lineTo((float)p2.x, (float)p2.y);
            path.lineTo((float)p3.x, (float)p3.y);
            path.lineTo((float)p4.x, (float)p4.y);
            path.lineTo((float)p5.x, (float)p5.y);
            path.lineTo((float)p0.x, (float)p0.y);
            graphics.setClip(path);
            super.paintFigure(graphics);
            path.dispose();
            graphics.setClip(originalClip);
            PointList polygon = foldTemplate.getCopy();
            polygon.translate(p1.x, p1.y);
            graphics.fillPolygon(polygon);
        }
        if (this.penOptions.lineWidth % 2 == 1) {
            --figBounds.width;
            --figBounds.height;
        }
        figBounds.shrink(this.penOptions.lineWidth / 2, this.penOptions.lineWidth / 2);
        graphics.setLineWidth(this.penOptions.lineWidth);
        graphics.setForegroundColor(this.penOptions.lineColor);
        graphics.drawLine(p0, p5);
        graphics.drawLine(p5, p4);
        graphics.drawLine(p4, p3);
        graphics.drawLine(p4, p2);
        graphics.drawLine(p3, p2);
        graphics.drawLine(p2, p1);
        graphics.drawLine(p1, p0);
    }

    protected void paintBorder(Graphics graphics) {
        super.paintBorder(graphics);
        Rectangle figBounds = this.getBounds().getResized(-1, -1);
        PointList polygon = foldTemplate.getCopy();
        polygon.translate(figBounds.getBottomRight());
        graphics.fillPolygon(polygon);
        graphics.drawPolygon(polygon);
    }
}

