/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.umlcommon.diagramview;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.common.linkednode.LinkedNodeFinishCreationEditPolicy;
import com.modeliosoft.modelio.diagram.elements.core.figures.GradientFigure;
import com.modeliosoft.modelio.diagram.elements.core.figures.borders.ZoomableLineBorder;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeEditPart;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import com.modeliosoft.modelio.diagram.elements.umlcommon.diagramview.DiagramViewEditPart;
import com.modeliosoft.modelio.diagram.elements.umlcommon.diagramview.GmAbstractDiagramView;
import com.modeliosoft.modelio.diagram.styles.core.IStyle;
import com.modeliosoft.modelio.diagram.styles.core.MetaKey;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.parts.Thumbnail;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.FreeformGraphicalRootEditPart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class DiagramViewEditPart
extends GmNodeEditPart {
    private EditPartViewer viewer;
    private static final String PROP_DGVIEW = "DiagramViewEditPart.DiagramChain";

    public void addNotify() {
        super.addNotify();
        Thumbnail thumbnail = new Thumbnail();
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.createThumbNail(thumbnail);
        this.getContentPane().add((IFigure)thumbnail, (Object)data, -1);
    }

    public void removeNotify() {
        if (this.viewer != null) {
            RootEditPart rootEditPart = this.viewer.getRootEditPart();
            rootEditPart.deactivate();
            rootEditPart.removeNotify();
            this.viewer = null;
        }
        super.removeNotify();
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.grabExcessVerticalSpace = false;
        data.horizontalAlignment = 16384;
        data.verticalAlignment = 1;
        this.getContentPane().add(((GraphicalEditPart)childEditPart).getFigure(), (Object)data, 0);
        this.updateFigureBorder(this.getFigure());
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy((Object)"Linked node end", (EditPolicy)new LinkedNodeFinishCreationEditPolicy());
        this.installEditPolicy((Object)"DirectEditPolicy", null);
    }

    protected IFigure createFigure() {
        GradientFigure fig = new GradientFigure();
        fig.setOpaque(true);
        fig.setPreferredSize(new Dimension(150, 100));
        GridLayout manager = new GridLayout(1, false);
        manager.horizontalSpacing = 0;
        manager.verticalSpacing = 0;
        manager.marginHeight = 0;
        manager.marginWidth = 0;
        fig.setLayoutManager((LayoutManager)manager);
        this.refreshFromStyle((IFigure)fig, this.getModelStyle());
        return fig;
    }

    protected void refreshFromStyle(IFigure aFigure, IStyle style) {
        if (aFigure instanceof GradientFigure && !this.switchRepresentationMode()) {
            super.refreshFromStyle(aFigure, style);
            this.updateFigureBorder(aFigure);
        }
    }

    protected void refreshVisuals() {
        IFigure fig = this.getFigure();
        GmNodeModel gm = (GmNodeModel)this.getModel();
        Object layoutData = gm.getLayoutData();
        if (layoutData != null) {
            fig.getParent().setConstraint(fig, layoutData);
        }
    }

    protected void removeChildVisual(EditPart childEditPart) {
        super.removeChildVisual(childEditPart);
        this.updateFigureBorder(this.getFigure());
    }

    private IFigure createThumbNail(Thumbnail thumbnail) {
        GmAbstractDiagramView gmView = (GmAbstractDiagramView)this.getModel();
        if (this.isCycle()) {
            Image image = gmView.getDiagram().getImageServices().getMetaclassIcon(gmView.getRelatedIElement());
            ImageFigure fig = new ImageFigure(image);
            thumbnail.add((IFigure)fig);
            thumbnail.setSource((IFigure)fig);
        } else {
            GmAbstractDiagram gmViewedDiagram = gmView.getViewedDiagram();
            this.viewer = new InnerEditPartViewer(this.getViewer());
            this.viewer.setProperty(PROP_DGVIEW, (Object)new DiagramViewChain(gmView.getDiagram().getRelatedIElement(), this.getViewer()));
            FreeformGraphicalRootEditPart rootEditPart = new FreeformGraphicalRootEditPart();
            EditPart diagramEditpart = this.createChild((Object)gmViewedDiagram);
            this.viewer.setRootEditPart((RootEditPart)rootEditPart);
            new RootFig((IFigure)thumbnail).add(rootEditPart.getFigure());
            this.viewer.setContents(diagramEditpart);
            rootEditPart.activate();
            rootEditPart.refresh();
            rootEditPart.getFigure().validate();
            rootEditPart.getFigure().setOpaque(false);
            IFigure srcFigure = rootEditPart.getLayer((Object)"Printable Layers");
            srcFigure.setBackgroundColor(this.getFillColor((GmNodeModel)gmView));
            thumbnail.setSource(srcFigure);
        }
        thumbnail.setSize(150, 100);
        return thumbnail;
    }

    private Color getFillColor(GmNodeModel gmModel) {
        return (Color)gmModel.getStyle().getProperty(gmModel.getStyleKeyStrict(MetaKey.FILLCOLOR));
    }

    private void updateFigureBorder(IFigure aFigure) {
        GradientFigure classFig = (GradientFigure)aFigure;
        ZoomableLineBorder inner = new ZoomableLineBorder(classFig.getLineColor(), 0);
        classFig.setBorder((Border)inner);
    }

    public void performRequest(Request req) {
        if (req.getType().equals("open")) {
            GmAbstractDiagramView gm = (GmAbstractDiagramView)this.getModel();
            O.getDefault().getActivationService().fireActivate(gm.getRelatedIElement());
        }
        super.performRequest(req);
    }

    private boolean isCycle() {
        GmAbstractDiagramView gmView = (GmAbstractDiagramView)this.getModel();
        IElement viewedDiagram = gmView.getRelatedIElement();
        IElement currentDiagram = gmView.getDiagram().getRelatedIElement();
        DiagramViewChain chain = (DiagramViewChain)this.getViewer().getProperty(PROP_DGVIEW);
        while (chain != null && !viewedDiagram.equals((Object)currentDiagram)) {
            currentDiagram = chain.diagram;
            chain = (DiagramViewChain)chain.parentEditPartViewer.getProperty(PROP_DGVIEW);
        }
        return viewedDiagram.equals((Object)currentDiagram);
    }
}

