/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.umlcommon.diagramview;

import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import com.modeliosoft.modelio.diagram.elements.umlcommon.diagramheader.GmDiagramHeader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;

public abstract class GmAbstractDiagramView
extends GmCompositeNode {
    private IAbstractDiagram obDiagram;
    private GmAbstractDiagram viewedDiagram;
    private final int minorVersion = 0;
    private static final int MAJOR_VERSION = 0;

    public GmAbstractDiagramView() {
    }

    public GmAbstractDiagramView(GmAbstractDiagram diagram, IAbstractDiagram el, ObRef ref) {
        super(diagram, ref);
        this.obDiagram = el;
        GmDiagramHeader header = new GmDiagramHeader(diagram, ref);
        this.addChild((GmNodeModel)header);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.viewedDiagram != null) {
            this.viewedDiagram.dispose();
        }
    }

    public boolean canCreate(Class<? extends IElement> type) {
        return false;
    }

    public boolean canUnmask(IElement el) {
        return false;
    }

    public void delete() {
        super.delete();
        if (this.viewedDiagram != null) {
            this.viewedDiagram.dispose();
            this.viewedDiagram = null;
        }
    }

    public GmCompositeNode getCompositeFor(Class<? extends IElement> metaclass) {
        return null;
    }

    public IElement getRelatedIElement() {
        return this.getRepresentedIElement();
    }

    public IAbstractDiagram getRepresentedIElement() {
        return this.obDiagram;
    }

    public GmAbstractDiagram getViewedDiagram() {
        if (this.obDiagram != null && this.viewedDiagram == null) {
            this.viewedDiagram = this.loadViewedDiagram();
        }
        return this.viewedDiagram;
    }

    public void obElementResolved(IElement ev) {
        super.obElementResolved(ev);
    }

    public void read(IDiagramReader in) {
        Object versionProperty = in.readProperty("GmAbstractDiagramView.version");
        int readVersion = versionProperty == null ? 0 : (Integer)versionProperty;
        switch (readVersion) {
            case 0: {
                this.read_0(in);
                break;
            }
            default: {
                assert (false) : "version number not covered!";
                this.read_0(in);
            }
        }
    }

    public void refreshFromObModel() {
    }

    protected abstract GmAbstractDiagram loadViewedDiagram();

    public void write(IDiagramWriter out) {
        super.write(out);
        if (false) {
            out.writeProperty("GmAbstractDiagramView.version", (Object)0);
        }
    }

    private void read_0(IDiagramReader in) {
        super.read(in);
        this.obDiagram = (IAbstractDiagram)this.resolveRef(this.getRepresentedRef());
    }

    public int getMajorVersion() {
        return 0;
    }
}

