/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.umlcommon.externdocument;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IExternDocument;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.utils.DocumentTypeNotFoundException;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.documents.DocumentCreator;
import com.modeliosoft.modelio.core.factory.IElementInitializer;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.core.ui.richnote.PromptRichNoteDescriptorDlg;
import com.modeliosoft.modelio.core.ui.richnote.RichNoteDescriptor;
import com.modeliosoft.modelio.diagram.elements.common.linkednode.CreateLinkedNodeCommand;
import com.modeliosoft.modelio.diagram.elements.core.commands.ModelioCreationContext;
import com.modeliosoft.modelio.diagram.elements.plugin.DiagramElement;
import java.io.IOException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CreateExternDocumentCommand
extends CreateLinkedNodeCommand {
    public CreateExternDocumentCommand(ModelioCreationContext context) {
        super(context);
    }

    protected IElement createElement(IModelFactory modelFactory, IElementInitializer elementInitializer) {
        IModelingSession session;
        Shell parentShell = PlatformUI.getWorkbench().getModalDialogShellProvider().getShell();
        PromptRichNoteDescriptorDlg dialog = new PromptRichNoteDescriptorDlg(parentShell, new RichNoteDescriptor((IModelElement)this.parentElement), session = DiagramElement.getInstance().getModelingSession());
        if (dialog.open() == 0) {
            try {
                RichNoteDescriptor descriptor = dialog.getRichNoteDescriptor();
                IExternDocument newElement = modelFactory.createExternDocument(descriptor.getDocumentType().getName(), descriptor.getTargetElement(), descriptor.getChosenMimeType());
                elementInitializer.initialize((IElement)newElement);
                newElement.setName(descriptor.getName());
                newElement.setPath(descriptor.getPath());
                newElement.setAbstract(descriptor.getAbstract());
                DocumentCreator.createDocument((IExternDocument)newElement);
                return newElement;
            }
            catch (DocumentTypeNotFoundException e) {
                e.printStackTrace();
                MessageDialog.openError((Shell)parentShell, (String)"Error", (String)e.getLocalizedMessage());
            }
            catch (IOException e) {
                e.printStackTrace();
                MessageDialog.openError((Shell)parentShell, (String)"Error", (String)e.getLocalizedMessage());
            }
        }
        return null;
    }
}

