/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.umlcommon.externdocument;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IExternDocument;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IExternDocumentType;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.model.IEditableText;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLink;
import com.modeliosoft.modelio.diagram.elements.core.node.GmSimpleNode;
import com.modeliosoft.modelio.diagram.elements.umlcommon.externdocument.GmExternDocumentStyleKeys;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import com.modeliosoft.modelio.diagram.styles.core.MetaKey;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public class GmExternDocument
extends GmSimpleNode {
    private IExternDocument document;
    static final GmExternDocumentStyleKeys KEYS = new GmExternDocumentStyleKeys();
    private final int minorVersion = 0;
    private static final int MAJOR_VERSION = 0;

    public GmExternDocument() {
    }

    public GmExternDocument(GmAbstractDiagram diagram, IExternDocument document, ObRef ref) {
        super(diagram, ref);
        this.document = document;
    }

    public String getName() {
        if (this.document != null) {
            return this.document.getName();
        }
        return "?";
    }

    public String getContents() {
        if (this.document != null) {
            return this.document.getAbstract();
        }
        return "?";
    }

    public IEditableText getEditableText() {
        if (this.document == null) {
            return null;
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public IExternDocument getRepresentedIElement() {
        return this.document;
    }

    public StyleKey.RepresentationMode getRepresentationMode() {
        return StyleKey.RepresentationMode.STRUCTURED;
    }

    public StyleKey getStyleKey(MetaKey metakey) {
        return KEYS.getStyleKey(metakey);
    }

    public List<StyleKey> getStyleKeys() {
        return KEYS.getStyleKeys();
    }

    public String getType() {
        if (this.document == null) {
            return "?";
        }
        IExternDocumentType model = this.document.getType();
        if (model == null) {
            return "<none>";
        }
        String label = model.getLabel();
        return label.isEmpty() ? model.getName() : label;
    }

    public Image getMimeType() {
        return O.getDefault().getDocumentFormatsRegistry().getFormat(this.getRepresentedIElement()).getIcon();
    }

    public void read(IDiagramReader in) {
        Object versionProperty = in.readProperty("GmExternDocument.version");
        int readVersion = versionProperty == null ? 0 : (Integer)versionProperty;
        switch (readVersion) {
            case 0: {
                this.read_0(in);
                break;
            }
            default: {
                assert (false) : "version number not covered!";
                this.read_0(in);
            }
        }
    }

    public void refreshFromObModel() {
        if (this.document != null) {
            this.firePropertyChange("Name", null, (Object)this.document.getAbstract());
        }
    }

    public IElement getRelatedIElement() {
        return this.getRepresentedIElement();
    }

    public void removeEndingLink(IGmLink gmLink) {
        boolean selfDelete = false;
        if (this.getRelatedIElement() != null && this.getRelatedIElement().equals((Object)gmLink.getRelatedIElement())) {
            selfDelete = true;
        }
        super.removeEndingLink(gmLink);
        if (selfDelete) {
            this.delete();
        }
    }

    public void write(IDiagramWriter out) {
        super.write(out);
        if (false) {
            out.writeProperty("GmExternDocument.version", (Object)0);
        }
    }

    private void read_0(IDiagramReader in) {
        super.read(in);
        this.document = (IExternDocument)this.resolveRef(this.getRepresentedRef());
    }

    public int getMajorVersion() {
        return 0;
    }
}

