/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.umlcommon.informationflowgroup;

import com.modeliosoft.modelio.api.model.uml.information.IInformationFlow;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.utils.IMetamodelVisitor;
import com.modeliosoft.modelio.core.factory.IBasicFactory;
import com.modeliosoft.modelio.diagram.elements.core.helpers.AuthHelper;
import com.modeliosoft.modelio.diagram.elements.umlcommon.informationflowgroup.InformationFlowFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

class InformationFlowFactory {
    private IBasicFactory modelFactory;
    private CreateVisitor impl;
    private IMetamodelVisitor canCreateImpl;

    public InformationFlowFactory(IBasicFactory modelFactory) {
        this.modelFactory = modelFactory;
        this.impl = new CreateVisitor(this);
        this.canCreateImpl = new CanCreateVisitor(this);
    }

    public IInformationFlow createInformationFlow(IElement realizingLink) {
        return (IInformationFlow)realizingLink.accept((IMetamodelVisitor)this.impl);
    }

    IInformationFlow createInformationFlow(Collection<? extends IModelElement> srcs, Collection<? extends IModelElement> dests) {
        IInformationFlow ret = this.modelFactory.createInformationFlow();
        for (IModelElement iModelElement : srcs) {
            ret.addInformationSource(iModelElement);
        }
        for (IModelElement iModelElement : dests) {
            ret.addInformationTarget(iModelElement);
        }
        ArrayList<? extends IModelElement> arrayList = new ArrayList<IModelElement>(srcs);
        arrayList.addAll(dests);
        ret.setOwner(this.getCommonNameSpace(arrayList));
        return ret;
    }

    private INameSpace getCommonNameSpace(Collection<IElement> elements) {
        ArrayList[] paths = new ArrayList[elements.size()];
        int i = 0;
        for (IElement el : elements) {
            paths[i] = new ArrayList();
            ArrayList l = paths[i];
            while (el != null) {
                l.add(el);
                el = el.getCompositionOwner();
            }
            ++i;
        }
        int max = paths[0].size();
        ArrayList[] arrayListArray = paths;
        int n = paths.length;
        int l = 0;
        while (l < n) {
            ArrayList l2 = arrayListArray[l];
            Collections.reverse(l2);
            if (max > l2.size()) {
                max = l2.size();
            }
            ++l;
        }
        INameSpace ret = null;
        i = 0;
        do {
            IElement el;
            if ((el = (IElement)paths[0].get(i)) instanceof INameSpace) {
                ArrayList[] arrayListArray2 = paths;
                int n2 = paths.length;
                int n3 = 0;
                while (n3 < n2) {
                    ArrayList l2 = arrayListArray2[n3];
                    if (!el.equals(l2.get(i))) {
                        return ret;
                    }
                    ret = (INameSpace)el;
                    ++n3;
                }
            } else {
                if (ret == null) continue;
                return ret;
            }
        } while (++i < max);
        throw new IllegalArgumentException("No common namespace between " + elements);
    }

    public boolean canCreateInformationFlow(IElement realizingLink) {
        return (Boolean)realizingLink.accept(this.canCreateImpl);
    }

    boolean canCreateInformationFlow(Collection<? extends IModelElement> srcs, Collection<? extends IModelElement> dests) {
        ArrayList<? extends IModelElement> c = new ArrayList<IModelElement>(srcs);
        c.addAll(dests);
        return AuthHelper.canModify((IElement)this.getCommonNameSpace(c));
    }
}

