/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.umlcommon.note;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INote;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INoteType;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.model.IEditableText;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLink;
import com.modeliosoft.modelio.diagram.elements.core.node.GmSimpleNode;
import com.modeliosoft.modelio.diagram.elements.umlcommon.note.GmNoteStyleKeys;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import com.modeliosoft.modelio.diagram.styles.core.MetaKey;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import java.util.List;

public class GmNote
extends GmSimpleNode {
    private INote note;
    static final GmNoteStyleKeys KEYS = new GmNoteStyleKeys();
    private final int minorVersion = 0;
    private static final int MAJOR_VERSION = 0;

    public GmNote() {
    }

    public GmNote(GmAbstractDiagram diagram, INote note, ObRef ref) {
        super(diagram, ref);
        this.note = note;
    }

    public String getContents() {
        if (this.note != null) {
            return this.note.getContent();
        }
        return "?";
    }

    public IEditableText getEditableText() {
        if (this.note == null) {
            return null;
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public INote getRepresentedIElement() {
        return this.note;
    }

    public StyleKey.RepresentationMode getRepresentationMode() {
        return StyleKey.RepresentationMode.STRUCTURED;
    }

    public StyleKey getStyleKey(MetaKey metakey) {
        return KEYS.getStyleKey(metakey);
    }

    public List<StyleKey> getStyleKeys() {
        return KEYS.getStyleKeys();
    }

    public String getType() {
        if (this.note == null) {
            return "?";
        }
        INoteType model = this.note.getModel();
        if (model == null) {
            return "<none>";
        }
        String label = model.getLabel();
        return label.isEmpty() ? model.getName() : label;
    }

    public void read(IDiagramReader in) {
        Object versionProperty = in.readProperty("GmNote.version");
        int readVersion = versionProperty == null ? 0 : (Integer)versionProperty;
        switch (readVersion) {
            case 0: {
                this.read_0(in);
                break;
            }
            default: {
                assert (false) : "version number not covered!";
                this.read_0(in);
            }
        }
    }

    public void refreshFromObModel() {
        if (this.note != null && this.note.isValid()) {
            this.firePropertyChange("Name", null, (Object)this.note.getContent());
        }
    }

    public IElement getRelatedIElement() {
        return this.getRepresentedIElement();
    }

    public void removeEndingLink(IGmLink gmLink) {
        boolean selfDelete = false;
        if (this.getRelatedIElement() != null && this.getRelatedIElement().equals((Object)gmLink.getRelatedIElement())) {
            selfDelete = true;
        }
        super.removeEndingLink(gmLink);
        if (selfDelete) {
            this.delete();
        }
    }

    public void write(IDiagramWriter out) {
        super.write(out);
        if (false) {
            out.writeProperty("GmNote.version", (Object)0);
        }
    }

    private void read_0(IDiagramReader in) {
        super.read(in);
        this.note = (INote)this.resolveRef(this.getRepresentedRef());
    }

    public int getMajorVersion() {
        return 0;
    }
}

