/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.umlcommon.packaze;

import com.modeliosoft.modelio.diagram.elements.core.figures.GradientFigure;
import com.modeliosoft.modelio.diagram.elements.core.figures.IBrushOptionsSupport;
import com.modeliosoft.modelio.diagram.elements.core.figures.IPenOptionsSupport;
import com.modeliosoft.modelio.diagram.elements.core.figures.PenOptions;
import com.modeliosoft.modelio.diagram.elements.core.figures.borders.TLBRBorder;
import com.modeliosoft.modelio.diagram.elements.umlcommon.packaze.PackageFigure;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class PackageFigure
extends Figure
implements IPenOptionsSupport,
IBrushOptionsSupport {
    private PenOptions penOptions = new PenOptions();
    private GradientFigure headerArea;
    private GradientFigure contentsArea;
    private IFigure headerFigure;
    private IFigure contentsFigure;

    public PackageFigure() {
        this.setLayoutManager((LayoutManager)new BorderLayout());
        Figure top = new Figure();
        top.setLayoutManager((LayoutManager)new HeaderAreaLayout(this));
        top.setOpaque(false);
        this.add((IFigure)top, (Object)BorderLayout.TOP);
        this.headerArea = new GradientFigure();
        this.headerArea.setLayoutManager((LayoutManager)new BorderLayout());
        this.headerArea.setOpaque(true);
        top.add((IFigure)this.headerArea);
        this.contentsArea = new GradientFigure();
        this.contentsArea.setLayoutManager((LayoutManager)new BorderLayout());
        this.contentsArea.setPreferredSize(new Dimension(100, 60));
        this.contentsArea.setOpaque(true);
        this.add((IFigure)this.contentsArea, (Object)BorderLayout.CENTER);
        this.updateBorders();
        this.setOpaque(false);
    }

    public IFigure getContentsFigure() {
        return this.contentsFigure;
    }

    public Color getFillColor() {
        return this.contentsArea.getFillColor();
    }

    public IFigure getHeaderFigure() {
        return this.headerFigure;
    }

    public Color getLineColor() {
        return this.penOptions.lineColor;
    }

    public StyleKey.LinePattern getLinePattern() {
        return this.penOptions.linePattern;
    }

    public int getLineWidth() {
        return this.penOptions.lineWidth;
    }

    public Color getTextColor() {
        return this.penOptions.textColor;
    }

    public Font getTextFont() {
        return this.penOptions.textFont;
    }

    public boolean getUseGradient() {
        return this.contentsArea.getUseGradient();
    }

    public void setContentsFigure(IFigure figure) {
        if (!this.contentsArea.getChildren().isEmpty()) {
            this.contentsArea.removeAll();
        }
        if (figure != null) {
            this.contentsArea.add(figure, (Object)BorderLayout.CENTER);
        }
    }

    public void setFillColor(Color fillColor) {
        this.headerArea.setFillColor(fillColor);
        this.contentsArea.setFillColor(fillColor);
    }

    public void setHeaderFigure(IFigure figure) {
        if (!this.headerArea.getChildren().isEmpty()) {
            this.headerArea.removeAll();
        }
        if (figure != null) {
            this.headerArea.add(figure, (Object)BorderLayout.LEFT);
            figure.setBackgroundColor(ColorConstants.red);
        }
    }

    public void setLineColor(Color lineColor) {
        this.penOptions.lineColor = lineColor;
        this.updateBorders();
    }

    public void setLinePattern(StyleKey.LinePattern linePattern) {
        this.penOptions.linePattern = linePattern;
        this.updateBorders();
    }

    public void setLineWidth(int lineWidth) {
        this.penOptions.lineWidth = lineWidth;
        this.updateBorders();
    }

    public void setTextColor(Color textColor) {
        this.penOptions.textColor = textColor;
    }

    public void setTextFont(Font textFont) {
        this.penOptions.textFont = textFont;
    }

    public void setUseGradient(boolean useGradient) {
        this.contentsArea.setUseGradient(useGradient);
        this.headerArea.setUseGradient(useGradient);
    }

    private void updateBorders() {
        TLBRBorder headerLineBorder = new TLBRBorder(this.penOptions.lineColor, this.penOptions.lineWidth, true, true, false, true);
        LineBorder contentLineBorder = new LineBorder(this.penOptions.lineColor, this.penOptions.lineWidth);
        headerLineBorder.setStyle(this.getLinePattern().toSWTConstant());
        contentLineBorder.setStyle(this.getLinePattern().toSWTConstant());
        this.headerArea.setBorder((Border)new CompoundBorder((Border)headerLineBorder, (Border)new MarginBorder(0, 4, 0, 4)));
        this.contentsArea.setBorder((Border)new CompoundBorder((Border)contentLineBorder, (Border)new MarginBorder(1)));
    }

    public Dimension getMinimumSize(int wHint, int hHint) {
        Dimension minimumSize = super.getMinimumSize(wHint, hHint);
        if (minimumSize.height < 100) {
            minimumSize.height = 100;
        }
        if (minimumSize.width < 100) {
            minimumSize.width = 100;
        }
        return minimumSize;
    }
}

