/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.api.mdac;

import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.log.LOG;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class ScriptEngineConfigurator {
    public static void configureJython(ScriptEngine jythonEngine) {
        try {
            URL url;
            Bundle bundle = Platform.getBundle((String)"org.modelio.core");
            if (bundle != null && (url = FileLocator.find((Bundle)bundle, (IPath)new Path("res/python/init.py"), null)) != null) {
                File file = new File(FileLocator.toFileURL((URL)url).getPath());
                if (file.isFile()) {
                    jythonEngine.eval(new FileReader(file));
                } else {
                    LOG.warning((String)"org.modelio.mda.infra", (String)("script: No '" + file.getPath() + "' init file found."));
                }
            }
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            File workspacePath = O.getDefault().getWorkspacePath();
            File wsRc = new File(workspacePath, "rc.py");
            if (wsRc.isFile()) {
                jythonEngine.eval(new FileReader(wsRc));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
        try {
            IModelingSession session = O.getDefault().getModelingSession();
            assert (session != null);
            File projectSpacePath = session.getProjectSpacePath();
            File prjRc = new File(projectSpacePath, "rc.py");
            if (prjRc.isFile()) {
                jythonEngine.eval(new FileReader(prjRc));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
    }

    public static ScriptEngineManager createScriptEngineManager(ClassLoader classLoader) {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager(classLoader);
        scriptEngineManager.put("classLoader", classLoader);
        scriptEngineManager.put("CLASSLOADER", classLoader);
        return scriptEngineManager;
    }
}

