/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mdainfra.gui.propertyPages.view;

import com.modeliosoft.modelio.api.mdac.IMdacPropertyModel;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.ui.UIColor;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.core.ui.ktable.editors.CheckboxCellEditor;
import com.modeliosoft.modelio.core.ui.ktable.editors.ComboCellEditor;
import com.modeliosoft.modelio.core.ui.ktable.editors.ElementCellEditor;
import com.modeliosoft.modelio.core.ui.ktable.editors.EnumCellEditor;
import com.modeliosoft.modelio.core.ui.ktable.editors.TextCellEditor;
import com.modeliosoft.modelio.core.ui.ktable.renderers.ElementCellRenderer;
import com.modeliosoft.modelio.mdainfra.plugin.MdaInfra;
import de.kupzog.ktable.KTable;
import de.kupzog.ktable.KTableCellEditor;
import de.kupzog.ktable.KTableCellRenderer;
import de.kupzog.ktable.KTableDefaultModel;
import de.kupzog.ktable.editors.KTableCellEditorCheckbox;
import de.kupzog.ktable.editors.KTableCellEditorText2;
import de.kupzog.ktable.renderers.CheckableCellRenderer;
import de.kupzog.ktable.renderers.FixedCellRenderer;
import de.kupzog.ktable.renderers.TextCellRenderer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.statushandlers.StatusManager;

public class MdacPropertyKTableModel
extends KTableDefaultModel {
    private Color oddColor = null;
    private Color evenColor = null;
    private IMdacPropertyModel data = null;
    private ElementCellEditor elementEditor = null;
    private ElementCellRenderer elementRenderer = null;
    private KTableCellEditorCheckbox boolEditor = null;
    private KTableCellEditorText2 textEditor = null;
    private KTable table = null;
    private FixedCellRenderer headerRenderer = null;
    private TextCellRenderer textRenderer = null;
    private TextCellRenderer labelRenderer = null;
    private CheckableCellRenderer boolRenderer = null;
    private TextCellRenderer objectRenderer = null;

    public MdacPropertyKTableModel(KTable table) {
        this.table = table;
        this.oddColor = UIColor.TABLE_ODDROW_BG;
        this.evenColor = UIColor.TABLE_EVENROW_BG;
        this.initializeRenderers();
        this.initializeEditors();
    }

    public KTableCellEditor doGetCellEditor(int col, int row) {
        KTableCellEditorCheckbox editor = null;
        if (row <= 0) {
            return null;
        }
        if (col <= 0) {
            return null;
        }
        if (!this.data.isEditable(row, col)) {
            return null;
        }
        Object value = this.data.getValueAt(row, col);
        Class type = this.data.getTypeAt(row, col);
        if (col > 0) {
            if (type == Boolean.class) {
                editor = this.boolEditor;
            }
            if (type == String.class) {
                editor = this.textEditor;
            }
            if (type != null && IModelElement.class.isAssignableFrom(type)) {
                this.elementEditor.setTargetClass(type);
                editor = this.elementEditor;
            }
            if (type != null && type.isEnum()) {
                editor = new EnumCellEditor(value);
            }
            if (type == String[].class) {
                ComboCellEditor comboEditor = new ComboCellEditor();
                String[] items = this.data.getItemsAt(row, col);
                comboEditor.setItems(items);
                editor = comboEditor;
            }
        }
        return editor;
    }

    public KTableCellRenderer doGetCellRenderer(int col, int row) {
        TextCellRenderer renderer = null;
        if (row == 0) {
            return this.headerRenderer;
        }
        Class type = this.data.getTypeAt(row, col);
        if (col == 0) {
            renderer = this.labelRenderer;
        } else {
            renderer = this.objectRenderer;
            if (type == String.class) {
                renderer = this.textRenderer;
            }
            if (type == Boolean.class) {
                renderer = this.boolRenderer;
            }
            if (IModelElement.class.isAssignableFrom(type)) {
                renderer = this.elementRenderer;
            }
            if (type == String[].class) {
                renderer = this.textRenderer;
            }
        }
        renderer.setBackground(row % 2 == 0 ? this.oddColor : this.evenColor);
        return renderer;
    }

    public int doGetColumnCount() {
        return this.data.getColumnNumber();
    }

    public Object doGetContentAt(int col, int row) {
        return this.data.getValueAt(row, col);
    }

    public int doGetRowCount() {
        return this.data.getRowsNumber();
    }

    /*
     * Unable to fully structure code
     */
    public void doSetContentAt(int col, int row, Object value) {
        block13: {
            block12: {
                session = MdaInfra.getInstance().getModelingSession();
                tm = session.getTransactionManager();
                t = tm.createTransaction("doSetContentAt");
                if (row != 0) break block12;
                while (true) {
                    if (t != null) {
                        tm.rollback(t);
                    }
                    return;
                }
            }
            try {
                if (col == 0) ** continue;
                this.data.setValueAt(row, col, value);
                tm.commit(t);
                t = null;
            }
            catch (InvalidTransactionException e) {
                MdaInfra.LOG.error((Throwable)e);
                t = null;
                if (t != null) {
                    tm.rollback(t);
                }
                break block13;
            }
            catch (Exception e) {
                try {
                    MdaInfra.LOG.error((Throwable)e);
                    StatusManager.getManager().handle((IStatus)new Status(4, "org.modelio.mda.infra", e.getLocalizedMessage(), (Throwable)e), 2);
                    break block13;
                }
                catch (Throwable var8_9) {
                    throw var8_9;
                }
                finally {
                    if (t != null) {
                        tm.rollback(t);
                    }
                }
            }
            if (t == null) break block13;
            tm.rollback(t);
        }
        this.table.redraw();
    }

    public int getInitialColumnWidth(int column) {
        double firstColumnWeight = 0.25;
        int colCount = this.data.getColumnNumber();
        int availableWidth = this.table.getClientArea().width - 18;
        if (column == 0) {
            return (int)((double)availableWidth * 0.25);
        }
        return (int)((double)availableWidth * 0.75) / (colCount - 1);
    }

    public int getInitialRowHeight(int row) {
        return row == 0 ? 20 : 16;
    }

    public int getFixedHeaderColumnCount() {
        return 0;
    }

    public int getFixedHeaderRowCount() {
        return 1;
    }

    public int getFixedSelectableColumnCount() {
        return 0;
    }

    public int getFixedSelectableRowCount() {
        return 0;
    }

    public int getRowHeightMinimum() {
        return 10;
    }

    public boolean isColumnResizable(int col) {
        return false;
    }

    public void setColumnWidth(int col, int value) {
        super.setColumnWidth(col, value);
    }

    public boolean isRowResizable(int row) {
        return false;
    }

    public int getColumnWidth(int col) {
        return super.getColumnWidth(col);
    }

    protected void initializeRenderers() {
        this.headerRenderer = new FixedCellRenderer(1);
        this.headerRenderer.setForeground(UIColor.BLACK);
        this.headerRenderer.setBackground(UIColor.TABLE_HEADER_BG);
        this.headerRenderer.setAlignment(55);
        this.textRenderer = new TextCellRenderer(16);
        this.textRenderer.setForeground(Display.getCurrent().getSystemColor(10));
        this.textRenderer.setAlignment(55);
        this.labelRenderer = new TextCellRenderer(16);
        this.labelRenderer.setAlignment(52);
        this.labelRenderer.setForeground(Display.getCurrent().getSystemColor(2));
        this.boolRenderer = new CheckableCellRenderer(16);
        this.boolRenderer.setAlignment(55);
        this.boolRenderer.setForeground(Display.getCurrent().getSystemColor(10));
        this.elementRenderer = new ElementCellRenderer(this.table, 16);
        this.elementRenderer.setForeground(Display.getCurrent().getSystemColor(10));
        this.elementRenderer.setAlignment(55);
        this.objectRenderer = new TextCellRenderer(16);
        this.objectRenderer.setForeground(Display.getCurrent().getSystemColor(10));
        this.objectRenderer.setAlignment(55);
    }

    protected void initializeEditors() {
        this.boolEditor = new CheckboxCellEditor();
        this.textEditor = new TextCellEditor();
        this.elementEditor = new ElementCellEditor();
    }

    public void setData(IMdacPropertyModel data) {
        this.data = data;
    }

    public String getTooltipAt(int col, int row) {
        return this.doGetContentAt(col, row).toString();
    }
}

