/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mdainfra.gui.propertyPages.view;

import com.modeliosoft.modelio.api.mdac.IMdacPropertyModel;
import com.modeliosoft.modelio.api.mdac.propertiesPage.IMdacPropertyPage;
import com.modeliosoft.modelio.api.mdac.propertiesPage.IMdacPropertyTable;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.mdainfra.gui.propertyPages.view.MdacProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MdacPropertyTable
implements IMdacPropertyTable,
IMdacPropertyModel {
    private List<MdacProperty> properties = new ArrayList();
    private IMdacPropertyPage propertyPage;
    private List<IElement> selectedElements;

    public final void addProperty(String key, int value) {
        MdacProperty property = new MdacProperty(key, String.class, Integer.toString(value));
        this.properties.add(property);
    }

    public final void addProperty(String key, String value) {
        MdacProperty property = new MdacProperty(key, String.class, value);
        this.properties.add(property);
    }

    public final void addProperty(String key, boolean value) {
        MdacProperty property = new MdacProperty(key, Boolean.class, Boolean.toString(value));
        this.properties.add(property);
    }

    public final void addProperty(String key, String value, String[] enumValue) {
        MdacProperty property = new MdacProperty(key, String[].class, value, enumValue);
        this.properties.add(property);
    }

    public final void addConsultProperty(String key, String value) {
        MdacProperty property = new MdacProperty(key, String.class, value, true);
        this.properties.add(property);
    }

    public int getColumnNumber() {
        return 2;
    }

    public int getRowsNumber() {
        return this.properties.size();
    }

    public Class<?> getTypeAt(int row, int col) {
        if (col == 0) {
            return String.class;
        }
        return ((MdacProperty)this.properties.get(row)).getType();
    }

    public Object getValueAt(int row, int col) {
        if (col == 0) {
            return ((MdacProperty)this.properties.get(row)).getLabel();
        }
        Class type = ((MdacProperty)this.properties.get(row)).getType();
        if (type == String.class) {
            return ((MdacProperty)this.properties.get(row)).getValue();
        }
        if (type == Boolean.class) {
            return Boolean.valueOf(((MdacProperty)this.properties.get(row)).getValue());
        }
        if (type == String[].class) {
            return ((MdacProperty)this.properties.get(row)).getValue();
        }
        return null;
    }

    public void setValueAt(int row, int col, Object value) {
        if (col == 0 || this.selectedElements == null) {
            return;
        }
        this.propertyPage.changeProperty(new ObList((Collection)this.selectedElements), row, String.valueOf(value));
    }

    public MdacPropertyTable(IMdacPropertyPage propertyPage, List<IElement> selectedElements) {
        this.propertyPage = propertyPage;
        this.selectedElements = selectedElements;
        MdacProperty property = new MdacProperty("Property", String.class, "Value", true);
        this.properties.add(property);
        if (propertyPage != null) {
            propertyPage.update(new ObList(selectedElements), (IMdacPropertyTable)this);
        }
    }

    public String[] getItemsAt(int row, int col) {
        if (col == 0) {
            return null;
        }
        Class type = ((MdacProperty)this.properties.get(row)).getType();
        if (type == String[].class) {
            return ((MdacProperty)this.properties.get(row)).getEnumValues();
        }
        return null;
    }

    public final void clearTable() {
        this.properties.clear();
    }

    public boolean isEditable(int row, int col) {
        boolean selectionIsModifiable = true;
        if (col == 0) {
            return false;
        }
        for (IElement selectedElement : this.selectedElements) {
            IElementStatus status = selectedElement.getElementStatus();
            if (status.isModifiable()) continue;
            selectionIsModifiable = false;
        }
        return selectionIsModifiable && !((MdacProperty)this.properties.get(row)).isReadOnly();
    }
}

