/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mdainfra.gui.propertyPages.view;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.mdac.IMdacPropertyModel;
import com.modeliosoft.modelio.api.mdac.commands.ActionLocation;
import com.modeliosoft.modelio.api.mdac.propertiesPage.IMdacPropertyPage;
import com.modeliosoft.modelio.api.mdac.propertiesPage.IMdacPropertyTable;
import com.modeliosoft.modelio.api.model.IModelingSession;
import com.modeliosoft.modelio.api.model.change.IModelChangeEvent;
import com.modeliosoft.modelio.api.model.change.IModelChangeListener;
import com.modeliosoft.modelio.api.model.change.IStatusChangeEvent;
import com.modeliosoft.modelio.api.model.change.IStatusChangeListener;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.api.utils.exceptions.ObElementDeletedException;
import com.modeliosoft.modelio.api.utils.exceptions.ObElementNotFoundException;
import com.modeliosoft.modelio.mdainfra.gui.propertyPages.view.MdacPropertyTable;
import com.modeliosoft.modelio.mdainfra.gui.propertyPages.view.MdacPropertyView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public class MdacPropertyTableUpdater
implements ISelectionListener,
IModelChangeListener,
IStatusChangeListener {
    private MdacPropertyView mdacPropertyView;
    private IMdacPropertyPage propertyPage;
    private IMdacPropertyTable currentPropertyTable;
    private List<IElement> inputElements;

    public MdacPropertyTableUpdater(MdacPropertyView mdacPropertyView, IMdacPropertyPage propertyPage) {
        this.mdacPropertyView = mdacPropertyView;
        this.inputElements = new ArrayList();
        this.propertyPage = propertyPage;
        this.currentPropertyTable = null;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            List selectedObjects = ((IStructuredSelection)selection).toList();
            this.inputElements.clear();
            for (Object selectedObject : selectedObjects) {
                IAdaptable selectedAdapter;
                IElement selectedElement;
                if (!(selectedObject instanceof IAdaptable) || (selectedElement = (IElement)(selectedAdapter = (IAdaptable)selectedObject).getAdapter(IElement.class)) == null || !selectedElement.isValid()) continue;
                this.inputElements.add(selectedElement);
            }
            if (this.inputElements.size() > 0) {
                MdacPropertyTable mdacPropertyTable = new MdacPropertyTable(this.propertyPage, this.inputElements);
                IMdac mdac = this.propertyPage.getMdac();
                Collection mdacActions = mdac.getMdacActions(ActionLocation.property);
                this.mdacPropertyView.setActions(mdacActions, this.inputElements, mdac);
                this.currentPropertyTable = mdacPropertyTable;
                this.mdacPropertyView.setInput((IMdacPropertyModel)mdacPropertyTable);
            } else {
                this.mdacPropertyView.setInput(null);
                this.mdacPropertyView.clearActions();
            }
        }
    }

    public void modelChanged(IModelingSession session, IModelChangeEvent event) {
        Display display = Display.getDefault();
        if (display != null) {
            display.asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void start(IModelingSession session) {
        this.mdacPropertyView.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        session.addModelListener((IModelChangeListener)this);
        session.addStatusListener((IStatusChangeListener)this);
    }

    public void stop(IModelingSession session) {
        this.mdacPropertyView.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        session.removeModelListener((IModelChangeListener)this);
        session.removeStatusListener((IStatusChangeListener)this);
    }

    public void statusChanged(IModelingSession session, IStatusChangeEvent event) {
        Display display = Display.getDefault();
        if (display != null) {
            display.asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void updateToolbar() {
        IMdac mdac = this.propertyPage.getMdac();
        if (this.inputElementsAreValid()) {
            Collection mdacActions = mdac.getMdacActions(ActionLocation.property);
            this.mdacPropertyView.setActions(mdacActions, this.inputElements, mdac);
        } else {
            this.mdacPropertyView.clearActions();
        }
    }

    private boolean inputElementsAreValid() {
        for (IElement element : this.inputElements) {
            try {
                element.getCompositionOwner();
            }
            catch (ObElementNotFoundException e) {
                return false;
            }
        }
        return true;
    }

    public void updateMdacpropertyTable() {
        if (this.currentPropertyTable != null) {
            this.currentPropertyTable.clearTable();
            if (this.inputElementsAreValid()) {
                try {
                    this.currentPropertyTable.addConsultProperty("Property", "Value");
                    this.propertyPage.update(new ObList((Collection)this.inputElements), this.currentPropertyTable);
                }
                catch (ObElementNotFoundException obElementNotFoundException) {
                }
                catch (ObElementDeletedException obElementDeletedException) {
                    // empty catch block
                }
            }
            this.mdacPropertyView.refresh();
            this.updateToolbar();
        }
    }
}

