/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mdainfra.gui.propertyPages.view;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.mdac.IMdacPropertyModel;
import com.modeliosoft.modelio.api.mdac.IMdacPropertyView;
import com.modeliosoft.modelio.api.mdac.commands.IMdacAction;
import com.modeliosoft.modelio.api.mdac.commands.IMdacContextualCommand;
import com.modeliosoft.modelio.api.mdac.propertiesPage.IMdacPropertyPage;
import com.modeliosoft.modelio.api.model.IModelingSession;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.mdainfra.gui.propertyPages.view.IMdacPropertyPanel;
import com.modeliosoft.modelio.mdainfra.gui.propertyPages.view.MdacPropertyAction;
import com.modeliosoft.modelio.mdainfra.gui.propertyPages.view.MdacPropertyPanel;
import com.modeliosoft.modelio.mdainfra.gui.propertyPages.view.MdacPropertyTableUpdater;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class MdacPropertyView
extends ViewPart
implements IPartListener2,
IMdacPropertyView {
    private IMdacPropertyPanel propertyPanel;
    private Image titleImage;
    private MdacPropertyTableUpdater mdacPropertyTableUpdater;
    private IModelingSession modelingSession;

    public void createPartControl(Composite parent) {
        this.propertyPanel = new MdacPropertyPanel(parent, null);
    }

    public void setFocus() {
    }

    public void setPartName(String title) {
        super.setPartName(title);
    }

    public void setInput(IMdacPropertyModel propertyTable) {
        if (this.propertyPanel.getComposite().isDisposed()) {
            return;
        }
        this.propertyPanel.setInput(propertyTable);
    }

    public void setActions(Collection<IMdacAction> mdacActions, List<IElement> selectedElements, IMdac javaMdac) {
        IToolBarManager toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolbarManager.removeAll();
        for (IMdacAction mdacAction : mdacActions) {
            if (!mdacAction.accept(selectedElements.toArray(new IElement[selectedElements.size()]))) continue;
            IAction action = this.createAction(mdacAction, selectedElements, javaMdac);
            toolbarManager.add(action);
        }
        toolbarManager.update(true);
    }

    private IAction createAction(IMdacAction mdacAction, List<IElement> selectedElements, IMdac javaMdac) {
        String name = mdacAction.getName();
        String label = mdacAction.getLabel();
        String tooltip = mdacAction.getTooltip();
        ImageDescriptor imageDescriptor = this.getImageDescriptor(javaMdac, mdacAction.getImagePath());
        IMdacContextualCommand command = mdacAction.getCommand();
        MdacPropertyAction action = new MdacPropertyAction(javaMdac, name, label, tooltip, imageDescriptor, command);
        if (!mdacAction.isActiveFor(selectedElements.toArray(new IElement[selectedElements.size()]), false)) {
            action.setEnabled(false);
        } else {
            action.setEnabled(true);
            action.setSelectedElements(selectedElements);
        }
        return action;
    }

    public void refresh() {
        if (this.propertyPanel.getComposite().isDisposed()) {
            return;
        }
        this.propertyPanel.refresh();
    }

    public void setPartImage(ImageDescriptor desc) {
        if (desc != null) {
            this.titleImage = desc.createImage();
            this.setTitleImage(this.titleImage);
        }
    }

    public void dispose() {
        if (this.titleImage != null) {
            this.titleImage.dispose();
        }
        super.dispose();
    }

    public void start(IModelingSession session, IMdacPropertyPage propertyPage) {
        this.modelingSession = session;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        page.addPartListener((IPartListener2)this);
        this.mdacPropertyTableUpdater = new MdacPropertyTableUpdater(this, propertyPage);
        this.mdacPropertyTableUpdater.start(session);
    }

    public void stop() {
        if (this.modelingSession != null) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (page != null) {
                page.removePartListener((IPartListener2)this);
            }
            this.mdacPropertyTableUpdater.stop(this.modelingSession);
            this.propertyPanel.stop();
            this.modelingSession = null;
        }
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        IViewReference viewRef;
        if (partRef instanceof IViewReference && (viewRef = (IViewReference)partRef).getView(false) == this) {
            this.stop();
        }
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void clearActions() {
        IToolBarManager toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolbarManager.removeAll();
        toolbarManager.update(true);
    }

    private ImageDescriptor getImageDescriptor(IMdac mdac, String imagePath) {
        ImageDescriptor imageDescriptor = null;
        File tmpFile = null;
        File bitmapFile = new File(imagePath);
        if (bitmapFile.exists() && bitmapFile.isFile() && bitmapFile.isAbsolute()) {
            tmpFile = new File(imagePath);
        } else {
            File moduleDirectory = mdac.getConfiguration().getModuleResourcesPath();
            File oldModuleDirectory = new File(mdac.getConfiguration().getProjectSpacePath(), "mda");
            File oldMdaDirectory = new File(oldModuleDirectory, mdac.getName());
            File modelioDirectory = O.getDefault().getClientPath();
            File langPath = new File(modelioDirectory, "res/" + O.getDefault().getLang());
            File commonPath = new File(modelioDirectory, "res/common");
            tmpFile = new File(moduleDirectory, imagePath);
            if (!tmpFile.isFile()) {
                tmpFile = new File(oldMdaDirectory, imagePath);
            }
            if (!tmpFile.isFile()) {
                tmpFile = new File(langPath, imagePath);
            }
            if (!tmpFile.isFile()) {
                tmpFile = new File(commonPath, imagePath);
            }
        }
        if (tmpFile.exists() && tmpFile.isFile()) {
            try {
                imageDescriptor = ImageDescriptor.createFromURL((URL)tmpFile.toURI().toURL());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return imageDescriptor;
    }
}

