/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mdainfra.mdacs.core;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.mdac.IMdacDescriptor;
import com.modeliosoft.modelio.api.mdac.MdacException;
import com.modeliosoft.modelio.api.model.IModelingSession;
import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.modelio.Version;
import com.modeliosoft.modelio.api.module.IMdacConfiguration;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.mdacs.IMdacRegistry;
import com.modeliosoft.modelio.mdainfra.mdacs.core.FakeModule;
import com.modeliosoft.modelio.mdainfra.mdacs.core.IMdacManager;
import com.modeliosoft.modelio.mdainfra.mdacs.core.IncompatibleModule;
import com.modeliosoft.modelio.mdainfra.mdacs.core.MdacLoader;
import com.modeliosoft.modelio.mdainfra.mdacs.internal.MdacConfiguration;
import com.modeliosoft.modelio.mdainfra.plugin.MdaInfra;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class MdacLoader {
    private com.modeliosoft.modelio.core.IModelingSession coreModelingSession;
    private IMdacManager mdacManager;
    private File projectspacePath;
    private File workspacePath;
    private static final String FAKE_MODULE_CLASS_NAME = "<FAKE>";
    private IMdacRegistry registry;

    public MdacLoader(com.modeliosoft.modelio.core.IModelingSession session, IMdacManager mdacManager, File projectspacePath) {
        this.mdacManager = mdacManager;
        this.coreModelingSession = session;
        this.registry = this.coreModelingSession.getMdacRegistry();
        this.projectspacePath = projectspacePath;
        this.workspacePath = O.getDefault().getWorkspacePath();
    }

    public IMdac loadMdac(IModule module, List<File> classPath) throws MdacException {
        IMdac mdac = this.registry.getLoadedMdac(module);
        if (mdac != null) {
            return mdac;
        }
        this.loadRequiredMdacs(module);
        this.loadWeakDependencyModules(module);
        MdacClassLoader classLoader = this.setupClassLoader(module, classPath);
        String mainClassName = module.getjavaClassName();
        mdac = mainClassName.equals(FAKE_MODULE_CLASS_NAME) ? this.loadJavaMdac(module, classLoader, FakeModule.class.getName()) : this.loadJavaMdac(module, classLoader, mainClassName);
        return mdac;
    }

    public MdacClassLoader setupClassLoader(IModule mdacHandle, List<File> classPath) throws MdacException {
        ArrayList<URL> mdacClassPath = new ArrayList<URL>();
        ArrayList<ClassLoader> parentLoaders = new ArrayList<ClassLoader>();
        File fClassPath = this.mdacManager.getMdacPath(mdacHandle);
        try {
            mdacClassPath.add(fClassPath.toURI().toURL());
        }
        catch (MalformedURLException e) {
            String msg = String.format("The '%1$s' module '%2$s' classpath is invalid:\n %3$s", mdacHandle.getName(), fClassPath.getPath(), e.getLocalizedMessage());
            MdacException e2 = new MdacException(msg);
            e2.initCause((Throwable)e);
            throw e2;
        }
        fClassPath = new File(fClassPath, "class");
        try {
            mdacClassPath.add(fClassPath.toURI().toURL());
        }
        catch (MalformedURLException e) {
            String msg = String.format("The '%1$s' module '%2$s' classpath is invalid:\n %3$s", mdacHandle.getName(), fClassPath.getPath(), e.getLocalizedMessage());
            MdacException e2 = new MdacException(msg);
            e2.initCause((Throwable)e);
            throw e2;
        }
        File resourcePath = this.mdacManager.getMdacPath(mdacHandle);
        if (classPath == null || classPath.size() == 0) {
            File libPath = new File(resourcePath, "lib");
            File[] files = libPath.listFiles();
            if (files != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (f.getName().endsWith(".jar")) {
                        try {
                            mdacClassPath.add(f.toURI().toURL());
                        }
                        catch (MalformedURLException e) {
                            String msg = String.format("The '%1$s' module '%2$s' classpath entry is invalid:\n %3$s", mdacHandle.getName(), f.toString(), e.getLocalizedMessage());
                            MdacException e2 = new MdacException(msg);
                            e2.initCause((Throwable)e);
                            throw e2;
                        }
                    }
                    ++n2;
                }
            }
        } else {
            for (File file : classPath) {
                try {
                    mdacClassPath.add(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    String msg = String.format("The '%1$s' module '%2$s' classpath entry is invalid:\n %3$s", mdacHandle.getName(), file.toString(), e.getLocalizedMessage());
                    MdacException e2 = new MdacException(msg);
                    e2.initCause((Throwable)e);
                    throw e2;
                }
            }
        }
        ClassLoader mdaApiLoader = IModelingSession.class.getClassLoader();
        parentLoaders.add(mdaApiLoader);
        ClassLoader modelioLoader = this.coreModelingSession.getClass().getClassLoader();
        parentLoaders.add(modelioLoader);
        ClassLoader mdaInfraLoader = MdaInfra.class.getClassLoader();
        parentLoaders.add(mdaInfraLoader);
        this.addPluginsClassLoaders(parentLoaders);
        for (IModule usedMdac : mdacHandle.getDependsOn()) {
            IMdac im = this.registry.getLoadedMdac(usedMdac);
            if (im == null) continue;
            parentLoaders.add(im.getClass().getClassLoader());
        }
        List weakModuleReferences = this.mdacManager.getWeakDependencies(mdacHandle);
        for (IMdacDescriptor weakModuleReference : weakModuleReferences) {
            IMdac im;
            Version version;
            IModule weakDependencyModule = this.mdacManager.getModule(weakModuleReference.getName());
            if (weakDependencyModule == null || !(version = new Version(weakDependencyModule.getVersion())).isNewerThan(weakModuleReference.getVersion()) && !version.equals((Object)weakModuleReference.getVersion()) || !this.mdacManager.isActivated(weakDependencyModule) || (im = this.registry.getLoadedMdac(weakDependencyModule)) == null) continue;
            parentLoaders.add(im.getClass().getClassLoader());
        }
        return new MdacClassLoader(mdacHandle.getName(), mdacClassPath.toArray(new URL[0]), parentLoaders);
    }

    private void addPluginClassLoader(List<ClassLoader> parentLoaders, String pluginId, String className) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle != null) {
            try {
                Class clazz = bundle.loadClass(className);
                ClassLoader loader = clazz.getClassLoader();
                parentLoaders.add(loader);
            }
            catch (ClassNotFoundException e) {
                MdaInfra.LOG.error((Throwable)e);
            }
        }
    }

    private void addPluginsClassLoaders(List<ClassLoader> parentLoaders) {
        this.addPluginClassLoader(parentLoaders, "org.modelio.ramcs", "com.modeliosoft.modelio.ramcs.plugin.Ramcs");
        this.addPluginClassLoader(parentLoaders, "com.modeliosoft.modelio.scope", "com.modeliosoft.modelio.scope.plugin.Scope");
        this.addPluginClassLoader(parentLoaders, "org.modelio.script", "com.modeliosoft.modelio.script.engine.ScriptRunner");
        this.addPluginClassLoader(parentLoaders, "com.modeliosoft.modelio.svn", "com.modeliosoft.modelio.internal.svn.impl.plugin.Svn");
        this.addPluginClassLoader(parentLoaders, "org.modelio.edition", "com.modeliosoft.modelio.edition.plugin.Edition");
        this.addPluginClassLoader(parentLoaders, "org.modelio.mda.services", "com.modeliosoft.modelio.mda.services.plugin.MdaServices");
        this.addPluginClassLoader(parentLoaders, "org.modelio.mda.explorer.services", "com.modeliosoft.modelio.mda.explorer.services.plugin.MdaExplorerServices");
    }

    /*
     * Unable to fully structure code
     */
    private IMdac loadJavaMdac(IModule module, MdacClassLoader classLoader, String mainClassName) throws MdacException {
        ResourceBundle.clearCache((ClassLoader)classLoader);
        mdac = null;
        mdacConfiguration = new MdacConfiguration(module, this.workspacePath, this.projectspacePath, this.mdacManager.getMdacPath(module), this.mdacManager.getMdacDocpath(module));
        apiModelingSession = Modelio.getInstance().getModelingSession();
        mainClass = null;
        try {
            mainClass = classLoader.loadClass(mainClassName);
        }
        catch (ClassNotFoundException e) {
            MdaInfra.LOG.error((Throwable)e);
            mainClass = IncompatibleModule.class;
        }
        catch (NoClassDefFoundError e) {
            MdaInfra.LOG.error((Throwable)e);
            mainClass = IncompatibleModule.class;
        }
        try {
            classParamArray = new Class[]{IModelingSession.class, IModule.class, IMdacConfiguration.class};
            constructor = mainClass.getConstructor(classParamArray);
            initParamArray = new Object[]{apiModelingSession, module, mdacConfiguration};
            mdac = (IMdac)constructor.newInstance(initParamArray);
            mdac.init();
            this.registry.addLoadedMdac(mdac);
            return mdac;
        }
        catch (SecurityException e) {
            e2 = new MdacException(String.format("Security violation while loading the '%1$s' module: %2$s ", new Object[]{module.getName(), e.getMessage()}));
            e2.initCause((Throwable)e);
            throw e2;
        }
        catch (NoSuchMethodException e) {
            e2 = new MdacException(String.format("The '%1$s' module class constructor has not been found: %2$s", new Object[]{module.getName(), e.getMessage()}));
            e2.initCause((Throwable)e);
            throw e2;
        }
        catch (IllegalArgumentException e) {
            e2 = new MdacException(String.format("Illegal argument error while initalizing the '%1$s' module: %2$s ", new Object[]{module.getName(), e.getMessage()}));
            e2.initCause((Throwable)e);
            throw e2;
        }
        catch (InstantiationException e) {
            e2 = new MdacException(String.format("Cannot instantiate the '%1$s' module class: %2$s ", new Object[]{module.getName(), e.getMessage()}));
            e2.initCause((Throwable)e);
            throw e2;
        }
        catch (IllegalAccessException e) {
            e2 = new MdacException(String.format("Illegal access error occured while initalizing the '%1$s' module: %2$s ", new Object[]{module.getName(), e.getMessage()}));
            e2.initCause((Throwable)e);
            throw e2;
        }
        catch (InvocationTargetException e) {
            cause = e;
            ** while (cause.getCause() != null)
        }
lbl-1000:
        // 1 sources

        {
            cause = cause.getCause();
            continue;
        }
lbl54:
        // 1 sources

        e2 = new MdacException(String.format("Exception thrown while initalizing the '%1$s' module: %2$s\n", new Object[]{module.getName(), cause.getMessage()}));
        e2.initCause((Throwable)e);
        throw e2;
        catch (ExceptionInInitializerError e) {
            cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            e2 = new MdacException(String.format("Error thrown while initalizing the '%1$s' module: %2$s ", new Object[]{module.getName(), cause.getMessage()}));
            e2.initCause((Throwable)e);
            throw e2;
        }
        catch (LinkageError e) {
            cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            e2 = new MdacException(String.format("Linkage error thrown while initalizing the '%1$s' module: %2$s ", new Object[]{module.getName(), cause.getMessage()}));
            e2.initCause(cause);
            throw e2;
        }
    }

    private void loadWeakDependencyModules(IModule module) {
        List weakModuleReferences = this.mdacManager.getWeakDependencies(module);
        for (IMdacDescriptor weakModuleReference : weakModuleReferences) {
            IMdac usedMdac;
            Version version;
            IModule usedIModule = this.mdacManager.getModule(weakModuleReference.getName());
            if (usedIModule == null || (version = new Version(usedIModule.getVersion())).isOlderThan(weakModuleReference.getVersion()) || (usedMdac = this.registry.getLoadedMdac(usedIModule)) != null || !this.mdacManager.isActivated(usedIModule)) continue;
            try {
                this.loadMdac(usedIModule, this.mdacManager.getMdacClasspath(usedIModule));
            }
            catch (MdacException mdacException) {
                // empty catch block
            }
        }
    }

    private void loadRequiredMdacs(IModule mdacHandle) throws MdacException {
        for (IModule requiredMdacModel : mdacHandle.getDependsOn()) {
            if (this.registry.getLoadedMdac(requiredMdacModel) != null) continue;
            this.mdacManager.loadMdac(requiredMdacModel);
        }
    }
}

