/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mdainfra.mdacs.core;

import com.modeliosoft.modelio.api.mdac.AbstractJavaMdac;
import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.mdac.IMdacDescriptor;
import com.modeliosoft.modelio.api.mdac.IMdacSession;
import com.modeliosoft.modelio.api.mdac.MdacException;
import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.modelio.Version;
import com.modeliosoft.modelio.api.module.IPeerMdac;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.bridges.mda.infra.MdacManagerBridge;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.mdacs.UnknownMdacException;
import com.modeliosoft.modelio.core.model.Meta;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.mdainfra.mdacs.core.FakeModule;
import com.modeliosoft.modelio.mdainfra.mdacs.core.IMdacManager;
import com.modeliosoft.modelio.mdainfra.mdacs.core.MdacLoader;
import com.modeliosoft.modelio.mdainfra.mdacs.core.ModuleInfos;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.ModuleImporter;
import com.modeliosoft.modelio.mdainfra.mdacs.store.MdacArchiveInfo;
import com.modeliosoft.modelio.mdainfra.plugin.MdaInfra;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class MdacManager
implements IMdacManager {
    protected IModelingSession modelingSession;
    private final File projectSpacePath;
    private Map<String, ModuleInfos> moduleManifests = null;
    private static final String STATE_ATTRIBUTE = "state";
    private static final String DEACTIVATED_STATE = "SoModuleStateDesactivated";
    private static final String ACTIVATED_STATE = "SoModuleStateActivated";
    private MdacLoader loader;
    private static final String STARTED_STATE = "SoModuleStateStarted";

    public MdacManager(IModelingSession session) {
        this.modelingSession = session;
        this.projectSpacePath = this.modelingSession.getProjectSpacePath();
        this.moduleManifests = new HashMap();
        this.loader = new MdacLoader(this.modelingSession, (IMdacManager)this, this.projectSpacePath);
    }

    private final List<IMdac> getImpactedMdacs(IMdac mdac) {
        ArrayList<IMdac> ret = new ArrayList<IMdac>();
        ObList requiredObs = mdac.getModel().getImpacted();
        for (IModule obRequired : requiredObs) {
            IMdac requiredMdac = this.modelingSession.getMdacRegistry().getLoadedMdac(obRequired);
            if (requiredMdac == null) continue;
            ret.add(requiredMdac);
        }
        return ret;
    }

    public List<File> getMdacClasspath(IModule moduleModel) {
        File mdaDir = new File(this.projectSpacePath, "mda");
        File mdaRuntimeDir = new File(mdaDir, ".runtime");
        List mdaClasspath = this.getManifestClasspath(moduleModel, mdaDir);
        List mdaRuntimeClasspath = null;
        if (mdaClasspath != null) {
            mdaRuntimeClasspath = this.updateRuntimePath(mdaClasspath, mdaDir, mdaRuntimeDir);
        }
        return mdaRuntimeClasspath;
    }

    public File getMdacPath(IModule module) {
        return this.getMdacPath(module.getName());
    }

    public File getMdacPath(String moduleName) {
        File mdaPlugs = new File(this.projectSpacePath, "mda");
        File ret = new File(mdaPlugs, moduleName);
        return ret;
    }

    public <T extends IPeerMdac> T getPeerMdac(Class<T> metaclass) throws UnknownMdacException {
        try {
            for (IMdac module : this.modelingSession.getMdacRegistry().getStartedMdacs()) {
                IPeerMdac peerMdac = module.getPeerMdac();
                String metaclassInterfaceName = metaclass.getCanonicalName();
                Class<?> peerMdacClass = peerMdac.getClass();
                Class<?>[] classArray = peerMdacClass.getInterfaces();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> interf = classArray[n2];
                    String interfName = interf.getCanonicalName();
                    if (interfName.equals(metaclassInterfaceName)) {
                        return (T)((IPeerMdac)metaclass.cast(peerMdac));
                    }
                    ++n2;
                }
            }
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        throw new UnknownMdacException(String.format("The '%s' module is not kwown as a Java module", metaclass.getName()));
    }

    public final List<IMdacDescriptor> getRequiredMdacs(IMdac module) {
        ArrayList<IMdacDescriptor> requiredDependencies = new ArrayList<IMdacDescriptor>();
        ModuleInfos manifest = this.loadModuleInfos(module.getName(), false);
        if (manifest != null) {
            for (IMdacDescriptor moduleReference : manifest.getDependencies()) {
                requiredDependencies.add(moduleReference);
            }
        }
        return requiredDependencies;
    }

    public void startAllModules(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        ObList selectedModules = this.modelingSession.getModel().getProject().getInstalled();
        progress.setWorkRemaining(selectedModules.size());
        for (IModule moduleModel : selectedModules) {
            try {
                IMdac module = this.loadMdac(moduleModel);
                if (this.isActivated(moduleModel)) {
                    progress.subTask(MdaInfra.I18N.getMessage("MdacStartProgress.Starting", new String[]{module.getLabel(), module.getVersion().toString()}));
                    this.startMdac(module);
                }
            }
            catch (MdacException | LinkageError | RuntimeException e) {
                MdaInfra.LOG.error(e);
            }
            progress.worked(1);
        }
        progress.done();
    }

    public boolean selectMdac(IMdac mdac) throws MdacException {
        try {
            boolean selectSuccessful = mdac.getSession().select();
            this.activate(mdac.getModel());
            if (!selectSuccessful) {
                this.deactivate(mdac.getModel());
            }
            return selectSuccessful;
        }
        catch (MdacException e) {
            MdaInfra.LOG.error((Throwable)e);
            this.deactivate(mdac.getModel());
            throw e;
        }
        catch (Error | RuntimeException e) {
            MdaInfra.LOG.error(e);
            this.deactivate(mdac.getModel());
            MdacException e2 = new MdacException(String.format("Exception thrown while selecting the '%1$s' module: %2$s . \n\nThe stack trace is available in the Modelio log file.\nReport it with the error to the module developer.", mdac.getName(), e.toString()));
            e2.initCause(e);
            throw e2;
        }
    }

    private boolean doStartMdac(IMdac mdac) throws MdacException, RuntimeException, Error {
        boolean startSuccessful = false;
        try {
            this.modelingSession.getMdacRegistry().addStartedMdac(mdac);
            if (mdac instanceof AbstractJavaMdac) {
                ((AbstractJavaMdac)mdac).setState(IMdac.MdacState.Started);
            } else if (mdac instanceof FakeModule) {
                ((FakeModule)mdac).setState(IMdac.MdacState.Started);
            }
            ITransaction transaction = this.modelingSession.getTransactionManager().createTransaction(String.valueOf(mdac.getName()) + " start");
            try {
                try {
                    startSuccessful = mdac.getSession().start();
                    this.modelingSession.getTransactionManager().commit(transaction);
                    transaction = null;
                }
                catch (InvalidTransactionException e) {
                    transaction = null;
                    throw new MdacException("Could not start" + mdac.getName() + ", blocked by audit.");
                }
                catch (Exception e) {
                    throw new MdacException("Could not start" + mdac.getName() + ".", (Throwable)e);
                }
            }
            finally {
                if (transaction != null) {
                    this.modelingSession.getTransactionManager().rollback(transaction);
                }
            }
        }
        finally {
            if (startSuccessful) {
                this.loadModuleInfos(mdac.getName(), true);
            } else {
                if (mdac instanceof AbstractJavaMdac) {
                    ((AbstractJavaMdac)mdac).setState(IMdac.MdacState.Loaded);
                } else if (mdac instanceof FakeModule) {
                    ((FakeModule)mdac).setState(IMdac.MdacState.Loaded);
                }
                this.modelingSession.getMdacRegistry().removeStartedMdac(mdac);
            }
        }
        return startSuccessful;
    }

    private void doStopMdac(IMdac mdac) throws MdacException {
        try {
            this.unloadModuleInfos(mdac.getName());
            mdac.getSession().stop();
        }
        finally {
            if (mdac instanceof AbstractJavaMdac) {
                ((AbstractJavaMdac)mdac).setState(IMdac.MdacState.Loaded);
            } else if (mdac instanceof FakeModule) {
                ((FakeModule)mdac).setState(IMdac.MdacState.Loaded);
            }
            this.modelingSession.getMdacRegistry().removeStartedMdac(mdac);
        }
    }

    public Set<IMdac> stopAllModules() throws MdacException {
        IMdac module;
        HashSet<IMdac> stoppedModules = new HashSet<IMdac>();
        IMdac[] iMdacArray = this.modelingSession.getMdacRegistry().getStartedMdacs().toArray(new IMdac[0]);
        int n = iMdacArray.length;
        int n2 = 0;
        while (n2 < n) {
            module = iMdacArray[n2];
            try {
                this.stopMdac(module, stoppedModules);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            catch (LinkageError e) {
                e.printStackTrace();
            }
            ++n2;
        }
        iMdacArray = this.modelingSession.getMdacRegistry().getLoadedModules().toArray(new IMdac[0]);
        n = iMdacArray.length;
        n2 = 0;
        while (n2 < n) {
            module = iMdacArray[n2];
            try {
                this.unloadMdac(module);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            catch (LinkageError e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return stoppedModules;
    }

    public Set<IMdac> unselectMdac(IMdac module) throws MdacException {
        HashSet<IMdac> unselectedModules = new HashSet<IMdac>();
        this.unselectMdac(module, unselectedModules);
        return unselectedModules;
    }

    private void copyFile(File srcFile, File dstFile) {
        try {
            int len;
            FileInputStream in = new FileInputStream(srcFile);
            FileOutputStream out = new FileOutputStream(dstFile);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private List<File> getManifestClasspath(IModule moduleModel, File mdaDir) {
        File modulePath = new File(mdaDir, moduleModel.getName());
        ArrayList<File> classpathFiles = new ArrayList<File>();
        ModuleInfos manifest = this.loadModuleInfos(moduleModel.getName(), false);
        if (manifest != null) {
            for (String path : manifest.getClasspath()) {
                File jarFile = new File(modulePath, path);
                if (!jarFile.isFile()) continue;
                classpathFiles.add(jarFile);
            }
        }
        return classpathFiles;
    }

    private List<File> updateRuntimePath(List<File> classpath, File mdaDir, File mdaRuntimeDir) {
        ArrayList<File> runtimeClasspath = new ArrayList<File>();
        for (File file : classpath) {
            String mdaDirPath = mdaDir.getAbsolutePath();
            String relativFilePath = file.getAbsolutePath();
            relativFilePath = relativFilePath.replace(mdaDirPath, "");
            File destination = this.getRuntimeJarFile(mdaRuntimeDir, relativFilePath);
            destination.getParentFile().mkdirs();
            this.copyFile(file, destination);
            if (!destination.isFile()) continue;
            runtimeClasspath.add(destination);
        }
        return runtimeClasspath;
    }

    public void restartModule(IMdac module) {
        try {
            Set modulesToReload = this.stopMdac(module);
            modulesToReload.remove(module);
            this.unloadMdac(module);
            IModule moduleModel = module.getModel();
            IMdac newModule = this.loadMdac(moduleModel);
            this.startMdac(newModule);
            for (IMdac moduleToReload : modulesToReload) {
                this.unloadMdac(moduleToReload);
            }
            for (IMdac moduleToReload : modulesToReload) {
                IModule mdacModelToReload = moduleToReload.getModel();
                List classpathToReload = this.getMdacClasspath(mdacModelToReload);
                IMdac reloadedMdac = this.loadMdac(mdacModelToReload, classpathToReload);
                this.startMdac(reloadedMdac);
            }
            List weakImpactedModules = this.getWeakImpactedModules(newModule.getModel());
            for (IModule weakImpactedModule : weakImpactedModules) {
                IMdac weakImpactedMdac = this.modelingSession.getMdacRegistry().getLoadedMdac(weakImpactedModule);
                if (weakImpactedMdac == null || !this.isActivated(weakImpactedModule)) continue;
                this.restartModule(weakImpactedMdac);
            }
        }
        catch (MdacException e) {
            MdaInfra.LOG.error((Throwable)e);
        }
    }

    public Set<IMdac> stopMdac(IMdac module) throws MdacException {
        HashSet<IMdac> stoppedModules = new HashSet<IMdac>();
        this.stopMdac(module, stoppedModules);
        return stoppedModules;
    }

    public boolean startMdac(IMdac mdac) throws MdacException {
        if (this.modelingSession.getMdacRegistry().getStartedMdac(mdac.getModel()) != null) {
            return true;
        }
        if (!this.isActivated(mdac.getModel())) {
            return false;
        }
        for (IModule requiredMdacModel : mdac.getModel().getDependsOn()) {
            IMdac lMdac = this.modelingSession.getMdacRegistry().getLoadedMdac(requiredMdacModel);
            if (this.startMdac(lMdac)) continue;
            return false;
        }
        for (IMdacDescriptor weakModuleReference : this.getWeakDependencies(mdac.getModel())) {
            IMdac weakRequiredMdac;
            Version weakDepModuleVersion;
            IModule weakDependencyModule = this.getModule(weakModuleReference.getName());
            if (weakDependencyModule == null || !(weakDepModuleVersion = new Version(weakDependencyModule.getVersion())).isNewerThan(weakModuleReference.getVersion()) && !weakDepModuleVersion.equals((Object)weakModuleReference.getVersion()) || !this.isActivated(weakDependencyModule) || (weakRequiredMdac = this.modelingSession.getMdacRegistry().getLoadedMdac(weakDependencyModule)) == null) continue;
            this.startMdac(weakRequiredMdac);
        }
        return this.doStartMdac(mdac);
    }

    private void stopMdac(IMdac mdac, Set<IMdac> stoppedModules) {
        if (this.modelingSession.getMdacRegistry().getStartedMdac(mdac.getModel()) == null) {
            return;
        }
        try {
            for (IMdac impactedModule : this.getImpactedMdacs(mdac)) {
                try {
                    this.stopMdac(impactedModule, stoppedModules);
                }
                catch (RuntimeException e) {
                    MdaInfra.LOG.error((Throwable)e);
                }
            }
            for (IMdac impactedModule : this.getWeakImpactedModules(mdac.getModel())) {
                try {
                    IMdac impactedMdac = this.modelingSession.getMdacRegistry().getStartedMdac((IModule)impactedModule);
                    if (impactedMdac == null) continue;
                    this.stopMdac(impactedMdac, stoppedModules);
                }
                catch (RuntimeException e) {
                    MdaInfra.LOG.error((Throwable)e);
                }
            }
            this.doStopMdac(mdac);
        }
        catch (Exception e) {
            MdaInfra.LOG.error((Throwable)e);
        }
        stoppedModules.add(mdac);
    }

    private File getRuntimeJarFile(File mdaRuntimeDir, String relativFilePath) {
        File runTimeJarFile = new File(mdaRuntimeDir, relativFilePath);
        String jarName = relativFilePath.substring(0, relativFilePath.lastIndexOf(".jar"));
        int cpt = 0;
        while (runTimeJarFile.exists()) {
            runTimeJarFile = new File(mdaRuntimeDir, String.valueOf(jarName) + "_" + cpt + ".jar");
            ++cpt;
        }
        return runTimeJarFile;
    }

    private void unselectMdac(IMdac mdac, Set<IMdac> unselectedModules) throws MdacException {
        for (IMdac impactedModule : this.getImpactedMdacs(mdac)) {
            try {
                this.unselectMdac(impactedModule, unselectedModules);
            }
            catch (MdacException | RuntimeException e) {
                MdaInfra.LOG.error(e);
            }
        }
        mdac.getSession().unselect();
        unselectedModules.add(mdac);
    }

    private ModuleInfos loadModuleInfos(String moduleName, boolean update) {
        if (moduleName.equals("LocalModule")) {
            return null;
        }
        ModuleInfos manifest = (ModuleInfos)this.moduleManifests.get(moduleName);
        try {
            if (update || manifest == null) {
                File mdaDir = new File(this.projectSpacePath, "mda");
                manifest = new ModuleInfos(new File(mdaDir, moduleName));
                this.moduleManifests.put(moduleName, manifest);
            }
        }
        catch (Exception e) {
            String msg = null;
            if (e.getCause() != null) {
                msg = e.getCause().getLocalizedMessage();
            }
            if (msg == null || msg.isEmpty()) {
                msg = e.getLocalizedMessage();
            }
            String title = MdaInfra.I18N.getMessage("DeployMdacHandler.FailedTitle", new String[]{moduleName});
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)title, (String)(e.getCause() != null ? e.getCause().getLocalizedMessage() : e.getLocalizedMessage()));
        }
        return manifest;
    }

    private void unloadModuleInfos(String moduleName) {
        this.moduleManifests.remove(moduleName);
    }

    public List<IMdacDescriptor> getWeakDependencies(IModule module) {
        ArrayList<IMdacDescriptor> weakDependencies = new ArrayList<IMdacDescriptor>();
        ModuleInfos manifest = this.loadModuleInfos(module.getName(), false);
        if (manifest != null) {
            for (IMdacDescriptor moduleReference : manifest.getWeakDependencies()) {
                weakDependencies.add(moduleReference);
            }
        }
        return weakDependencies;
    }

    public List<IModule> getWeakImpactedModules(IModule module) {
        ArrayList<IModule> weakImpacted = new ArrayList<IModule>();
        Version version = new Version(module.getVersion());
        for (IModule tmpModule : this.modelingSession.getModel().getProject().getInstalled()) {
            for (IMdacDescriptor mr : this.getWeakDependencies(tmpModule)) {
                if (!mr.getName().equals(module.getName()) || !version.isNewerThan(mr.getVersion()) && !version.equals((Object)mr.getVersion())) continue;
                weakImpacted.add(tmpModule);
            }
        }
        return weakImpacted;
    }

    public IModule getModule(String moduleName) {
        for (IModule module : this.modelingSession.getModel().getProject().getInstalled()) {
            if (!module.getName().equals(moduleName)) continue;
            return module;
        }
        return null;
    }

    private void loadDynamicModel(IMdac module) throws IOException {
        File repositoryPath = this.getMdacPath(module.getName());
        File propertyFile = new File(String.valueOf(repositoryPath.getAbsolutePath()) + "/module.xml");
        if (!propertyFile.exists()) {
            throw new IOException("module.xml");
        }
        ModuleImporter importer = new ModuleImporter(this.modelingSession, propertyFile);
        importer.loadDynamicModel(module);
    }

    public ModuleInfos getModuleInfos(IModule module) {
        return this.loadModuleInfos(module.getName(), false);
    }

    public void unloadMdac(IMdac mdac) {
        if (mdac.getState() == IMdac.MdacState.Started) {
            throw new IllegalArgumentException("Module '" + mdac.getName() + "' is still in started state. Stop it before unloading it.");
        }
        mdac.uninit();
        this.modelingSession.getMdacRegistry().removeLoadedMdac(mdac);
        ResourceBundle.clearCache(mdac.getClass().getClassLoader());
    }

    public IMdac loadMdac(IModule mdacHandle, List<File> classPath) throws MdacException {
        IMdac loadedMdac = this.loader.loadMdac(mdacHandle, classPath);
        if (!loadedMdac.getName().equals("LocalModule") && loadedMdac.getState() != IMdac.MdacState.Incompatible) {
            try {
                this.loadDynamicModel(loadedMdac);
            }
            catch (IOException e) {
                MdacException e2 = new MdacException(MdaInfra.I18N.getMessage("L1", new String[]{loadedMdac.getName(), e.getMessage()}));
                e2.initCause((Throwable)e);
                throw e2;
            }
        }
        return loadedMdac;
    }

    public boolean isActivated(IModule module) {
        return ACTIVATED_STATE.equals(new Meta((IElement)module).getAttributeValue(STATE_ATTRIBUTE)) || STARTED_STATE.equals(new Meta((IElement)module).getAttributeValue(STATE_ATTRIBUTE));
    }

    private boolean isDeactivated(IMdac mdac) {
        return this.isDeactivated(mdac.getModel());
    }

    private boolean isDeactivated(IModule module) {
        return DEACTIVATED_STATE.equals(new Meta((IElement)module).getAttributeValue(STATE_ATTRIBUTE));
    }

    public IMdac loadMdac(IModule mdacHandle) throws MdacException {
        return this.loadMdac(mdacHandle, this.getMdacClasspath(mdacHandle));
    }

    /*
     * Unable to fully structure code
     */
    public boolean installModule(MdacArchiveInfo module, List<File> classpath) throws MdacException {
        moduleClassName = module.mainClass;
        if (!moduleClassName.equals("")) {
            moduleModel = this.getModule(module.getName());
            classLoader = this.loader.setupClassLoader(moduleModel, classpath);
            sessionClassName = moduleClassName;
            try {
                index = sessionClassName.lastIndexOf("Mdac");
                if (index == sessionClassName.length() - 4) {
                    sessionClassName = sessionClassName.substring(0, index);
                    sessionClassName = sessionClassName.concat("Session");
                }
                if (!IMdacSession.class.isAssignableFrom(sessionClass = classLoader.loadClass(sessionClassName))) {
                    throw new MdacException(String.format("''%1$s' does not extend '%2$s'.", new Object[]{sessionClass.getName(), IMdacSession.class.getName()}));
                }
                classParamArray = new Class[]{String.class, String.class};
                initParamArray = new Object[]{this.projectSpacePath.getPath(), this.getMdacPath(module.name).getAbsolutePath()};
                installMethod = sessionClass.getMethod("install", classParamArray);
                result = installMethod.invoke(null, initParamArray);
                if (result instanceof Boolean) {
                    moduleInstalled = (Boolean)result;
                    return moduleInstalled;
                }
                return false;
            }
            catch (NullPointerException npe) {
                MdaInfra.LOG.error((Throwable)npe);
                e2 = new MdacException(MdaInfra.I18N.getMessage("install_is_not_static", new String[]{module.name}));
                e2.initCause((Throwable)npe);
                throw e2;
            }
            catch (SecurityException e) {
                MdaInfra.LOG.error((Throwable)e);
                e2 = new MdacException(String.format("Security violation while loading the '%1$s' module:\n %2$s ", new Object[]{module.name, e.getMessage()}));
                e2.initCause((Throwable)e);
                throw e2;
            }
            catch (ClassNotFoundException e) {
                MdaInfra.LOG.error((Throwable)e);
                e2 = new MdacException(String.format("The '%1$s' module class has not been found.\n (%2$s)", new Object[]{sessionClassName, e.getMessage()}));
                e2.initCause((Throwable)e);
                throw e2;
            }
            catch (NoClassDefFoundError e) {
                MdaInfra.LOG.error((Throwable)e);
                classLoader.getURLs();
                sUrls = new StringBuilder();
                var12_31 = classLoader.getURLs();
                var11_29 = var12_31.length;
                var10_27 = 0;
                ** while (var10_27 < var11_29)
            }
lbl-1000:
            // 1 sources

            {
                url = var12_31[var10_27];
                sUrls.append(" - ");
                sUrls.append(url.toString());
                sUrls.append("\n");
                ++var10_27;
                continue;
            }
lbl57:
            // 1 sources

            e2 = new MdacException(String.format("The '%1$s' module class couldn't find the '%2$s' class in the following classpath:\n (%3$s)", new Object[]{sessionClassName, e.getMessage(), sUrls}));
            e2.initCause((Throwable)e);
            throw e2;
            catch (NoSuchMethodException e) {
                MdaInfra.LOG.error((Throwable)e);
                e2 = new MdacException(String.format("The '%1$s' module class install method has not been found:\n (%2$s)", new Object[]{sessionClassName, e.getMessage()}));
                e2.initCause((Throwable)e);
                throw e2;
            }
            catch (IllegalAccessException e) {
                MdaInfra.LOG.error((Throwable)e);
                e2 = new MdacException(String.format("Illegal access error occured while initalizing the '%1$s' module: %2$s ", new Object[]{module.name, e.getMessage()}));
                e2.initCause((Throwable)e);
                throw e2;
            }
            catch (InvocationTargetException e) {
                MdaInfra.LOG.error((Throwable)e);
                cause = e.getCause();
                if (cause == null) {
                    cause = e;
                }
                e2 = new MdacException(String.format("Exception thrown while initalizing the '%1$s' module: %2$s ", new Object[]{module.name, cause.getMessage()}));
                e2.initCause(cause);
                throw e2;
            }
        }
        return false;
    }

    public void activate(IMdac mdac, boolean start) throws MdacException {
        IModule module = mdac.getModel();
        this.activate(module);
        if (start) {
            this.startMdac(mdac);
        }
    }

    public void activate(IModule module) {
        MdacManagerBridge.activateMdac((IModule)module);
    }

    public void deactivate(IMdac mdac) throws MdacException {
        if (mdac.getState() == IMdac.MdacState.Started) {
            this.stopMdac(mdac);
        }
        IModule module = mdac.getModel();
        this.deactivate(module);
        for (IModule weakDependentModule : this.getWeakImpactedModules(module)) {
            IMdac weakDependentMdac = this.modelingSession.getMdacRegistry().getLoadedMdac(weakDependentModule);
            if (weakDependentMdac == null || !this.isActivated(weakDependentModule)) continue;
            this.startMdac(weakDependentMdac);
        }
    }

    public void deactivate(IModule module) {
        MdacManagerBridge.deactivateMdac((IModule)module);
    }

    public List<File> getMdacDocpath(IModule moduleModel) {
        File mdaDir = new File(this.projectSpacePath, "mda");
        File mdaRuntimeDir = new File(mdaDir, ".runtime");
        List mdaDocpath = this.getManifestDocpath(moduleModel, mdaDir);
        List mdaRuntimeDocpath = Collections.emptyList();
        if (mdaDocpath != null) {
            mdaRuntimeDocpath = this.updateRuntimePath(mdaDocpath, mdaDir, mdaRuntimeDir);
        }
        return mdaRuntimeDocpath;
    }

    private List<File> getManifestDocpath(IModule moduleModel, File mdaDir) {
        File modulePath = new File(mdaDir, moduleModel.getName());
        ArrayList<File> docpathFiles = new ArrayList<File>();
        ModuleInfos manifest = this.loadModuleInfos(moduleModel.getName(), false);
        if (manifest != null) {
            for (String path : manifest.getDocPath()) {
                File jarFile = new File(modulePath, path);
                if (!jarFile.isFile()) continue;
                docpathFiles.add(jarFile);
            }
        }
        return docpathFiles;
    }
}

