/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mdainfra.mdacs.core;

import com.modeliosoft.modelio.api.mdac.IMdacDescriptor;
import com.modeliosoft.modelio.api.mdac.MdacException;
import com.modeliosoft.modelio.api.modelio.Version;
import com.modeliosoft.modelio.mdainfra.mdacs.core.MdacDescriptor;
import com.modeliosoft.modelio.mdainfra.mdacs.core.RamcDescriptor;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.ModuleImporter;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.model.Classpath;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.model.Docpath;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.model.Module;
import com.modeliosoft.modelio.mdainfra.plugin.MdaInfra;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ModuleInfos {
    private String uid;
    private String name;
    private String mainClassName;
    private boolean licenseRequired;
    private Version version;
    private Version binaryVersion;
    private final List<IMdacDescriptor> dependencies;
    private final List<IMdacDescriptor> weakDependencies;
    private final List<RamcDescriptor> ramcs;
    private final List<String> classpath;
    private final List<String> docPath;

    public ModuleInfos(InputStream s) throws MdacException {
        this.uid = "";
        this.name = "";
        this.mainClassName = "";
        this.licenseRequired = true;
        this.version = null;
        this.binaryVersion = null;
        this.dependencies = new ArrayList();
        this.weakDependencies = new ArrayList();
        this.ramcs = new ArrayList();
        this.classpath = new ArrayList();
        this.docPath = new ArrayList();
        this.readModule(s);
    }

    public ModuleInfos(File moduleDirectory) throws MdacException {
        block12: {
            this.uid = "";
            this.name = "";
            this.mainClassName = "";
            this.licenseRequired = true;
            this.version = null;
            this.binaryVersion = null;
            this.dependencies = new ArrayList();
            this.weakDependencies = new ArrayList();
            this.ramcs = new ArrayList();
            this.classpath = new ArrayList();
            this.docPath = new ArrayList();
            try {
                File moduleXmlFile = new File(moduleDirectory, "module.xml");
                if (moduleXmlFile.exists()) {
                    Throwable throwable = null;
                    Object var4_7 = null;
                    try (FileInputStream s = new FileInputStream(moduleXmlFile);){
                        this.readModule((InputStream)s);
                        break block12;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                MdaInfra.LOG.error(MdaInfra.I18N.getMessage("L12_no_manifest_xml_file", new String[]{this.name}));
            }
            catch (IOException e) {
                MdacException e2 = new MdacException(MdaInfra.I18N.getMessage("L1", new String[]{this.name, e.getMessage()}));
                e2.initCause((Throwable)e);
                throw e2;
            }
        }
    }

    public String getUid() {
        return this.uid;
    }

    public String getName() {
        return this.name;
    }

    public String getMainClassName() {
        return this.mainClassName;
    }

    public boolean isLicenseRequired() {
        return this.licenseRequired;
    }

    public Version getVersion() {
        return this.version;
    }

    public Version getBinaryVersion() {
        return this.binaryVersion;
    }

    public List<IMdacDescriptor> getDependencies() {
        return this.dependencies;
    }

    public List<IMdacDescriptor> getWeakDependencies() {
        return this.weakDependencies;
    }

    public List<RamcDescriptor> getRamcs() {
        return this.ramcs;
    }

    public List<String> getClasspath() {
        return this.classpath;
    }

    private void init(Module loadedModule) {
        this.uid = loadedModule.getUid();
        this.name = loadedModule.getName();
        this.mainClassName = loadedModule.getClazz();
        this.licenseRequired = Boolean.TRUE.equals(loadedModule.isLicenseRequired());
        String moduleVersion = loadedModule.getVersion();
        this.version = moduleVersion != null ? new Version(moduleVersion) : new Version("0.00.00");
        String modelioversion = loadedModule.getBinaryversion();
        this.binaryVersion = modelioversion != null ? new Version(modelioversion) : new Version("0.00.00");
        for (Object child : loadedModule.getParameterOrProfileOrGui()) {
            if (child instanceof Module.Dependencies) {
                Module.Dependencies deps = (Module.Dependencies)child;
                for (Object depChild : deps.getRequiredOrOptionalOrRamc()) {
                    Module.Dependencies.Required dep;
                    if (depChild instanceof Module.Dependencies.Required) {
                        dep = (Module.Dependencies.Required)depChild;
                        this.dependencies.add(new MdacDescriptor(dep.getName(), new Version(dep.getVersion())));
                        continue;
                    }
                    if (!(depChild instanceof Module.Dependencies.Optional)) continue;
                    dep = (Module.Dependencies.Optional)depChild;
                    this.weakDependencies.add(new MdacDescriptor(dep.getName(), new Version(dep.getVersion())));
                }
                continue;
            }
            if (child instanceof Classpath) {
                Classpath classpathEntries = (Classpath)child;
                for (Classpath.Entry classpathEntry : classpathEntries.getEntry()) {
                    this.classpath.add(classpathEntry.getPath());
                }
                continue;
            }
            if (!(child instanceof Docpath)) continue;
            Docpath docpathEntries = (Docpath)child;
            for (Docpath.Entry docpathEntry : docpathEntries.getEntry()) {
                this.docPath.add(docpathEntry.getPath());
            }
        }
    }

    private void readModule(InputStream s) throws MdacException {
        try {
            Module loadedModule = ModuleImporter.loadModule((InputStream)s);
            if (loadedModule != null) {
                this.init(loadedModule);
            }
        }
        catch (IOException e) {
            MdacException e2 = new MdacException(MdaInfra.I18N.getMessage("L1", new String[]{this.name, e.getMessage()}));
            e2.initCause((Throwable)e);
            throw e2;
        }
    }

    public List<String> getDocPath() {
        return this.docPath;
    }
}

