/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mdainfra.mdacs.core.configuration;

import com.modeliosoft.modelio.api.diagram.IDiagramCustomizer;
import com.modeliosoft.modelio.api.diagram.tools.IAttachedBoxCommand;
import com.modeliosoft.modelio.api.diagram.tools.IBoxCommand;
import com.modeliosoft.modelio.api.diagram.tools.IDiagramCommand;
import com.modeliosoft.modelio.api.diagram.tools.ILinkCommand;
import com.modeliosoft.modelio.api.diagram.tools.IMultiLinkCommand;
import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.mdac.commands.ActionLocation;
import com.modeliosoft.modelio.api.mdac.commands.DefaultMdacAction;
import com.modeliosoft.modelio.api.mdac.commands.IMdacAction;
import com.modeliosoft.modelio.api.mdac.commands.IMdacContextualCommand;
import com.modeliosoft.modelio.api.mdac.propertiesPage.IMdacPropertyPage;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.utils.StereotypeNotFoundException;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.model.MetaModelExpert;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.CommandRegistry;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.ModuleI18n;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.generic.GenericAttachedBoxCommand;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.generic.GenericBoxCommand;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.generic.GenericContextualCommand;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.generic.GenericDiagramCustomizer;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.generic.GenericLinkCommand;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.model.ContextualCommand;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.model.DiagramCommand;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.model.DiagramCommandBox;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.model.DiagramCommandLink;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.model.Handler;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.model.Module;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.model.Scope;
import com.modeliosoft.modelio.mdainfra.plugin.MdaInfra;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class GuiRegister {
    private IModelingSession session;
    private ModuleI18n i18n;

    public GuiRegister(IModelingSession session, ModuleI18n i18n) {
        this.session = session;
        this.i18n = i18n;
    }

    public void registerCommand(Module.Gui.Command command, IMdac module) throws IOException {
        Handler handler = null;
        for (Object child : command.getScopeOrHandlerOrContribution()) {
            if (!(child instanceof Handler)) continue;
            handler = (Handler)child;
        }
        String ster = "";
        if (handler != null) {
            try {
                ClassLoader loader = module.getSession().getClass().getClassLoader();
                Class<?> commandClass = loader.loadClass(handler.getClazz());
                String name = this.i18n.internationalize(command.getName());
                String label = this.i18n.internationalize(command.getLabel());
                String bitmap = this.i18n.internationalize(command.getImage());
                String tooltype = this.i18n.internationalize(command.getTooltip());
                String group = this.i18n.internationalize(command.getGroup());
                String imageGroup = this.i18n.internationalize(command.getGroupImage());
                boolean editionMode = command.getModifyModel() == null && command.getModifyModel().equals("true");
                DefaultMdacAction action = new DefaultMdacAction(module, name, label, tooltype, bitmap, group, imageGroup, editionMode, editionMode, (IMdacContextualCommand)commandClass.newInstance());
                for (Object child : command.getScopeOrHandlerOrContribution()) {
                    Class metaclass;
                    if (!(child instanceof Scope)) continue;
                    Scope scope = (Scope)child;
                    if (scope.getStereotype() != null && scope.getMetaclass() != null) {
                        ster = scope.getStereotype();
                        metaclass = MetaModelExpert.getMetaclass((String)scope.getMetaclass());
                        IStereotype stereotype = this.session.getModel().getMetamodelExtensions().getStereotype(metaclass, ster);
                        action.addAllowedStereotype(stereotype);
                        action.addAllowedMetaclass(metaclass);
                        continue;
                    }
                    if (scope.getMetaclass() == null) continue;
                    metaclass = MetaModelExpert.getMetaclass((String)scope.getMetaclass());
                    action.addAllowedMetaclass(metaclass);
                }
                for (Object child : command.getScopeOrHandlerOrContribution()) {
                    if (!(child instanceof ContextualCommand.Contribution)) continue;
                    ContextualCommand.Contribution contribution = (ContextualCommand.Contribution)child;
                    module.registerAction(ActionLocation.getValue((String)contribution.getLocation()), (IMdacAction)action);
                }
            }
            catch (ClassNotFoundException e) {
                throw new IOException(MdaInfra.I18N.getMessage("L43_class_not_found", new String[]{handler.getClazz()}));
            }
            catch (StereotypeNotFoundException e) {
                throw new IOException(MdaInfra.I18N.getMessage("L44_stereotype_not_found", new String[]{ster}));
            }
            catch (InstantiationException e) {
                throw new IOException(MdaInfra.I18N.getMessage("L43_class_not_found", new String[]{handler.getClazz()}));
            }
            catch (IllegalAccessException e) {
                throw new IOException(MdaInfra.I18N.getMessage("L43_class_not_found", new String[]{handler.getClazz()}));
            }
            catch (Exception e) {
                throw new IOException(e.toString());
            }
        }
    }

    public boolean registerCommand(DiagramCommand command, IMdac module) throws IOException {
        String name = this.i18n.internationalize(command.getName());
        String group = this.i18n.internationalize(command.getGroup());
        Handler handler = command.getHandler();
        if (handler != null) {
            String metaclass = handler.getMetaclass();
            String stereotype = handler.getStereotype();
            String relation = handler.getRelation();
            try {
                ClassLoader loader = module.getSession().getClass().getClassLoader();
                Class<?> commandClass = loader.loadClass(handler.getClazz());
                String label = this.i18n.internationalize(command.getLabel());
                String tooltype = this.i18n.internationalize(command.getTooltip());
                IDiagramCommand commandInstance = (IDiagramCommand)commandClass.newInstance();
                if (label != null) {
                    commandInstance.setLabel(label);
                }
                if (tooltype != null) {
                    commandInstance.setTooltip(tooltype);
                }
                if (command.getImage() != null && !command.getImage().equals("")) {
                    String bitmap = module.getConfiguration().getProjectSpacePath() + "/mda/" + module.getName() + "/" + this.i18n.internationalize(command.getImage());
                    ImageDescriptor descriptor = ImageDescriptor.createFromImage((Image)new Image((Device)new Shell().getDisplay(), bitmap));
                    commandInstance.setBitmap(descriptor);
                }
                Class metaclassClass = null;
                if (metaclass != null) {
                    metaclassClass = MetaModelExpert.getMetaclass((String)metaclass);
                }
                IStereotype stereotypeClass = null;
                if (stereotype != null && metaclassClass != null) {
                    stereotypeClass = this.session.getModel().getMetamodelExtensions().getStereotype(metaclassClass, stereotype);
                }
                if (commandInstance instanceof IAttachedBoxCommand) {
                    module.registerCustomizedTool(name, metaclassClass, stereotypeClass, relation, (IAttachedBoxCommand)commandInstance);
                } else if (commandInstance instanceof IBoxCommand) {
                    module.registerCustomizedTool(name, metaclassClass, stereotypeClass, relation, (IBoxCommand)commandInstance);
                } else if (commandInstance instanceof ILinkCommand) {
                    module.registerCustomizedTool(name, metaclassClass, stereotypeClass, relation, (ILinkCommand)commandInstance);
                } else if (commandInstance instanceof IMultiLinkCommand) {
                    module.registerCustomizedTool(name, metaclassClass, stereotypeClass, relation, (IMultiLinkCommand)commandInstance);
                }
                return true;
            }
            catch (ClassNotFoundException e) {
                throw new IOException(MdaInfra.I18N.getMessage("L43_class_not_found", new String[]{handler.getClazz()}));
            }
            catch (StereotypeNotFoundException e) {
                throw new IOException(MdaInfra.I18N.getMessage("L44_stereotype_not_found", new String[]{stereotype}));
            }
            catch (InstantiationException e) {
                throw new IOException(MdaInfra.I18N.getMessage("L43_class_not_found", new String[]{handler.getClazz()}));
            }
            catch (IllegalAccessException e) {
                throw new IOException(MdaInfra.I18N.getMessage("L43_class_not_found", new String[]{handler.getClazz()}));
            }
            catch (ClassCastException e) {
                throw new IOException(MdaInfra.I18N.getMessage("L45_class_cast_exception", new String[]{handler.getClazz()}));
            }
            catch (Exception e) {
                throw new IOException(e.toString());
            }
        }
        return name != null && group != null;
    }

    public void registerPropertyPage(Module.Gui.PropertyPage property, IMdac module) throws IOException {
        try {
            ClassLoader loader = module.getSession().getClass().getClassLoader();
            Class<?> commandClass = loader.loadClass(property.getClazz());
            String name = this.i18n.internationalize(property.getName());
            String label = this.i18n.internationalize(property.getLabel());
            IMdacPropertyPage propertypage = (IMdacPropertyPage)commandClass.newInstance();
            if (name != null) {
                propertypage.setName(name);
            }
            if (label != null) {
                propertypage.setLabel(label);
            }
            if (property.getImage() != null && !property.getImage().equals("")) {
                String bitmap = module.getConfiguration().getProjectSpacePath() + "/mda/" + module.getName() + "/" + this.i18n.internationalize(property.getImage());
                ImageDescriptor descriptor = ImageDescriptor.createFromImage((Image)new Image((Device)new Shell().getDisplay(), bitmap));
                propertypage.setBitmap(descriptor);
            }
            propertypage.setMdac(module);
            module.getPropertyPages().add(propertypage);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(MdaInfra.I18N.getMessage("L43_class_not_found", new String[]{property.getClazz()}));
        }
        catch (InstantiationException e) {
            throw new IOException(MdaInfra.I18N.getMessage("L43_class_not_found", new String[]{property.getClazz()}));
        }
        catch (IllegalAccessException e) {
            throw new IOException(MdaInfra.I18N.getMessage("L43_class_not_found", new String[]{property.getClazz()}));
        }
        catch (ClassCastException e) {
            throw new IOException(MdaInfra.I18N.getMessage("L45_class_cast_exception", new String[]{property.getClazz()}));
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    public void registerPalette(Module.Gui.CustomizedDiagram diagram, List<CommandRegistry> commands, IMdac module) throws IOException {
        try {
            String metaclass = diagram.getBaseDiagram();
            String stereotype = diagram.getStereotype();
            Class metaclassClass = null;
            if (metaclass != null) {
                metaclassClass = MetaModelExpert.getMetaclass((String)metaclass);
            }
            IStereotype stereotypeClass = null;
            if (stereotype != null && metaclassClass != null) {
                stereotypeClass = this.session.getModel().getMetamodelExtensions().getStereotype(metaclassClass, stereotype);
                GenericDiagramCustomizer customizer = new GenericDiagramCustomizer(commands, diagram.isKeepBasePalette().booleanValue(), module);
                module.registerDiagramCustomization(stereotypeClass, metaclassClass, (IDiagramCustomizer)customizer);
            }
        }
        catch (StereotypeNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    public void registerCommand(ContextualCommand command, IMdac module) throws IOException {
        String ster = "";
        try {
            ArrayList<Scope> scopes = new ArrayList<Scope>();
            Handler handler = null;
            for (Object child : command.getScopeOrHandlerOrContribution()) {
                if (child instanceof Handler) {
                    handler = (Handler)child;
                    continue;
                }
                if (!(child instanceof Scope)) continue;
                scopes.add((Scope)child);
            }
            if (handler != null && scopes.size() > 0) {
                String name = this.i18n.internationalize(command.getName());
                String label = this.i18n.internationalize(command.getLabel());
                String bitmap = this.i18n.internationalize(command.getImage());
                String tooltype = this.i18n.internationalize(command.getTooltip());
                String group = this.i18n.internationalize(command.getGroup());
                String imageGroup = this.i18n.internationalize(command.getGroupImage());
                boolean editionMode = command.getModifyModel() == null && command.getModifyModel().equals("true");
                GenericContextualCommand genericCommand = new GenericContextualCommand(name, handler, scopes);
                DefaultMdacAction action = new DefaultMdacAction(module, name, label, tooltype, bitmap, group, imageGroup, editionMode, editionMode, (IMdacContextualCommand)genericCommand);
                for (Scope scope : scopes) {
                    Class metaclass;
                    if (scope.getStereotype() != null && scope.getMetaclass() != null) {
                        ster = scope.getStereotype();
                        metaclass = MetaModelExpert.getMetaclass((String)scope.getMetaclass());
                        IStereotype stereotype = this.session.getModel().getMetamodelExtensions().getStereotype(metaclass, ster);
                        action.addAllowedStereotype(stereotype);
                        action.addAllowedMetaclass(metaclass);
                        continue;
                    }
                    if (scope.getMetaclass() == null) continue;
                    metaclass = MetaModelExpert.getMetaclass((String)scope.getMetaclass());
                    action.addAllowedMetaclass(metaclass);
                }
                for (Object child : command.getScopeOrHandlerOrContribution()) {
                    if (!(child instanceof ContextualCommand.Contribution)) continue;
                    ContextualCommand.Contribution contribution = (ContextualCommand.Contribution)child;
                    module.registerAction(ActionLocation.getValue((String)contribution.getLocation()), (IMdacAction)action);
                }
            }
        }
        catch (StereotypeNotFoundException e) {
            throw new IOException(MdaInfra.I18N.getMessage("L44_stereotype_not_found", new String[]{ster}));
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    public boolean registerCommand(DiagramCommandBox command, IMdac module) throws IOException {
        String group;
        String name;
        String stereotype;
        block9: {
            stereotype = "";
            name = this.i18n.internationalize(command.getName());
            group = this.i18n.internationalize(command.getGroup());
            ArrayList<Scope> scopes = new ArrayList<Scope>();
            Handler handler = null;
            for (Object child : command.getScopeOrHandler()) {
                if (child instanceof Handler) {
                    handler = (Handler)child;
                    continue;
                }
                if (!(child instanceof Scope)) continue;
                scopes.add((Scope)child);
            }
            if (handler == null || scopes.size() <= 0) break block9;
            ImageDescriptor descriptor = null;
            String label = this.i18n.internationalize(command.getLabel());
            String tooltype = this.i18n.internationalize(command.getTooltip());
            if (command.getImage() != null && !command.getImage().equals("")) {
                String bitmap = module.getConfiguration().getProjectSpacePath() + "/mda/" + module.getName() + "/" + this.i18n.internationalize(command.getImage());
                descriptor = ImageDescriptor.createFromImage((Image)new Image((Device)new Shell().getDisplay(), bitmap));
            }
            GenericBoxCommand commandInstance = new GenericBoxCommand(label, descriptor, tooltype, handler, scopes);
            stereotype = handler.getStereotype();
            String metaclass = handler.getMetaclass();
            String relation = handler.getRelation();
            Class metaclassClass = null;
            if (metaclass != null) {
                metaclassClass = MetaModelExpert.getMetaclass((String)metaclass);
            }
            IStereotype stereotypeClass = null;
            if (stereotype != null && metaclassClass != null) {
                stereotypeClass = this.session.getModel().getMetamodelExtensions().getStereotype(metaclassClass, stereotype);
            }
            module.registerCustomizedTool(name, metaclassClass, stereotypeClass, relation, (IBoxCommand)commandInstance);
            return true;
        }
        try {
            return name != null && group != null;
        }
        catch (StereotypeNotFoundException e) {
            throw new IOException(MdaInfra.I18N.getMessage("L44_stereotype_not_found", new String[]{stereotype}));
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    public boolean registerAttachedBoxCommand(DiagramCommandBox command, IMdac module) throws IOException {
        String group;
        String name;
        String stereotype;
        block9: {
            stereotype = "";
            name = this.i18n.internationalize(command.getName());
            group = this.i18n.internationalize(command.getGroup());
            ArrayList<Scope> scopes = new ArrayList<Scope>();
            Handler handler = null;
            for (Object child : command.getScopeOrHandler()) {
                if (child instanceof Handler) {
                    handler = (Handler)child;
                    continue;
                }
                if (!(child instanceof Scope)) continue;
                scopes.add((Scope)child);
            }
            if (handler == null || scopes.size() <= 0) break block9;
            ImageDescriptor descriptor = null;
            String label = this.i18n.internationalize(command.getLabel());
            String tooltype = this.i18n.internationalize(command.getTooltip());
            if (command.getImage() != null && !command.getImage().equals("")) {
                String bitmap = module.getConfiguration().getProjectSpacePath() + "/mda/" + module.getName() + "/" + this.i18n.internationalize(command.getImage());
                descriptor = ImageDescriptor.createFromImage((Image)new Image((Device)new Shell().getDisplay(), bitmap));
            }
            GenericAttachedBoxCommand commandInstance = new GenericAttachedBoxCommand(label, descriptor, tooltype, handler, scopes);
            String metaclass = handler.getMetaclass();
            stereotype = handler.getStereotype();
            String relation = handler.getRelation();
            Class metaclassClass = null;
            if (metaclass != null) {
                metaclassClass = MetaModelExpert.getMetaclass((String)metaclass);
            }
            IStereotype stereotypeClass = null;
            if (stereotype != null && metaclassClass != null) {
                stereotypeClass = this.session.getModel().getMetamodelExtensions().getStereotype(metaclassClass, stereotype);
            }
            module.registerCustomizedTool(name, metaclassClass, stereotypeClass, relation, (IAttachedBoxCommand)commandInstance);
            return true;
        }
        try {
            return name != null && group != null;
        }
        catch (StereotypeNotFoundException e) {
            throw new IOException(MdaInfra.I18N.getMessage("L44_stereotype_not_found", new String[]{stereotype}));
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    public boolean registerCommand(DiagramCommandLink command, IMdac module) throws IOException {
        String group;
        String name;
        String stereotype;
        block7: {
            stereotype = "";
            name = this.i18n.internationalize(command.getName());
            group = this.i18n.internationalize(command.getGroup());
            Handler handler = command.getHandler();
            List sources = command.getScopeSource();
            List target = command.getScopeTarget();
            if (handler == null || sources == null || sources.size() <= 0 || target.size() <= 0 || target.size() <= 0) break block7;
            ImageDescriptor descriptor = null;
            String label = this.i18n.internationalize(command.getLabel());
            String tooltype = this.i18n.internationalize(command.getTooltip());
            if (command.getImage() != null && !command.getImage().equals("")) {
                String bitmap = module.getConfiguration().getProjectSpacePath() + "/mda/" + module.getName() + "/" + this.i18n.internationalize(command.getImage());
                descriptor = ImageDescriptor.createFromImage((Image)new Image((Device)new Shell().getDisplay(), bitmap));
            }
            GenericLinkCommand commandInstance = new GenericLinkCommand(label, descriptor, tooltype, handler, sources, target);
            String metaclass = handler.getMetaclass();
            stereotype = handler.getStereotype();
            String relation = handler.getRelation();
            Class metaclassClass = null;
            if (metaclass != null) {
                metaclassClass = MetaModelExpert.getMetaclass((String)metaclass);
            }
            IStereotype stereotypeClass = null;
            if (stereotype != null && metaclassClass != null) {
                stereotypeClass = this.session.getModel().getMetamodelExtensions().getStereotype(metaclassClass, stereotype);
            }
            module.registerCustomizedTool(name, metaclassClass, stereotypeClass, relation, (ILinkCommand)commandInstance);
            return true;
        }
        try {
            return name != null && group != null;
        }
        catch (StereotypeNotFoundException e) {
            throw new IOException(MdaInfra.I18N.getMessage("L44_stereotype_not_found", new String[]{stereotype}));
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }
}

