/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mdainfra.mdacs.core.configuration;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.model.extension.IConfigParam;
import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.extension.IProject;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IExternDocumentType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IMetaclassReference;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INoteType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IProfile;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITagType;
import com.modeliosoft.modelio.api.modelio.Version;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.core.model.Meta;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.ModuleI18n;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.model.Externdocumenttype;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.model.Module;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.model.Notetype;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.model.Taggedvalues;
import com.modeliosoft.modelio.mdainfra.mdacs.store.MdacArchiveInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ModelFactory {
    private IModelFactory model;
    private IModelingSession session;
    HashMap<IStereotype, String> stereotype_map;
    private ModuleI18n i18n;

    public ModelFactory(IModelingSession session, ModuleI18n i18n) {
        this.session = session;
        this.model = session.getModelFactory();
        this.stereotype_map = new HashMap();
        this.i18n = i18n;
    }

    public IConfigParam createConfigParam(Module.Parameter jaxbelement, IModule owner) {
        ObRef ref = new ObRef("ConfigParam", jaxbelement.getUid());
        IConfigParam element = (IConfigParam)this.session.getModel().findByRef(ref);
        if (element == null) {
            element = (IConfigParam)this.model.createElement("ConfigParam", jaxbelement.getUid());
        }
        element.setName(jaxbelement.getName());
        element.setOwner(owner);
        return element;
    }

    public IMetaclassReference createMetaClassReferance(Module.Profile.AnonymousStereotype jaxbelement, IProfile owner) {
        ObRef ref = new ObRef("MetaclassReference", jaxbelement.getUid());
        IMetaclassReference element = (IMetaclassReference)this.session.getModel().findByRef(ref);
        if (element == null) {
            element = (IMetaclassReference)this.model.createElement("MetaclassReference", jaxbelement.getUid());
        }
        element.setReferencedClassName(jaxbelement.getMetaclass());
        element.setOwnerProfile(owner);
        return element;
    }

    public IModule createModule(Module jaxbelement, MdacArchiveInfo moduleInfo, IProject owner) {
        ObRef ref = new ObRef("Module", jaxbelement.getUid());
        IModule element = (IModule)this.session.getModel().findByRef(ref);
        if (element == null) {
            element = (IModule)this.model.createElement("Module", jaxbelement.getUid());
        } else {
            this.session.getAccessManager().setUserWriteRight((IElement)element, true);
        }
        Meta meta = new Meta((IElement)element);
        Version version = moduleInfo.getVersion();
        meta.setAttributeValue("majVersion", (Object)new Integer(version.getMajorVersion()));
        meta.setAttributeValue("minVersion", (Object)new Integer(version.getMinorVersion()));
        meta.setAttributeValue("minMinVersion", (Object)(String.valueOf(Integer.toString(version.getBuildVersion())) + "." + Integer.toString(version.getMetamodelVersion())));
        element.setName(jaxbelement.getName());
        element.setjavaClassName(jaxbelement.getClazz());
        element.setproject(owner);
        return element;
    }

    public INoteType createNoteType(Notetype jaxbelement, IElement owner) {
        ObRef ref = new ObRef("NoteType", jaxbelement.getUid());
        INoteType element = (INoteType)this.session.getModel().findByRef(ref);
        if (element == null) {
            element = (INoteType)this.model.createElement("NoteType", jaxbelement.getUid());
        }
        element.setName(jaxbelement.getName());
        if (jaxbelement.getIsHidden() != null) {
            element.setHidden(jaxbelement.getIsHidden().equals("true"));
        }
        if (jaxbelement.getLabel() != null) {
            element.setLabel(this.i18n.internationalize(jaxbelement.getLabel()));
        }
        if (owner instanceof IStereotype) {
            element.setOwnerStereotype((IStereotype)owner);
            if (element.getOwnerReference() != null) {
                element.setOwnerReference(null);
            }
        } else if (owner instanceof IMetaclassReference) {
            element.setOwnerReference((IMetaclassReference)owner);
            if (element.getOwnerStereotype() != null) {
                element.setOwnerStereotype(null);
            }
        }
        return element;
    }

    public IProfile createProfile(Module.Profile jaxbelement, IModule owner) {
        ObRef ref = new ObRef("Profile", jaxbelement.getUid());
        IProfile element = (IProfile)this.session.getModel().findByRef(ref);
        if (element == null) {
            element = (IProfile)this.model.createElement("Profile", jaxbelement.getUid());
        }
        element.setName(jaxbelement.getName());
        element.setOwnerModule(owner);
        return element;
    }

    public IModule createRequired(Module.Dependencies.Required required, IModule module) {
        Collection activeModules = this.session.getMdacRegistry().getLoadedModules();
        for (IMdac activeModule : activeModules) {
            Version moduleVersion = new Version(required.getVersion());
            if (!required.getName().equals(activeModule.getName()) || !activeModule.getVersion().isNewerThan(moduleVersion) && !activeModule.getVersion().equals((Object)moduleVersion)) continue;
            IModule requiredModule = activeModule.getModel();
            module.addDependsOn(requiredModule);
            return requiredModule;
        }
        return null;
    }

    public IStereotype createStereotype(Module.Profile.Stereotype jaxbelement, IProfile owner) {
        ObRef ref = new ObRef("Stereotype", jaxbelement.getUid());
        IStereotype element = (IStereotype)this.session.getModel().findByRef(ref);
        if (element == null) {
            element = (IStereotype)this.model.createElement("Stereotype", jaxbelement.getUid());
        }
        element.setName(jaxbelement.getName());
        element.setOwner(owner);
        for (Object child : jaxbelement.getIconsOrTaggedvaluesOrNotetype()) {
            if (!(child instanceof Module.Profile.Stereotype.Icons)) continue;
            Module.Profile.Stereotype.Icons icons = (Module.Profile.Stereotype.Icons)child;
            for (Object iconsChild : icons.getSmallOrExplorerOrDiagram()) {
                Module.Profile.Stereotype.Icons.Diagram diagram;
                if (iconsChild instanceof Module.Profile.Stereotype.Icons.Explorer) {
                    Module.Profile.Stereotype.Icons.Explorer explorer = (Module.Profile.Stereotype.Icons.Explorer)iconsChild;
                    if (explorer.getPath() == null) continue;
                    element.setIconBrowser(explorer.getPath());
                    continue;
                }
                if (!(iconsChild instanceof Module.Profile.Stereotype.Icons.Diagram) || (diagram = (Module.Profile.Stereotype.Icons.Diagram)iconsChild).getPath() == null) continue;
                element.setIcon(diagram.getPath());
            }
        }
        if (jaxbelement.getIsHidden() != null) {
            element.setHidden(jaxbelement.getIsHidden().equals("true"));
        }
        if (jaxbelement.getMetaclass() != null) {
            element.setBaseClassName(jaxbelement.getMetaclass());
        }
        if (jaxbelement.getOwnerStereotype() != null) {
            this.stereotype_map.put(element, jaxbelement.getOwnerStereotype());
        }
        if (jaxbelement.getLabel() != null) {
            element.setLabel(this.i18n.internationalize(jaxbelement.getLabel()));
        }
        element.setOwner(owner);
        return element;
    }

    public ITagType createTagType(Taggedvalues jaxbelement, IElement owner) {
        ObRef ref = new ObRef("TagType", jaxbelement.getUid());
        ITagType element = (ITagType)this.session.getModel().findByRef(ref);
        if (element == null) {
            element = (ITagType)this.model.createElement("TagType", jaxbelement.getUid());
        }
        element.setName(jaxbelement.getName());
        if (jaxbelement.getIsHidden() != null) {
            element.setHidden(jaxbelement.getIsHidden().equals("true"));
        }
        if (jaxbelement.getLabel() != null) {
            element.setLabel(this.i18n.internationalize(jaxbelement.getLabel()));
        }
        if (jaxbelement.getParameterCard() != null) {
            element.setParamNumber(jaxbelement.getParameterCard());
        }
        if (jaxbelement.getIsSigned() != null) {
            element.setBelongToPrototype(jaxbelement.getIsSigned().equals("true"));
        }
        if (owner instanceof IStereotype) {
            element.setOwnerStereotype((IStereotype)owner);
            if (element.getOwnerReference() != null) {
                element.setOwnerReference(null);
            }
        } else if (owner instanceof IMetaclassReference) {
            element.setOwnerReference((IMetaclassReference)owner);
            if (element.getOwnerStereotype() != null) {
                element.setOwnerStereotype(null);
            }
        }
        return element;
    }

    public void resolveDependencies() {
        for (Map.Entry entry : this.stereotype_map.entrySet()) {
            IStereotype parent = this.findStereotypeByName((String)entry.getValue());
            if (parent == null) continue;
            ((IStereotype)entry.getKey()).setParent(parent);
        }
    }

    private IStereotype findStereotypeByName(String name) {
        List elements = this.session.getModel().findByClass(IStereotype.class);
        for (IElement element : elements) {
            if (!element.getName().equals(name)) continue;
            return (IStereotype)element;
        }
        return null;
    }

    public IExternDocumentType createExternalDocumentType(Externdocumenttype jaxbelement, IElement owner) {
        ObRef ref = new ObRef("ExternDocumentType", jaxbelement.getUid());
        IExternDocumentType element = (IExternDocumentType)this.session.getModel().findByRef(ref);
        if (element == null) {
            element = (IExternDocumentType)this.model.createElement("ExternDocumentType", jaxbelement.getUid());
        }
        element.setName(jaxbelement.getName());
        if (jaxbelement.getIsHidden() != null) {
            element.setHidden(jaxbelement.getIsHidden().equals("true"));
        }
        if (jaxbelement.getLabel() != null) {
            element.setLabel(this.i18n.internationalize(jaxbelement.getLabel()));
        }
        if (owner instanceof IStereotype) {
            element.setOwnerStereotype((IStereotype)owner);
        } else if (owner instanceof IMetaclassReference) {
            element.setOwnerReference((IMetaclassReference)owner);
        }
        return element;
    }
}

