/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mdainfra.mdacs.core.configuration;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.model.extension.IConfigParam;
import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.extension.IProject;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IExternDocumentType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IMetaclassReference;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INoteType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IProfile;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITagType;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.model.CompositionServices;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.CommandRegistry;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.GuiRegister;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.ModelFactory;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.ModuleI18n;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.model.ContextualCommand;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.model.DiagramCommand;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.model.DiagramCommandBox;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.model.DiagramCommandLink;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.model.Externdocumenttype;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.model.Module;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.model.Notetype;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.model.Taggedvalues;
import com.modeliosoft.modelio.mdainfra.mdacs.store.MdacArchiveInfo;
import com.modeliosoft.modelio.mdainfra.plugin.MdaInfra;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.ValidationEventCollector;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class ModuleImporter {
    private final File configuration;
    private final IModelingSession modelingSession;
    private final ModelFactory modelfactory;
    private final GuiRegister mdafactory;
    private static Schema validationSchema = null;

    public ModuleImporter(IModelingSession modelingSession, File configuration) {
        this.modelingSession = modelingSession;
        this.configuration = configuration;
        ModuleI18n i18n = new ModuleI18n(configuration.getParentFile());
        this.modelfactory = new ModelFactory(this.modelingSession, i18n);
        this.mdafactory = new GuiRegister(this.modelingSession, i18n);
    }

    public void loadDynamicModel(IMdac module) throws IOException {
        Module jaxbmodule = ModuleImporter.loadModule((File)this.configuration);
        for (Object child : jaxbmodule.getParameterOrProfileOrGui()) {
            if (!(child instanceof Module.Gui)) continue;
            Module.Gui gui = (Module.Gui)child;
            for (Object guiChild : gui.getPropertyPageOrCommandOrElementCreationCommand()) {
                if (guiChild instanceof Module.Gui.Command) {
                    this.mdafactory.registerCommand((Module.Gui.Command)guiChild, module);
                    continue;
                }
                if (guiChild instanceof ContextualCommand) {
                    this.mdafactory.registerCommand((ContextualCommand)guiChild, module);
                    continue;
                }
                if (guiChild instanceof Module.Gui.CustomizedDiagram) {
                    Module.Gui.CustomizedDiagram diagram = (Module.Gui.CustomizedDiagram)guiChild;
                    ArrayList<CommandRegistry> commands = new ArrayList<CommandRegistry>();
                    for (Object diagramChild : diagram.getPaletteOrStyle()) {
                        if (!(diagramChild instanceof Module.Gui.CustomizedDiagram.Palette)) continue;
                        Module.Gui.CustomizedDiagram.Palette palette = (Module.Gui.CustomizedDiagram.Palette)diagramChild;
                        for (JAXBElement paletteChild : palette.getDiagramCommandOrDiagramCommandBoxOrDiagramCommandLink()) {
                            boolean isValid;
                            DiagramCommand command;
                            if (paletteChild.getValue() instanceof DiagramCommand) {
                                command = (DiagramCommand)paletteChild.getValue();
                                isValid = this.mdafactory.registerCommand(command, module);
                                if (isValid) {
                                    commands.add(new CommandRegistry(command.getName(), command.getGroup()));
                                }
                            } else if (paletteChild.getValue() instanceof DiagramCommandBox) {
                                command = (DiagramCommandBox)paletteChild.getValue();
                                isValid = this.mdafactory.registerCommand((DiagramCommandBox)command, module);
                                if (isValid) {
                                    commands.add(new CommandRegistry(command.getName(), command.getGroup()));
                                }
                            } else if (paletteChild.getValue() instanceof DiagramCommandLink) {
                                command = (DiagramCommandLink)paletteChild.getValue();
                                isValid = this.mdafactory.registerCommand((DiagramCommandLink)command, module);
                                if (isValid) {
                                    commands.add(new CommandRegistry(command.getName(), command.getGroup()));
                                }
                            } else if (paletteChild.getValue() instanceof DiagramCommandBox && (isValid = this.mdafactory.registerAttachedBoxCommand((DiagramCommandBox)(command = (DiagramCommandBox)paletteChild.getValue()), module))) {
                                commands.add(new CommandRegistry(command.getName(), command.getGroup()));
                            }
                            this.mdafactory.registerPalette(diagram, commands, module);
                        }
                    }
                    continue;
                }
                if (!(guiChild instanceof Module.Gui.PropertyPage)) continue;
                this.mdafactory.registerPropertyPage((Module.Gui.PropertyPage)guiChild, module);
            }
        }
    }

    public void loadStaticModel(MdacArchiveInfo moduleInfo) throws IOException {
        Module jaxbmodule = ModuleImporter.loadModule((File)this.configuration);
        ITransactionManager tm = this.modelingSession.getTransactionManager();
        ITransaction tr = null;
        try {
            try {
                tr = tm.createTransaction("LoadModuleMOdel");
                IProject project = this.modelingSession.getModel().getProject();
                IModule module = this.modelfactory.createModule(jaxbmodule, moduleInfo, project);
                this.unlockRecursive((IElement)module);
                List elements = this.loadStaticModel(jaxbmodule, module);
                this.cleanStaticModel(module, elements);
                this.modelfactory.resolveDependencies();
                tm.commit(tr);
                tr = null;
            }
            catch (InvalidTransactionException e) {
                tr = null;
                throw new IOException(e);
            }
        }
        finally {
            if (tr != null) {
                tm.rollback(tr);
            }
        }
    }

    private static Module loadModule(File file) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileInputStream input = new FileInputStream(file);){
            return ModuleImporter.loadModule((InputStream)input);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static Module loadModule(InputStream inputStream) throws IOException {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.model");
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            Schema schema = ModuleImporter.getModuleXmlSchema();
            unmarshaller.setSchema(schema);
            ValidationEventCollector errHandler = new ValidationEventCollector();
            unmarshaller.setEventHandler((ValidationEventHandler)errHandler);
            Module ret = (Module)unmarshaller.unmarshal(inputStream);
            if (errHandler.hasEvents()) {
                StringBuilder msg = new StringBuilder();
                ValidationEvent[] validationEventArray = errHandler.getEvents();
                int n = validationEventArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ValidationEvent ev = validationEventArray[n2];
                    msg.append(ev.getLocator().getLineNumber());
                    msg.append(": ");
                    if (ev.getLinkedException() != null) {
                        msg.append(ev.getLinkedException().getLocalizedMessage());
                    } else {
                        msg.append(ev.getMessage());
                    }
                    msg.append("\n");
                    ++n2;
                }
                throw new IOException(msg.toString());
            }
            return ret;
        }
        catch (JAXBException e) {
            throw new IOException(MdaInfra.I18N.getMessage("L37_saxexception_parsing_xml", new String[]{e.toString()}));
        }
    }

    private void cleanStaticModel(IModule module, List<IElement> createdElement) {
        for (IProfile profile : module.getOwnedProfile()) {
            if (!createdElement.contains(profile)) {
                profile.delete();
                continue;
            }
            for (IStereotype stereotype : profile.getDefinedStereotype()) {
                if (!createdElement.contains(stereotype)) {
                    stereotype.delete();
                    continue;
                }
                for (ITagType tag : stereotype.getDefinedTagType()) {
                    if (createdElement.contains(tag)) continue;
                    tag.delete();
                }
                for (INoteType value : stereotype.getDefinedNoteType()) {
                    if (createdElement.contains(value)) continue;
                    value.delete();
                }
                for (IExternDocumentType external : stereotype.getDefinedExternDocumentType()) {
                    if (createdElement.contains(external)) continue;
                    external.delete();
                }
            }
            for (IMetaclassReference reference : profile.getOwnedReference()) {
                if (!createdElement.contains(reference)) {
                    reference.delete();
                    continue;
                }
                for (ITagType tag : reference.getDefinedTagType()) {
                    if (createdElement.contains(tag)) continue;
                    tag.delete();
                }
                for (INoteType value : reference.getDefinedNoteType()) {
                    if (createdElement.contains(value)) continue;
                    value.delete();
                }
                for (IExternDocumentType external : reference.getDefinedExternDocumentType()) {
                    if (createdElement.contains(external)) continue;
                    external.delete();
                }
            }
        }
        for (IConfigParam parameter : module.getModuleParameter()) {
            if (createdElement.contains(parameter)) continue;
            parameter.delete();
        }
        for (IModule requiredModule : module.getDependsOn()) {
            if (createdElement.contains(requiredModule)) continue;
            module.removeDependsOn(requiredModule);
        }
    }

    private void unlockRecursive(IElement elt) {
        this.modelingSession.getAccessManager().setUserWriteRight(elt, true);
        for (IElement child : CompositionServices.getAllCompositionChildren((IElement)elt)) {
            this.modelingSession.getAccessManager().setUserWriteRight(child, true);
        }
    }

    private List<IElement> loadStaticModel(Module jaxbmodule, IModule module) {
        ArrayList<IElement> elements = new ArrayList<IElement>();
        for (Object child : jaxbmodule.getParameterOrProfileOrGui()) {
            if (child instanceof Module.Profile) {
                Module.Profile jaxbprofile = (Module.Profile)child;
                IProfile profile = this.modelfactory.createProfile(jaxbprofile, module);
                elements.add((IElement)profile);
                for (Object profileChild : jaxbprofile.getStereotypeOrAnonymousStereotype()) {
                    if (profileChild instanceof Module.Profile.Stereotype) {
                        Module.Profile.Stereotype jaxbstereotype = (Module.Profile.Stereotype)profileChild;
                        IStereotype stereotype = this.modelfactory.createStereotype(jaxbstereotype, profile);
                        elements.add((IElement)stereotype);
                        for (Object stereoChild : jaxbstereotype.getIconsOrTaggedvaluesOrNotetype()) {
                            if (stereoChild instanceof Taggedvalues) {
                                elements.add((IElement)this.modelfactory.createTagType((Taggedvalues)stereoChild, (IElement)stereotype));
                                continue;
                            }
                            if (stereoChild instanceof Notetype) {
                                elements.add((IElement)this.modelfactory.createNoteType((Notetype)stereoChild, (IElement)stereotype));
                                continue;
                            }
                            if (!(stereoChild instanceof Externdocumenttype)) continue;
                            elements.add((IElement)this.modelfactory.createExternalDocumentType((Externdocumenttype)stereoChild, (IElement)stereotype));
                        }
                        continue;
                    }
                    if (!(profileChild instanceof Module.Profile.AnonymousStereotype)) continue;
                    Module.Profile.AnonymousStereotype anonymousStereotype = (Module.Profile.AnonymousStereotype)profileChild;
                    IMetaclassReference ref = this.modelfactory.createMetaClassReferance(anonymousStereotype, profile);
                    elements.add((IElement)ref);
                    for (Object stereoChild : anonymousStereotype.getTaggedvaluesOrNotetypeOrExterndocumenttype()) {
                        if (stereoChild instanceof Taggedvalues) {
                            elements.add((IElement)this.modelfactory.createTagType((Taggedvalues)stereoChild, (IElement)ref));
                            continue;
                        }
                        if (stereoChild instanceof Notetype) {
                            elements.add((IElement)this.modelfactory.createNoteType((Notetype)stereoChild, (IElement)ref));
                            continue;
                        }
                        if (!(stereoChild instanceof Externdocumenttype)) continue;
                        elements.add((IElement)this.modelfactory.createExternalDocumentType((Externdocumenttype)stereoChild, (IElement)ref));
                    }
                }
                continue;
            }
            if (child instanceof Module.Parameter) {
                elements.add((IElement)this.modelfactory.createConfigParam((Module.Parameter)child, module));
                continue;
            }
            if (!(child instanceof Module.Dependencies)) continue;
            for (Object childDep : ((Module.Dependencies)child).getRequiredOrOptionalOrRamc()) {
                Module.Dependencies.Required required;
                IModule requiredModule;
                if (!(childDep instanceof Module.Dependencies.Required) || (requiredModule = this.modelfactory.createRequired(required = (Module.Dependencies.Required)childDep, module)) == null) continue;
                elements.add((IElement)requiredModule);
            }
        }
        return elements;
    }

    private static Schema getModuleXmlSchema() throws IOException {
        if (validationSchema != null) {
            return validationSchema;
        }
        Bundle bundle = Platform.getBundle((String)"org.modelio.mda.infra");
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path("/res/module_conf.xsd"), null);
        if (url == null) {
            return null;
        }
        try {
            validationSchema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(url);
            return validationSchema;
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }
}

