/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.generic;

import com.modeliosoft.modelio.api.diagram.IDiagramGraphic;
import com.modeliosoft.modelio.api.diagram.IDiagramHandle;
import com.modeliosoft.modelio.api.diagram.IDiagramNode;
import com.modeliosoft.modelio.api.diagram.dg.IDiagramDG;
import com.modeliosoft.modelio.api.diagram.tools.DefaultBoxCommand;
import com.modeliosoft.modelio.api.model.ITransaction;
import com.modeliosoft.modelio.api.model.IUmlModel;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.utils.exceptions.InvalidModelManipulationException;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.factory.BasicElementInitializer;
import com.modeliosoft.modelio.core.model.CompositionExpert;
import com.modeliosoft.modelio.core.model.Meta;
import com.modeliosoft.modelio.core.model.MetaModelExpert;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.model.Handler;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.model.Scope;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ImageDescriptor;

public class GenericBoxCommand
extends DefaultBoxCommand {
    private List<Scope> scopes;
    private Handler handler;

    public GenericBoxCommand(String name, ImageDescriptor bitmap, String tooltip, Handler handler, List<Scope> scopes) {
        super(name, bitmap, tooltip);
        this.handler = handler;
        this.scopes = scopes;
    }

    public boolean acceptElement(IDiagramHandle diagramHandle, IDiagramGraphic targetNode) {
        IModelElement owner = null;
        owner = targetNode instanceof IDiagramDG ? diagramHandle.getDiagram().getOrigin() : (IModelElement)targetNode.getElement();
        for (Scope aScope : this.scopes) {
            boolean result = true;
            String metaclass = aScope.getMetaclass();
            String stereotype = aScope.getStereotype();
            Class metaclassClass = MetaModelExpert.getMetaclass((String)metaclass);
            if (metaclass != null) {
                boolean bl = result = result && metaclassClass.isAssignableFrom(owner.getClass());
            }
            if (stereotype != null) {
                boolean bl = result = result && owner.isStereotyped(stereotype);
            }
            if (!result) continue;
            return true;
        }
        return false;
    }

    public void actionPerformed(IDiagramHandle diagramHandle, IDiagramGraphic graphic, Rectangle rect) {
        block10: {
            boolean commit = false;
            ITransaction tr = Modelio.getInstance().getModelingSession().createTransaction("GenericBoxCommand");
            try {
                IModelElement parent = null;
                parent = graphic instanceof IDiagramDG ? diagramHandle.getDiagram().getOrigin() : (IModelElement)graphic.getElement();
                if (this.handler != null && this.handler.getMetaclass() != null) {
                    Meta meta = new Meta((IElement)parent);
                    IUmlModel modelFactory = Modelio.getInstance().getModelingSession().getModel();
                    IElement newElement = modelFactory.createElement(this.handler.getMetaclass());
                    String relation = this.handler.getRelation();
                    if (relation == null) {
                        relation = "";
                    }
                    try {
                        meta.appendToDependency(relation, newElement);
                    }
                    catch (InvalidModelManipulationException e) {
                        String compositionDep = CompositionExpert.getDefaultCompositionDep((IElement)parent, (IElement)newElement);
                        if (compositionDep != null && !compositionDep.equals("")) {
                            meta.appendToDependency(compositionDep, newElement);
                        }
                        modelFactory.deleteElement(newElement);
                        return;
                    }
                    if (newElement instanceof IModelElement) {
                        if (this.handler.getStereotype() != null) {
                            ((IModelElement)newElement).addStereotype(this.handler.getStereotype());
                        }
                        ((IModelElement)newElement).setName(this.getLabel());
                    }
                    BasicElementInitializer initializer = new BasicElementInitializer(O.getDefault().getModelingSession());
                    initializer.initialize(newElement);
                    List graph = diagramHandle.unmask(newElement, rect.x, rect.y);
                    if (graph.size() > 0) {
                        ((IDiagramNode)graph.get(0)).setBounds(rect);
                    }
                    diagramHandle.save();
                }
                commit = true;
                Modelio.getInstance().getModelingSession().commit(tr);
            }
            catch (Exception e) {
                if (commit) break block10;
                Modelio.getInstance().getModelingSession().rollback(tr);
            }
        }
    }
}

