/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.generic;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.mdac.commands.DefaultMdacContextualCommand;
import com.modeliosoft.modelio.api.model.ITransaction;
import com.modeliosoft.modelio.api.model.IUmlModel;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.api.utils.exceptions.InvalidModelManipulationException;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.factory.BasicElementInitializer;
import com.modeliosoft.modelio.core.model.CompositionExpert;
import com.modeliosoft.modelio.core.model.Meta;
import com.modeliosoft.modelio.core.model.MetaModelExpert;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.model.Handler;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.model.Scope;
import java.util.List;

public class GenericContextualCommand
extends DefaultMdacContextualCommand {
    private String name;
    private List<Scope> scopes;
    private Handler handler;

    public GenericContextualCommand(String name, Handler handler, List<Scope> scopes) {
        this.name = name;
        this.handler = handler;
        this.scopes = scopes;
    }

    public void actionPerformed(ObList<IElement> selectedElements, IMdac mdac) {
        block9: {
            boolean commit = false;
            ITransaction tr = Modelio.getInstance().getModelingSession().createTransaction("GenericBoxCommand");
            try {
                IModelElement parent = (IModelElement)selectedElements.get(0);
                if (this.handler != null && this.handler.getMetaclass() != null) {
                    IUmlModel modelFactory = Modelio.getInstance().getModelingSession().getModel();
                    IElement newElement = modelFactory.createElement(this.handler.getMetaclass());
                    Meta meta = new Meta((IElement)parent);
                    String relation = this.handler.getRelation();
                    if (relation == null) {
                        relation = "";
                    }
                    try {
                        meta.appendToDependency(relation, newElement);
                    }
                    catch (InvalidModelManipulationException e) {
                        String compositionDep = CompositionExpert.getDefaultCompositionDep((IElement)parent, (IElement)newElement);
                        if (compositionDep != null && !compositionDep.equals("")) {
                            meta.appendToDependency(compositionDep, newElement);
                        }
                        modelFactory.deleteElement(newElement);
                        return;
                    }
                    BasicElementInitializer initializer = new BasicElementInitializer(O.getDefault().getModelingSession());
                    initializer.initialize(newElement);
                    if (newElement instanceof IModelElement) {
                        if (this.handler.getStereotype() != null) {
                            ((IModelElement)newElement).addStereotype(this.handler.getStereotype());
                        }
                        ((IModelElement)newElement).setName(this.name);
                    }
                }
                commit = true;
                Modelio.getInstance().getModelingSession().commit(tr);
            }
            catch (Exception e) {
                if (commit) break block9;
                Modelio.getInstance().getModelingSession().rollback(tr);
            }
        }
    }

    public boolean accept(ObList<IElement> selectedElements, IMdac mdac) {
        if (selectedElements.size() > 0 && selectedElements.get(0) instanceof IModelElement) {
            IModelElement owner = (IModelElement)selectedElements.get(0);
            for (Scope aScope : this.scopes) {
                boolean result = true;
                String metaclass = aScope.getMetaclass();
                String stereotype = aScope.getStereotype();
                Class metaclassClass = MetaModelExpert.getMetaclass((String)metaclass);
                if (metaclass != null) {
                    boolean bl = result = result && metaclassClass.isAssignableFrom(owner.getClass());
                }
                if (stereotype != null) {
                    boolean bl = result = result && owner.isStereotyped(stereotype);
                }
                if (!result) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isActiveFor(ObList<IElement> selectedElements, IMdac mdac) {
        return true;
    }
}

