/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.generic;

import com.modeliosoft.modelio.api.diagram.IDiagramCustomizer;
import com.modeliosoft.modelio.api.diagram.IDiagramService;
import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.CommandRegistry;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;

public class GenericDiagramCustomizer
implements IDiagramCustomizer {
    private boolean keepPalette;
    private List<CommandRegistry> commands;
    private IMdac module;

    public GenericDiagramCustomizer(List<CommandRegistry> commands, boolean keepPalette, IMdac module) {
        this.keepPalette = keepPalette;
        this.commands = commands;
        this.module = module;
    }

    public boolean keepBasePalette() {
        return this.keepPalette;
    }

    public void fillPalette(PaletteRoot paletteRoot) {
        IDiagramService toolRegistry = Modelio.getInstance().getDiagramService();
        if (!this.keepPalette) {
            PaletteDrawer commonGroup = new PaletteDrawer("Default", null);
            commonGroup.setInitialState(0);
            commonGroup.add((PaletteEntry)new SelectionToolEntry());
            commonGroup.add((PaletteEntry)new MarqueeToolEntry());
            paletteRoot.add((PaletteEntry)commonGroup);
        }
        HashMap<String, PaletteDrawer> paletteMap = new HashMap<String, PaletteDrawer>();
        for (CommandRegistry commande : this.commands) {
            PaletteDrawer palette = (PaletteDrawer)paletteMap.get(this.internationalize(commande.group, this.module));
            if (palette == null) {
                palette = new PaletteDrawer(commande.group, null);
                palette.setInitialState(0);
                paletteRoot.add((PaletteEntry)palette);
                paletteMap.put(this.internationalize(commande.group, this.module), palette);
            }
            palette.add((PaletteEntry)toolRegistry.getRegisteredTool(commande.commandId));
        }
    }

    private String internationalize(String value, IMdac module) {
        block4: {
            if (value != null) break block4;
            return "";
        }
        try {
            if (value.startsWith("%")) {
                return this.getManifestBundle(module).getString(value.substring(1));
            }
        }
        catch (MissingResourceException e) {
            Modelio.err.println("[" + module.getName() + "] Missing Resource :" + value);
        }
        return value;
    }

    private ResourceBundle getManifestBundle(IMdac module) throws MissingResourceException {
        File manifestDir = module.getConfiguration().getModuleResourcesPath();
        try {
            URLClassLoader cl = new URLClassLoader(new URL[]{manifestDir.toURI().toURL()});
            return ResourceBundle.getBundle("module", Locale.getDefault(), cl);
        }
        catch (MalformedURLException e) {
            throw new MissingResourceException(e.getLocalizedMessage(), "module", "");
        }
        catch (MissingResourceException e) {
            MissingResourceException e2 = new MissingResourceException(String.valueOf(e.getLocalizedMessage()) + " in '" + manifestDir.getPath() + "'", e.getClassName(), e.getKey());
            e2.initCause(e);
            throw e2;
        }
    }
}

