/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.generic;

import com.modeliosoft.modelio.api.diagram.IDiagramGraphic;
import com.modeliosoft.modelio.api.diagram.IDiagramHandle;
import com.modeliosoft.modelio.api.diagram.IDiagramLink;
import com.modeliosoft.modelio.api.diagram.ILinkPath;
import com.modeliosoft.modelio.api.diagram.dg.IDiagramDG;
import com.modeliosoft.modelio.api.diagram.tools.DefaultLinkCommand;
import com.modeliosoft.modelio.api.model.ITransaction;
import com.modeliosoft.modelio.api.model.IUmlModel;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociation;
import com.modeliosoft.modelio.api.model.uml.statik.IBindableInstance;
import com.modeliosoft.modelio.api.model.uml.statik.IClassifier;
import com.modeliosoft.modelio.api.model.uml.statik.IInstance;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.factory.BasicElementInitializer;
import com.modeliosoft.modelio.core.model.LinkServices;
import com.modeliosoft.modelio.core.model.MetaModelExpert;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.model.Handler;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.model.Scope;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;

public class GenericLinkCommand
extends DefaultLinkCommand {
    private List<Scope> sources;
    private List<Scope> targets;
    private Handler handler;

    public GenericLinkCommand(String name, ImageDescriptor bitmap, String tooltip, Handler handler, List<Scope> sources, List<Scope> targets) {
        super(name, bitmap, tooltip);
        this.handler = handler;
        this.sources = sources;
        this.targets = targets;
    }

    public boolean acceptFirstElement(IDiagramHandle diagramHandle, IDiagramGraphic targetNode) {
        IModelElement owner = null;
        owner = targetNode instanceof IDiagramDG ? diagramHandle.getDiagram().getOrigin() : (IModelElement)targetNode.getElement();
        for (Scope aScope : this.sources) {
            boolean result = true;
            String metaclass = aScope.getMetaclass();
            String stereotype = aScope.getStereotype();
            Class metaclassClass = MetaModelExpert.getMetaclass((String)metaclass);
            if (metaclass != null) {
                boolean bl = result = result && metaclassClass.isAssignableFrom(owner.getClass());
            }
            if (stereotype != null) {
                boolean bl = result = result && owner.isStereotyped(stereotype);
            }
            if (!result) continue;
            return true;
        }
        return false;
    }

    public boolean acceptSecondElement(IDiagramHandle diagramHandle, IDiagramGraphic originNode, IDiagramGraphic targetNode) {
        IModelElement owner = null;
        owner = targetNode instanceof IDiagramDG ? diagramHandle.getDiagram().getOrigin() : (IModelElement)targetNode.getElement();
        for (Scope aScope : this.targets) {
            boolean result = true;
            String metaclass = aScope.getMetaclass();
            String stereotype = aScope.getStereotype();
            Class metaclassClass = MetaModelExpert.getMetaclass((String)metaclass);
            if (metaclass != null) {
                boolean bl = result = result && metaclassClass.isAssignableFrom(owner.getClass());
            }
            if (stereotype != null) {
                boolean bl = result = result && owner.isStereotyped(stereotype);
            }
            if (!result) continue;
            return true;
        }
        return false;
    }

    public void actionPerformed(IDiagramHandle diagramHandle, IDiagramGraphic originNode, IDiagramGraphic targetNode, IDiagramLink.LinkRouterKind routerType, ILinkPath path) {
        block11: {
            boolean commit = false;
            ITransaction tr = Modelio.getInstance().getModelingSession().createTransaction("TogafNetworkLink");
            try {
                IModelElement source = (IModelElement)originNode.getElement();
                IModelElement target = (IModelElement)targetNode.getElement();
                if (this.handler != null && this.handler.getMetaclass() != null) {
                    IAssociation newElement = null;
                    IUmlModel modelFactory = Modelio.getInstance().getModelingSession().getModel();
                    if (this.handler.getMetaclass().equals("Association")) {
                        newElement = modelFactory.createAssociation((IClassifier)source, (IClassifier)target, this.getLabel());
                    } else if (this.handler.getMetaclass().equals("Connector")) {
                        newElement = modelFactory.createConnector((IBindableInstance)source, (IBindableInstance)target, this.getLabel());
                    } else if (this.handler.getMetaclass().equals("Link")) {
                        newElement = modelFactory.createLink((IInstance)source, (IInstance)target, this.getLabel());
                    } else {
                        newElement = modelFactory.createElement(this.handler.getMetaclass());
                        LinkServices.changeSource((IElement)newElement, null, (IElement)source);
                        LinkServices.changeTarget((IElement)newElement, null, (IElement)target);
                    }
                    if (newElement instanceof IModelElement) {
                        if (this.handler.getStereotype() != null) {
                            ((IModelElement)newElement).addStereotype(this.handler.getStereotype());
                        }
                        ((IModelElement)newElement).setName(this.getLabel());
                    }
                    BasicElementInitializer initializer = new BasicElementInitializer(O.getDefault().getModelingSession());
                    initializer.initialize((IElement)newElement);
                    List graph = diagramHandle.unmask((IElement)newElement, 0, 0);
                    IDiagramLink link = (IDiagramLink)graph.get(0);
                    link.setRouterKind(routerType);
                    link.setPath(path);
                    diagramHandle.save();
                }
                commit = true;
                Modelio.getInstance().getModelingSession().commit(tr);
            }
            catch (Exception e) {
                if (commit) break block11;
                Modelio.getInstance().getModelingSession().rollback(tr);
            }
        }
    }
}

