/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mdainfra.mdacs.deployment;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.mdac.MdacException;
import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.extension.IProject;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IProfile;
import com.modeliosoft.modelio.api.utils.exceptions.InvalidModelManipulationException;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.mdainfra.mdacs.core.MdacManager;
import com.modeliosoft.modelio.mdainfra.plugin.MdaInfra;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.swt.widgets.Display;

public class LocalModuleCreator {
    private static final String LOCAL_MODULE_CLASS_NAME = "<FAKE>";
    private static final String LOCAL_PROFILE_NAME = "LocalProfile";
    private static final String LOCAL_MODULE_NAME = "LocalModule";
    private IModelingSession sess;
    private MdacManager mdacManager;
    private File localModuleDirectory;
    private File projectDirectory;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createLocalModule() {
        IProject project = this.sess.getModel().getProject();
        ITransactionManager transactionManager = this.sess.getTransactionManager();
        ITransaction transaction = null;
        try {
            try {
                transaction = transactionManager.createTransaction("Create LocalModule");
                IModelFactory factory = this.sess.getModelFactory();
                IModule module = factory.createModule();
                module.setName(LOCAL_MODULE_NAME);
                module.setjavaClassName(LOCAL_MODULE_CLASS_NAME);
                project.addInstalled(module);
                this.mdacManager.activate(module);
                IProfile profile = factory.createProfile();
                profile.setName(LOCAL_PROFILE_NAME);
                module.addOwnedProfile(profile);
                this.writeLocalModuleProperties();
                try {
                    IMdac localModuleMdac = this.mdacManager.loadMdac(module, new ArrayList());
                    this.mdacManager.startMdac(localModuleMdac);
                }
                catch (MdacException e) {
                    MdaInfra.LOG.error((Throwable)e);
                    String title = MdaInfra.I18N.getMessage("DeployMdacHandler.FailedTitle", new String[]{module.getName()});
                    this.displayError(title, e.getLocalizedMessage());
                }
                transactionManager.commit(transaction);
                transaction = null;
                return;
            }
            catch (InvalidModelManipulationException e) {
                MdaInfra.LOG.error((Throwable)e);
                transactionManager.rollback(transaction);
                transaction = null;
                String title = MdaInfra.I18N.getMessage("DeployMdacHandler.FailedTitle", new String[]{LOCAL_MODULE_NAME});
                this.displayError(title, e.getLocalizedMessage());
                if (transaction == null) return;
                transactionManager.rollback(transaction);
                return;
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                if (transaction == null) return;
                transactionManager.rollback(transaction);
                return;
            }
        }
        finally {
            if (transaction != null) {
                transactionManager.rollback(transaction);
            }
        }
    }

    private void writeLocalModuleProperties() {
        BufferedWriter out;
        File manifestDirectory = this.localModuleDirectory;
        File manifestCommonFile = new File(manifestDirectory, "module.properties");
        File manifestFrFile = new File(manifestDirectory, "module_fr.properties");
        manifestDirectory.mkdirs();
        Date date = new Date();
        try {
            out = new BufferedWriter(new FileWriter(manifestCommonFile));
            out.write("#Generated by Modelio\n");
            out.write("#");
            out.write(DateFormat.getInstance().format(date));
            out.write("\n");
            out.write("MdacLabel=Local module\n");
            out.write("MdacDescription=The local module constains all the UML extensions defined by the user of the project.\n");
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            out = new BufferedWriter(new FileWriter(manifestFrFile));
            out.write("#Generated by Modelio\n");
            out.write("#");
            out.write(DateFormat.getInstance().format(date));
            out.write("\n");
            out.write("MdacLabel=Module local\n");
            out.write("MdacDescription=Le module local contient les extensions UML d\u00e9finies par l'utilisateur du projet.\n");
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public LocalModuleCreator(IModelingSession sess) {
        this.sess = sess;
        this.mdacManager = new MdacManager(sess);
        this.projectDirectory = sess.getProjectSpacePath();
        this.localModuleDirectory = new File(this.projectDirectory, "mda/LocalModule");
    }

    public void execute() {
        IModule localModule = this.mdacManager.getModule(LOCAL_MODULE_NAME);
        if (localModule == null) {
            this.createLocalModule();
        }
    }

    private void displayError(String title, String msg) {
        Display.getDefault().syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }
}

