/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mdainfra.mdacs.deployment;

import com.modeliosoft.modelio.api.mdac.MdacException;
import com.modeliosoft.modelio.api.modelio.Version;
import com.modeliosoft.modelio.mdainfra.mdacs.core.RamcDescriptor;
import com.modeliosoft.modelio.mdainfra.mdacs.deployment.ArchivedRamc;
import com.modeliosoft.modelio.mdainfra.mdacs.deployment.MCArchiveRepository;
import com.modeliosoft.modelio.mdainfra.plugin.MdaInfra;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MCArchiveRepository {
    private List<ArchivedRamc> archivedRamcs = new ArrayList();

    public static List<ArchivedRamc> orderRamcsForDeployment(List<ArchivedRamc> archivedRamcs) {
        ArrayList<ArchivedRamc> orderedList = new ArrayList<ArchivedRamc>(archivedRamcs);
        Collections.sort(orderedList, new DeploymentComparator(null));
        return orderedList;
    }

    public MCArchiveRepository(List<File> filesList) throws MdacException {
        ArchivedRamc ramc = null;
        for (File file : filesList) {
            ramc = new ArchivedRamc();
            ramc.path = file;
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (ZipFile f = new ZipFile(file);){
                    ZipEntry e = f.getEntry("metadatas.xml");
                    if (e == null) {
                        throw new MdacException(MdaInfra.I18N.getMessage("MetadataNotFound", new String[]{file.getPath()}));
                    }
                    Throwable throwable2 = null;
                    Object var10_14 = null;
                    try (InputStream s = f.getInputStream(e);){
                        this.initMetadata(ramc, s);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                    this.archivedRamcs.add(ramc);
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                MdacException e2 = new MdacException(MdaInfra.I18N.getMessage("L13_error_extracting_archive", new String[]{file.getPath(), e.getLocalizedMessage()}));
                e2.initCause((Throwable)e);
                throw e2;
            }
        }
    }

    private void initMetadata(ArchivedRamc archivedRamc, InputStream s) throws MdacException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setXIncludeAware(false);
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document xmlDoc = db.parse(s);
            Element docElement = xmlDoc.getDocumentElement();
            archivedRamc.name = docElement.getAttribute("name");
            archivedRamc.version = new Version(Integer.parseInt(docElement.getAttribute("version")), Integer.parseInt(docElement.getAttribute("release")), Integer.parseInt(docElement.getAttribute("clevel")), 0);
            NodeList childrenNodes = docElement.getChildNodes();
            int i = 0;
            while (i < childrenNodes.getLength()) {
                Node n = childrenNodes.item(i);
                if (n.getNodeName().equals("description")) {
                    archivedRamc.description = n.getTextContent().trim();
                } else if (n.getNodeName().equals("dependencies")) {
                    Element el = (Element)n;
                    this.initRamcDependencies(el, archivedRamc);
                }
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            MdacException e2 = new MdacException(MdaInfra.I18N.getMessage("L36_cannot_init_xml_parser", new String[]{e.getMessage()}));
            e2.initCause((Throwable)e);
            throw e2;
        }
        catch (SAXException e) {
            MdacException e2 = new MdacException(MdaInfra.I18N.getMessage("L37_saxexception_parsing_xml", new String[]{e.getMessage()}));
            e2.initCause((Throwable)e);
            throw e2;
        }
        catch (IOException e) {
            MdacException e2 = new MdacException(MdaInfra.I18N.getMessage("L38_ioexception_parsing_manifest", new String[]{e.getMessage()}));
            e2.initCause((Throwable)e);
            throw e2;
        }
    }

    private void initRamcDependencies(Element el, ArchivedRamc archivedRamc) {
        NodeList dependencyNodes = el.getElementsByTagName("dependency");
        int idepnode = 0;
        while (idepnode < dependencyNodes.getLength()) {
            Element depNode = (Element)dependencyNodes.item(idepnode);
            String name = depNode.getAttribute("name");
            Version version = new Version(depNode.getAttribute("version"));
            String id = depNode.getAttribute("id");
            RamcDescriptor depRamc = new RamcDescriptor(name, version.toString());
            archivedRamc.requiredRamcs.add(depRamc);
            ++idepnode;
        }
    }

    public List<ArchivedRamc> getArchivedRamcs() {
        return this.archivedRamcs;
    }
}

