/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mdainfra.mdacs.deployment;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.mdac.IMdacDescriptor;
import com.modeliosoft.modelio.api.mdac.MdacException;
import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.modelio.Version;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.jni.IAccessManager;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.mdacs.IMdacRegistry;
import com.modeliosoft.modelio.core.model.CompositionServices;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.core.transaction.NoTransactionOpenException;
import com.modeliosoft.modelio.core.transaction.NotCurrentTransactionException;
import com.modeliosoft.modelio.mdainfra.mdacs.core.IMdacManager;
import com.modeliosoft.modelio.mdainfra.mdacs.core.configuration.ModuleImporter;
import com.modeliosoft.modelio.mdainfra.mdacs.internal.MdacConfiguration;
import com.modeliosoft.modelio.mdainfra.mdacs.store.IMdacArchive;
import com.modeliosoft.modelio.mdainfra.mdacs.store.JarArchive;
import com.modeliosoft.modelio.mdainfra.mdacs.store.Manifest;
import com.modeliosoft.modelio.mdainfra.mdacs.store.MdacArchiveInfo;
import com.modeliosoft.modelio.mdainfra.plugin.MdaInfra;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class MdacDeployer {
    private final IModelingSession modelingSession;
    private final IMdacManager moduleManager;
    private final File projectSpacePath;
    private boolean startModuleAtInstall = true;
    private IMdacRegistry registry;

    public MdacDeployer(IModelingSession aModelingSession, IMdacManager moduleManager) {
        this.modelingSession = aModelingSession;
        this.registry = this.modelingSession.getMdacRegistry();
        this.projectSpacePath = aModelingSession.getProjectSpacePath();
        this.moduleManager = moduleManager;
    }

    @Deprecated
    public Collection<IMdac> deployMdacs(File archiveFile) throws MdacException {
        ArrayList<File> archiveFiles = new ArrayList<File>();
        archiveFiles.add(archiveFile);
        return this.deployMdacs(archiveFiles, null);
    }

    public void setStartModuleAtInstall(boolean startModuleAtInstall) {
        this.startModuleAtInstall = startModuleAtInstall;
    }

    private void deleteModuleDirectoryBackup(MdacArchiveInfo archivedModule, File plugsPath) {
        File oldDir = new File(plugsPath, String.valueOf(archivedModule.name) + ".old");
        if (oldDir.isDirectory()) {
            this.delete(oldDir);
        }
    }

    private void copyFile(File srcFile, File dstFile) throws IOException {
        Files.copy(srcFile.toPath(), dstFile.toPath(), new CopyOption[0]);
    }

    private void delete(File file) {
        if (file.isFile()) {
            file.delete();
        } else if (file.isDirectory()) {
            File[] files;
            File[] fileArray = files = file.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File subFile = fileArray[n2];
                this.delete(subFile);
                ++n2;
            }
            file.delete();
        }
    }

    private IMdac deployModule(MdacArchiveInfo archivedModule, List<MdacArchiveInfo> manifestedModules) throws MdacException {
        if (archivedModule.getVersion().getMetamodelVersion() < 8008) {
            throw new MdacException(MdaInfra.I18N.getMessage("module_metamodel_too_old", new String[]{archivedModule.getName(), archivedModule.getVersion().toString()}));
        }
        IModule moduleHandle = this.moduleManager.getModule(archivedModule.getName());
        if (moduleHandle != null) {
            return this.moduleUpdateInstall(archivedModule, moduleHandle, manifestedModules);
        }
        return this.moduleFirstInstall(archivedModule, manifestedModules);
    }

    private IMdacArchive getArchive(File archiveFile) {
        return new JarArchive(archiveFile);
    }

    private List<String> getRelativeClasspathFromInstallDir(MdacArchiveInfo archivedModule, File deploymentPath) {
        ArrayList<String> classpathFiles = new ArrayList<String>();
        for (String path : archivedModule.classPath) {
            String relativeFilePath = new File(archivedModule.name, path).getPath();
            File realFile = new File(deploymentPath, relativeFilePath);
            if (!realFile.exists()) continue;
            classpathFiles.add(relativeFilePath);
        }
        return classpathFiles;
    }

    private File getMdaDirPath() {
        return new File(this.projectSpacePath, "mda");
    }

    private File getRuntimeJarFile(File mdaRuntimeDir, String relativFilePath) {
        File runTimeJarFile = new File(mdaRuntimeDir, relativFilePath);
        String jarName = relativFilePath.substring(0, relativFilePath.lastIndexOf(".jar"));
        int cpt = 0;
        while (runTimeJarFile.exists()) {
            runTimeJarFile = new File(mdaRuntimeDir, String.valueOf(jarName) + "_" + cpt + ".jar");
            ++cpt;
        }
        return runTimeJarFile;
    }

    private void importStaticModelFromModuleFile(MdacArchiveInfo module) throws IOException {
        File repositoryPath = this.moduleManager.getMdacPath(module.name);
        File propertyFile = new File(String.valueOf(repositoryPath.getAbsolutePath()) + "/module.xml");
        if (!propertyFile.exists()) {
            throw new IOException(MdaInfra.I18N.getMessage("L12_no_manifest_xml_file", new String[]{module.name}));
        }
        ModuleImporter importer = new ModuleImporter(this.modelingSession, propertyFile);
        importer.loadStaticModel(module);
    }

    private void setModuleJavaClass(String javaClassName, IModule moduleHandle) {
        if (javaClassName != null && !javaClassName.isEmpty()) {
            ITransaction t = this.modelingSession.getTransactionManager().createTransaction(MdaInfra.I18N.getString("L21_set_mda_class_name"));
            try {
                try {
                    this.modelingSession.getAccessManager().setUser(0);
                    moduleHandle.setjavaClassName(javaClassName);
                    this.modelingSession.getTransactionManager().commit(t);
                    t = null;
                }
                catch (InvalidTransactionException e) {
                    t = null;
                    throw e;
                }
            }
            finally {
                if (t != null) {
                    this.modelingSession.getTransactionManager().rollback(t);
                }
                this.modelingSession.getAccessManager().setUser(1);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IMdac moduleFirstInstall(MdacArchiveInfo archivedModule, List<MdacArchiveInfo> manifestedModules) throws MdacException {
        ITransaction transaction;
        ITransactionManager transactionManager;
        IMdac deployedModule;
        block18: {
            IMdac iMdac;
            block19: {
                this.verifyImpactedModules(archivedModule);
                this.verifyNeededModules(archivedModule, manifestedModules);
                deployedModule = null;
                File mdaDir = this.getMdaDirPath();
                transactionManager = this.modelingSession.getTransactionManager();
                transaction = transactionManager.createTransaction("Deploy " + archivedModule.name);
                try {
                    archivedModule.getArchive().extract(mdaDir);
                    this.importStaticModelFromModuleFile(archivedModule);
                    IModule newModuleModel = this.moduleManager.getModule(archivedModule.getName());
                    this.moduleManager.activate(newModuleModel);
                    this.verifyModuleDependenciesConsistency(archivedModule, newModuleModel);
                    this.setModelAsRamc(newModuleModel);
                    boolean result = true;
                    File mdaRuntimeDir = new File(mdaDir, ".runtime");
                    List mdaClasspath = this.getRelativeClasspathFromInstallDir(archivedModule, mdaDir);
                    List classPath = null;
                    if (mdaClasspath != null) {
                        classPath = this.updateRuntimeClasspath(mdaClasspath, mdaDir, mdaRuntimeDir);
                    } else {
                        result = false;
                    }
                    if (result) {
                        result = this.moduleManager.installModule(archivedModule, classPath);
                    }
                    if (result) {
                        this.setModuleJavaClass(archivedModule.mainClass, newModuleModel);
                        deployedModule = this.moduleManager.loadMdac(newModuleModel, classPath);
                        result = this.moduleManager.selectMdac(deployedModule);
                    }
                    if (result && deployedModule != null && this.startModuleAtInstall && O.getDefault().getModelingSession() != null) {
                        result = this.moduleManager.startMdac(deployedModule);
                    }
                    List weakImpactedIModules = this.moduleManager.getWeakImpactedModules(newModuleModel);
                    Iterator iterator = weakImpactedIModules.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            if (!result) break block18;
                            transactionManager.commit(transaction);
                            transaction = null;
                            iMdac = deployedModule;
                            if (transaction == null) break block19;
                            break;
                        }
                        IModule weakImpactedModule = (IModule)iterator.next();
                        IMdac weakImpactedMdac = this.registry.getLoadedMdac(weakImpactedModule);
                        if (weakImpactedMdac == null || !this.moduleManager.isActivated(weakImpactedModule)) continue;
                        this.moduleManager.restartModule(weakImpactedMdac);
                    }
                }
                catch (IOException e) {
                    try {
                        MdacException e2 = new MdacException(MdaInfra.I18N.getMessage("L1", new String[]{archivedModule.name, e.getMessage()}));
                        e2.initCause((Throwable)e);
                        throw e2;
                        catch (InvalidTransactionException e3) {
                            transaction = null;
                            MdaInfra.LOG.error("Aborting '" + archivedModule.getName() + "' module deployment because of: ");
                            MdaInfra.LOG.error((Throwable)e3);
                            e2 = new MdacException(e3.getMessage());
                            e2.initCause((Throwable)e3);
                            throw e2;
                        }
                        catch (MdacException | Error | RuntimeException e4) {
                            MdaInfra.LOG.error("Aborting '" + archivedModule.getName() + "' module deployment because of: ");
                            MdaInfra.LOG.error(e4);
                            throw e4;
                        }
                    }
                    catch (Throwable throwable) {
                        if (transaction != null) {
                            transactionManager.rollback(transaction);
                            this.removeModulesDirectory(archivedModule, this.getMdaDirPath());
                            if (deployedModule != null) {
                                this.moduleManager.unloadMdac(deployedModule);
                            }
                        }
                        throw throwable;
                    }
                }
                transactionManager.rollback(transaction);
                this.removeModulesDirectory(archivedModule, this.getMdaDirPath());
                if (deployedModule != null) {
                    this.moduleManager.unloadMdac(deployedModule);
                }
            }
            return iMdac;
        }
        if (transaction != null) {
            transactionManager.rollback(transaction);
            this.removeModulesDirectory(archivedModule, this.getMdaDirPath());
            if (deployedModule != null) {
                this.moduleManager.unloadMdac(deployedModule);
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IMdac moduleUpdateInstall(MdacArchiveInfo archivedModule, IModule oldModule, List<MdacArchiveInfo> manifestedModules) throws MdacException {
        this.verifyImpactedModules(archivedModule);
        this.verifyNeededModules(archivedModule, manifestedModules);
        mdaDir = this.getMdaDirPath();
        oldMdac = this.registry.getLoadedMdac(oldModule);
        modulesToReload = Collections.emptySet();
        newMdac = null;
        wasStarted = oldMdac != null && oldMdac.getState() == IMdac.MdacState.Started;
        transactionManager = this.modelingSession.getTransactionManager();
        transaction = transactionManager.createTransaction("Update " + archivedModule.name);
        try {
            this.saveModuleDirectory(archivedModule, mdaDir);
            archivedModule.getArchive().extract(mdaDir);
            oldVersion = new Version(oldModule.getVersion());
            if (oldMdac == null) {
                oldParameters = new MdacConfiguration(oldModule, null, null, null, Collections.emptyList()).getParameters();
            } else {
                oldParameters = oldMdac.getConfiguration().getParameters();
                if (wasStarted) {
                    modulesToReload = this.moduleManager.stopMdac(oldMdac);
                    modulesToReload.remove(oldMdac);
                }
                this.moduleManager.unloadMdac(oldMdac);
            }
            this.importStaticModelFromModuleFile(archivedModule);
            newModuleModel = this.moduleManager.getModule(archivedModule.getName());
            this.moduleManager.activate(newModuleModel);
            this.verifyModuleDependenciesConsistency(archivedModule, newModuleModel);
            this.setModelAsRamc(newModuleModel);
            result = true;
            mdaRuntimeDir = new File(mdaDir, ".runtime");
            installClasspath = this.getRelativeClasspathFromInstallDir(archivedModule, mdaDir);
            classPath = null;
            if (installClasspath != null) {
                classPath = this.updateRuntimeClasspath(installClasspath, mdaDir, mdaRuntimeDir);
            } else {
                result = false;
            }
            if (result) {
                result = this.moduleManager.installModule(archivedModule, classPath);
            }
            if (result) {
                this.setModuleJavaClass(archivedModule.mainClass, newModuleModel);
                newMdac = this.moduleManager.loadMdac(newModuleModel, classPath);
                newMdac.getSession().upgrade(oldVersion, oldParameters);
                if (this.startModuleAtInstall) {
                    result = this.moduleManager.startMdac(newMdac);
                }
            }
            if (!result) ** GOTO lbl145
            var19_23 = modulesToReload.iterator();
            while (true) {
                block43: {
                    if (var19_23.hasNext()) break block43;
                    var19_23 = modulesToReload.iterator();
                    if (true) ** GOTO lbl104
                }
                mdacToReload = (IMdac)var19_23.next();
                this.moduleManager.unloadMdac(mdacToReload);
            }
        }
        catch (IOException e) {
            try {
                MdaInfra.LOG.error("Aborting '" + archivedModule.getName() + "' module update because of: ");
                MdaInfra.LOG.error((Throwable)e);
                e2 = new MdacException(MdaInfra.I18N.getMessage("L1", new String[]{archivedModule.name, e.getMessage()}));
                e2.initCause((Throwable)e);
                throw e2;
                catch (InvalidTransactionException e) {
                    MdaInfra.LOG.error("Aborting '" + archivedModule.getName() + "' module update because of: ");
                    MdaInfra.LOG.error((Throwable)e);
                    transaction = null;
                    e2 = new MdacException(e.getMessage());
                    e2.initCause((Throwable)e);
                    throw e2;
                }
                catch (MdacException | RuntimeException e) {
                    MdaInfra.LOG.error("Aborting '" + archivedModule.getName() + "' module update because of: ");
                    MdaInfra.LOG.error(e);
                    throw e;
                }
            }
            catch (Throwable var22_58) {
                if (transaction == null) throw var22_58;
                try {
                    block42: {
                        transactionManager.rollback(transaction);
                        if (newMdac != null) {
                            this.moduleManager.unloadMdac(newMdac);
                        }
                        this.restoreModuleDirectory(archivedModule, mdaDir);
                        mdaRuntimeDir = new File(mdaDir, ".runtime");
                        installClasspath = this.getRelativeClasspathFromInstallDir(archivedModule, mdaDir);
                        classPath = this.updateRuntimeClasspath(installClasspath, mdaDir, mdaRuntimeDir);
                        oldMdac = this.moduleManager.loadMdac(oldModule, classPath);
                        if (wasStarted) {
                            this.moduleManager.startMdac(oldMdac);
                        }
                        var28_48 = modulesToReload.iterator();
                        while (true) {
                            if (!var28_48.hasNext()) {
                                var28_48 = modulesToReload.iterator();
                                break;
                            }
                            mdacToReload = (IMdac)var28_48.next();
                            this.moduleManager.unloadMdac(mdacToReload);
                        }
lbl96:
                        // 3 sources

                        while (true) {
                            if (!var28_48.hasNext()) {
                                throw var22_58;
                            }
                            break block42;
                            break;
                        }
                        do {
                            if ((reloadedMdac = this.moduleManager.loadMdac(moduleModel = (mdacToReload = (IMdac)var19_23.next()).getModel())) == null) continue;
                            this.moduleManager.startMdac(reloadedMdac);
lbl104:
                            // 3 sources

                        } while (var19_23.hasNext());
                        transactionManager.commit(transaction);
                        transaction = null;
                        this.deleteModuleDirectoryBackup(archivedModule, mdaDir);
                        var23_27 = newMdac;
                        if (transaction == null) return var23_27;
                        try {
                            transactionManager.rollback(transaction);
                            if (newMdac != null) {
                                this.moduleManager.unloadMdac(newMdac);
                            }
                            this.restoreModuleDirectory(archivedModule, mdaDir);
                            mdaRuntimeDir = new File(mdaDir, ".runtime");
                            installClasspath = this.getRelativeClasspathFromInstallDir(archivedModule, mdaDir);
                            classPath = this.updateRuntimeClasspath(installClasspath, mdaDir, mdaRuntimeDir);
                            oldMdac = this.moduleManager.loadMdac(oldModule, classPath);
                            if (wasStarted) {
                                this.moduleManager.startMdac(oldMdac);
                            }
                            for (IMdac mdacToReload : modulesToReload) {
                                this.moduleManager.unloadMdac(mdacToReload);
                            }
                            for (IMdac mdacToReload : modulesToReload) {
                                moduleModel = mdacToReload.getModel();
                                reloadedMdac = this.moduleManager.loadMdac(moduleModel);
                                if (reloadedMdac == null) continue;
                                this.moduleManager.startMdac(reloadedMdac);
                            }
                            return var23_27;
                        }
                        catch (NotCurrentTransactionException e) {
                            MdaInfra.LOG.warning("Rollbacking of '" + archivedModule.getName() + "' module update failed because of: ");
                            MdaInfra.LOG.warning((Throwable)e);
                            return var23_27;
                        }
                        catch (NoTransactionOpenException e) {
                            MdaInfra.LOG.warning("Rollbacking of '" + archivedModule.getName() + "' module update failed because of: ");
                            MdaInfra.LOG.warning((Throwable)e);
                            return var23_27;
                        }
                        catch (IOException e) {
                            MdaInfra.LOG.warning("Rollbacking of '" + archivedModule.getName() + "' module update failed because of: ");
                            MdaInfra.LOG.warning((Throwable)e);
                        }
                        return var23_27;
lbl145:
                        // 1 sources

                        if (transaction == null) return null;
                        try {
                            transactionManager.rollback(transaction);
                            if (newMdac != null) {
                                this.moduleManager.unloadMdac(newMdac);
                            }
                            this.restoreModuleDirectory(archivedModule, mdaDir);
                            mdaRuntimeDir = new File(mdaDir, ".runtime");
                            installClasspath = this.getRelativeClasspathFromInstallDir(archivedModule, mdaDir);
                            classPath = this.updateRuntimeClasspath(installClasspath, mdaDir, mdaRuntimeDir);
                            oldMdac = this.moduleManager.loadMdac(oldModule, classPath);
                            if (wasStarted) {
                                this.moduleManager.startMdac(oldMdac);
                            }
                            for (IMdac mdacToReload : modulesToReload) {
                                this.moduleManager.unloadMdac(mdacToReload);
                            }
                            for (IMdac mdacToReload : modulesToReload) {
                                moduleModel = mdacToReload.getModel();
                                reloadedMdac = this.moduleManager.loadMdac(moduleModel);
                                if (reloadedMdac == null) continue;
                                this.moduleManager.startMdac(reloadedMdac);
                            }
                            return null;
                        }
                        catch (NotCurrentTransactionException e) {
                            MdaInfra.LOG.warning("Rollbacking of '" + archivedModule.getName() + "' module update failed because of: ");
                            MdaInfra.LOG.warning((Throwable)e);
                            return null;
                        }
                        catch (NoTransactionOpenException e) {
                            MdaInfra.LOG.warning("Rollbacking of '" + archivedModule.getName() + "' module update failed because of: ");
                            MdaInfra.LOG.warning((Throwable)e);
                            return null;
                        }
                        catch (IOException e) {
                            MdaInfra.LOG.warning("Rollbacking of '" + archivedModule.getName() + "' module update failed because of: ");
                            MdaInfra.LOG.warning((Throwable)e);
                        }
                        return null;
                    }
                    mdacToReload = (IMdac)var28_48.next();
                    moduleModel = mdacToReload.getModel();
                    reloadedMdac = this.moduleManager.loadMdac(moduleModel);
                    if (reloadedMdac == null) ** GOTO lbl96
                    this.moduleManager.startMdac(reloadedMdac);
                    ** continue;
                }
                catch (NotCurrentTransactionException e) {
                    MdaInfra.LOG.warning("Rollbacking of '" + archivedModule.getName() + "' module update failed because of: ");
                    MdaInfra.LOG.warning((Throwable)e);
                    throw var22_58;
                }
                catch (NoTransactionOpenException e) {
                    MdaInfra.LOG.warning("Rollbacking of '" + archivedModule.getName() + "' module update failed because of: ");
                    MdaInfra.LOG.warning((Throwable)e);
                    throw var22_58;
                }
                catch (IOException e) {
                    MdaInfra.LOG.warning("Rollbacking of '" + archivedModule.getName() + "' module update failed because of: ");
                    MdaInfra.LOG.warning((Throwable)e);
                }
            }
        }
        throw var22_58;
    }

    private void removeModulesDirectory(MdacArchiveInfo archivedModule, File plugsPath) {
    }

    private void restoreModuleDirectory(MdacArchiveInfo archivedModule, File plugsPath) {
        File dir = new File(plugsPath, archivedModule.name);
        File oldDir = new File(String.valueOf(dir.getPath()) + ".old");
        if (oldDir.isDirectory()) {
            this.delete(dir);
            oldDir.renameTo(dir);
        }
    }

    private void saveModuleDirectory(MdacArchiveInfo archivedModule, File plugsPath) {
        File dir = new File(plugsPath, archivedModule.name);
        File oldDir = new File(String.valueOf(dir.getPath()) + ".old");
        if (dir.isDirectory()) {
            dir.renameTo(oldDir);
        }
    }

    private List<File> updateRuntimeClasspath(List<String> classpath, File mdaDir, File mdaRuntimeDir) throws IOException {
        ArrayList<File> runtimeClasspath = new ArrayList<File>();
        for (String file : classpath) {
            File source = new File(mdaDir, file);
            File destination = this.getRuntimeJarFile(mdaRuntimeDir, file);
            destination.getParentFile().mkdirs();
            this.copyFile(source, destination);
            if (!destination.isFile()) continue;
            runtimeClasspath.add(destination);
        }
        return runtimeClasspath;
    }

    private void verifyImpactedModules(MdacArchiveInfo archivedModule) throws MdacException {
        Collection activeModules = this.registry.getLoadedModules();
        for (IMdac activeModule : activeModules) {
            List requiredModules = this.moduleManager.getRequiredMdacs(activeModule);
            for (IMdacDescriptor requiredModule : requiredModules) {
                if (!archivedModule.name.equals(requiredModule.getName()) || !archivedModule.version.isOlderThan(requiredModule.getVersion())) continue;
                String msg = MdaInfra.I18N.getMessage("L39_needed_mdac_older_than_archived", new String[]{archivedModule.name, archivedModule.version.toString(), requiredModule.getVersion().toString(), activeModule.getName()});
                MdacException e = new MdacException(msg);
                throw e;
            }
        }
    }

    private void verifyNeededModules(MdacArchiveInfo archivedModule, List<MdacArchiveInfo> manifestedModules) throws MdacException {
        Collection activeModules = this.registry.getLoadedModules();
        for (IMdacDescriptor dep : archivedModule.requiredModules) {
            boolean found = false;
            for (MdacArchiveInfo manifestedModule : manifestedModules) {
                if (!manifestedModule.name.equals(dep.getName())) continue;
                if (manifestedModule.version != null && manifestedModule.version.equals((Object)dep.getVersion())) {
                    found = true;
                    continue;
                }
                if (manifestedModule.version.isNewerThan(dep.getVersion())) {
                    found = true;
                    continue;
                }
                String msg = MdaInfra.I18N.getMessage("L40_mdac_too_old_in_archive", new String[]{manifestedModule.name, dep.getVersion().toString(), archivedModule.name});
                MdacException e = new MdacException(msg);
                throw e;
            }
            Iterator i = activeModules.iterator();
            while (!found && i.hasNext()) {
                IMdac activeModule = (IMdac)i.next();
                if (!activeModule.getName().equals(dep.getName())) continue;
                if (activeModule.getVersion() != null && activeModule.getVersion().equals((Object)dep.getVersion())) {
                    found = true;
                    continue;
                }
                if (activeModule.getVersion().isNewerThan(dep.getVersion())) {
                    found = true;
                    continue;
                }
                String msg = MdaInfra.I18N.getMessage("L41_mdac_in_project_too_old", new String[]{activeModule.getName(), dep.getVersion().toString(), archivedModule.name});
                MdacException e = new MdacException(msg);
                throw e;
            }
            if (found) continue;
            String msg = MdaInfra.I18N.getMessage("L42_missing_required_mdac", new String[]{archivedModule.name, dep.getName(), dep.getVersion().toString()});
            MdacException e = new MdacException(msg);
            throw e;
        }
    }

    private void verifyModuleDependenciesConsistency(MdacArchiveInfo archivedModule, IModule moduleModel) throws MdacException {
        if (archivedModule.requiredModules.size() != moduleModel.getDependsOn().size()) {
            StringBuilder details = new StringBuilder();
            details.append("\n Required modules as registered in the manifest.xml:\n");
            for (IMdacDescriptor ref : archivedModule.requiredModules) {
                details.append("   - '");
                details.append(ref.getName());
                details.append("' module\n");
            }
            if (archivedModule.requiredModules.isEmpty()) {
                details.append("   none \n");
            }
            details.append("\n Required modules as registered in the imported model:\n");
            for (IModule m : moduleModel.getDependsOn()) {
                details.append("   - '");
                details.append(m.getName());
                details.append("' module\n");
            }
            if (moduleModel.getDependsOn().isEmpty()) {
                details.append("   none \n");
            }
            MdacException e2 = new MdacException(String.format("The '%1$s' module archive is not consistent:\n%2$s\nPlease contact the module developer in order to resolve this problem.", archivedModule.name, details.toString()));
            throw e2;
        }
    }

    private void setModelAsRamc(IModule module) {
        List list = CompositionServices.getAllCompositionChildren((IElement)module);
        IAccessManager accessManager = this.modelingSession.getAccessManager();
        for (IElement e : list) {
            accessManager.setCmsManaged(e, false);
            accessManager.setRamcObject(e, true);
            accessManager.setUserWriteRight(e, false);
        }
        accessManager.setCmsManaged((IElement)module, false);
        accessManager.setRamcObject((IElement)module, true);
        accessManager.setUserWriteRight((IElement)module, false);
    }

    public Collection<IMdac> deployMdacs(List<File> archiveFiles, IProgressMonitor aMonitor) throws MdacException {
        ArrayList<IMdac> deployedModules = new ArrayList<IMdac>();
        IProgressMonitor monitor = aMonitor != null ? aMonitor : new NullProgressMonitor();
        int totalWork = archiveFiles.size() * 2 + 1;
        monitor.beginTask(MdaInfra.I18N.getString("MdacDeployer.ProgressTitle"), totalWork);
        for (File archiveFile : archiveFiles) {
            monitor.subTask(MdaInfra.I18N.getMessage("MdacDeployer.InstallModule", new String[]{archiveFile.getName()}));
            IMdacArchive archive = this.getArchive(archiveFile);
            Manifest manifest = archive.getManifest();
            monitor.worked(1);
            for (MdacArchiveInfo archivedModule : manifest.mdacs) {
                IMdac module = this.deployModule(archivedModule, manifest.mdacs);
                if (module == null) continue;
                deployedModules.add(module);
            }
            monitor.worked(1);
        }
        monitor.setTaskName(MdaInfra.I18N.getString("MdacDeployer.Saving"));
        this.modelingSession.save();
        monitor.worked(1);
        monitor.done();
        return deployedModules;
    }
}

