/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mdainfra.mdacs.deployment;

import com.modeliosoft.modelio.api.mdac.MdacException;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.mdainfra.mdacs.core.IMdacManager;
import com.modeliosoft.modelio.mdainfra.mdacs.core.MdacManager;
import com.modeliosoft.modelio.mdainfra.mdacs.deployment.MdacDeployer;
import com.modeliosoft.modelio.mdainfra.plugin.MdaInfra;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class MdacDeployerWithProgress
implements IRunnableWithProgress {
    private IModelingSession session = null;
    private File mdacFile = null;

    public MdacDeployerWithProgress(IModelingSession session, File mdacFile) {
        this.session = session;
        this.mdacFile = mdacFile;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (this.mdacFile != null) {
            monitor.beginTask(MdaInfra.I18N.getMessage("DeployMdacHandler.DeployModule", new String[]{this.mdacFile.getName()}), 2);
            monitor.worked(1);
            MdacDeployer deployer = new MdacDeployer(this.session, (IMdacManager)new MdacManager(this.session));
            try {
                deployer.deployMdacs(this.mdacFile);
            }
            catch (MdacException e) {
                String msg = null;
                if (e.getCause() != null) {
                    msg = e.getCause().getLocalizedMessage();
                }
                if (msg == null || msg.isEmpty()) {
                    msg = e.getLocalizedMessage();
                }
                String title = MdaInfra.I18N.getMessage("DeployMdacHandler.FailedTitle", new String[]{this.mdacFile.getName()});
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)title, (String)(e.getCause() != null ? e.getCause().getLocalizedMessage() : e.getLocalizedMessage()));
            }
            monitor.worked(1);
        }
    }
}

