/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mdainfra.mdacs.deployment;

import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.IArtifact;
import com.modeliosoft.modelio.api.model.uml.statik.IManifestation;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.mdainfra.plugin.MdaInfra;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class MdacPackager {
    private File resDirectory;
    private IArtifact artifact;
    private List<IModule> modules = new ArrayList();

    public void run(String destDirectory) throws IOException {
        ZipOutputStream archive = this.createArchive(destDirectory);
        this.archiveMdacs(archive);
        archive.close();
    }

    private void archiveMdacs(ZipOutputStream archiveStream) throws IOException {
        for (IModule module : this.modules) {
            File mdacSubDir = new File(module.getName());
            File mdacResDir = new File(this.resDirectory, mdacSubDir.getPath());
            if (!mdacResDir.isDirectory()) {
                String msg = MdaInfra.I18N.getMessage("directory_not_found", new String[]{mdacResDir.getPath(), module.getName(), module.getVersion()});
                throw new FileNotFoundException(msg);
            }
            this.zipDir(mdacResDir, mdacSubDir, archiveStream);
        }
        File manifestFile = new File(this.resDirectory, "manifest.xml");
        ZipEntry manifestEntry = new ZipEntry("manifest.xml");
        manifestEntry.setTime(manifestFile.lastModified());
        archiveStream.putNextEntry(manifestEntry);
        FileInputStream fis = new FileInputStream(manifestFile);
        byte[] readBuffer = new byte[2156];
        int bytesIn = 0;
        while ((bytesIn = fis.read(readBuffer)) != -1) {
            archiveStream.write(readBuffer, 0, bytesIn);
        }
        fis.close();
        archiveStream.closeEntry();
    }

    private ZipOutputStream createArchive(String destDirectory) throws IOException {
        ZipOutputStream archiveStream;
        File dir;
        String fileName = this.artifact.getFileName();
        if (fileName.length() == 0) {
            fileName = String.valueOf(destDirectory) + "/" + this.artifact.getName() + ".jmdac";
        }
        if ((dir = new File(fileName).getParentFile()) != null) {
            dir.mkdirs();
        }
        try {
            FileOutputStream fileStream = new FileOutputStream(fileName);
            archiveStream = new ZipOutputStream(fileStream);
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException(MdaInfra.I18N.getMessage("cannot_create_file", new String[]{fileName, e.getMessage()}));
        }
        archiveStream.setMethod(8);
        archiveStream.setLevel(9);
        return archiveStream;
    }

    private void zipDir(File dir2zip, File destPath, ZipOutputStream zos) throws IOException {
        byte[] readBuffer = new byte[2156];
        File zipDir = dir2zip;
        String[] dirList = zipDir.list();
        if (dirList == null) {
            return;
        }
        int i = 0;
        while (i < dirList.length) {
            File f = new File(zipDir, dirList[i]);
            if (f.isDirectory()) {
                String relativePath = String.valueOf(f.getPath().replace(dir2zip.getPath(), destPath.getPath())) + "/";
                LOG.info((String)"org.modelio.mda.infra", (String)MdaInfra.I18N.getMessage("adding_directory_to_archive", new String[]{f.getPath(), relativePath, dir2zip.getPath(), destPath.getPath()}));
                relativePath = relativePath.replace("\\", "/");
                relativePath = relativePath.replace("//", "/");
                ZipEntry anEntry = new ZipEntry(relativePath);
                anEntry.setTime(f.lastModified());
                zos.putNextEntry(anEntry);
                this.zipDir(f, new File(destPath, f.getName()), zos);
            } else {
                int bytesIn = 0;
                FileInputStream fis = new FileInputStream(f);
                String relativePath = f.getPath().replace(dir2zip.getPath(), destPath.getPath());
                relativePath = relativePath.replace("\\", "/");
                relativePath = relativePath.replace("//", "/");
                ZipEntry anEntry = new ZipEntry(relativePath);
                anEntry.setTime(f.lastModified());
                zos.putNextEntry(anEntry);
                while ((bytesIn = fis.read(readBuffer)) != -1) {
                    zos.write(readBuffer, 0, bytesIn);
                }
                fis.close();
                zos.closeEntry();
            }
            ++i;
        }
    }

    public MdacPackager(IArtifact srcArtifact, File resDir) {
        this.artifact = srcArtifact;
        this.resDirectory = resDir;
        this.modules = new Vector();
        for (IManifestation i1 : this.artifact.getUtilized()) {
            IModelElement i2 = i1.getUtilizedElement();
            if (!(i2 instanceof IModule)) continue;
            IModule module = (IModule)i2;
            this.modules.add(module);
        }
    }
}

