/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mdainfra.mdacs.deployment;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.mdac.MdacException;
import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.utils.exceptions.InvalidModelManipulationException;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.jni.IAccessManager;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.model.CompositionServices;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.mdainfra.mdacs.core.IMdacManager;
import com.modeliosoft.modelio.mdainfra.plugin.MdaInfra;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;

public class MdacRemover {
    private IModelingSession modelingSession;
    private IMdacManager moduleManager;

    public void remove(IMdac mdac) throws MdacException {
        block13: {
            IModule module = mdac.getModel();
            ITransaction t = null;
            try {
                try {
                    this.checkCanRemoveModule(mdac);
                    t = this.modelingSession.getTransactionManager().createTransaction("Remove Module");
                    this.moduleManager.deactivate(mdac);
                    this.moduleManager.unselectMdac(mdac);
                    this.moduleManager.unloadMdac(mdac);
                    File mdacPath = this.moduleManager.getMdacPath(module);
                    try {
                        Files.walkFileTree(mdacPath.toPath(), (FileVisitor<? super Path>)new /* Unavailable Anonymous Inner Class!! */);
                    }
                    catch (IOException e) {
                        MdaInfra.LOG.error((Throwable)e);
                    }
                    this.deleteModel(module);
                    this.modelingSession.getTransactionManager().commit(t);
                    t = null;
                }
                catch (InvalidTransactionException e) {
                    t = null;
                    if (t != null) {
                        this.modelingSession.getTransactionManager().rollback(t);
                        IMdac reloadedMdac = this.moduleManager.loadMdac(module);
                        this.moduleManager.selectMdac(reloadedMdac);
                        if (this.moduleManager.isActivated(module)) {
                            this.moduleManager.startMdac(reloadedMdac);
                        }
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                if (t != null) {
                    this.modelingSession.getTransactionManager().rollback(t);
                    IMdac reloadedMdac = this.moduleManager.loadMdac(module);
                    this.moduleManager.selectMdac(reloadedMdac);
                    if (this.moduleManager.isActivated(module)) {
                        this.moduleManager.startMdac(reloadedMdac);
                    }
                }
                throw throwable;
            }
            if (t != null) {
                this.modelingSession.getTransactionManager().rollback(t);
                IMdac reloadedMdac = this.moduleManager.loadMdac(module);
                this.moduleManager.selectMdac(reloadedMdac);
                if (this.moduleManager.isActivated(module)) {
                    this.moduleManager.startMdac(reloadedMdac);
                }
            }
        }
    }

    private void deleteModel(IModule module) throws MdacException {
        this.unlockRecursive((IElement)module);
        try {
            module.delete();
        }
        catch (InvalidModelManipulationException e) {
            throw new MdacException(MdaInfra.I18N.getString("MdacRemover.ErrorDeletingModule"), (Throwable)e);
        }
    }

    public MdacRemover(IModelingSession modelingSession, IMdacManager moduleManager) {
        this.modelingSession = modelingSession;
        this.moduleManager = moduleManager;
    }

    private void unlockRecursive(IElement elt) {
        IAccessManager accessManager = this.modelingSession.getAccessManager();
        accessManager.setUserWriteRight(elt, true);
        accessManager.setRamcObject(elt, false);
        for (IElement child : CompositionServices.getAllCompositionChildren((IElement)elt)) {
            accessManager.setUserWriteRight(child, true);
            accessManager.setRamcObject(child, false);
        }
    }

    private void checkCanRemoveModule(IMdac mdacToRemove) throws MdacException {
        if (mdacToRemove.getModel().getImpacted() != null && !mdacToRemove.getModel().getImpacted().isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (IModule requiring : mdacToRemove.getModel().getImpacted()) {
                IMdac loadedMdac = this.modelingSession.getMdacRegistry().getLoadedMdac(requiring);
                builder.append(this.getMdacName(loadedMdac));
                builder.append("\n");
            }
            throw new MdacException(MdaInfra.I18N.getMessage("MdacRemover.ModuleStillUsed", new String[]{this.getMdacName(mdacToRemove), builder.toString()}));
        }
        for (IElement element : CompositionServices.getAllCompositionChildren((IElement)mdacToRemove.getModel())) {
            IStereotype stereotype;
            if (!(element instanceof IStereotype) || (stereotype = (IStereotype)element).getExtendedElement().isEmpty()) continue;
            boolean isReadOnly = false;
            for (IModelElement extendedElement : stereotype.getExtendedElement()) {
                if (extendedElement.getElementStatus().isModifiable()) continue;
                isReadOnly = true;
                break;
            }
            if (!isReadOnly) continue;
            StringBuilder builder = new StringBuilder();
            for (IModelElement extended : stereotype.getExtendedElement()) {
                builder.append(extended.getName());
                builder.append(", ");
            }
            String message = MdaInfra.I18N.getMessage("MdacRemover.StereotypeStillUsed", new String[]{stereotype.getLabel().isEmpty() ? stereotype.getName() : stereotype.getLabel(), this.getMdacName(mdacToRemove), builder.substring(0, builder.length() - 2)});
            throw new MdacException(message);
        }
    }

    private String getMdacName(IMdac mdac) {
        if (mdac.getLabel() != null && mdac.getLabel() != "") {
            return mdac.getLabel();
        }
        return mdac.getName();
    }
}

