/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mdainfra.mdacs.internal;

import com.modeliosoft.modelio.api.model.extension.IConfigParam;
import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.module.IMdacConfiguration;
import com.modeliosoft.modelio.api.utils.ObList;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MdacConfiguration
implements IMdacConfiguration {
    private File projectSpacePath;
    private File workspacePath;
    private File deploymentPath;
    private IModule module;
    private List<File> docpath;

    public MdacConfiguration(IModule module, File workspacePath, File projectSpacePath, File deploymentPath, List<File> docpath) {
        this.module = module;
        this.projectSpacePath = projectSpacePath;
        this.workspacePath = workspacePath;
        this.deploymentPath = deploymentPath;
        this.docpath = docpath;
    }

    public String getParameterValue(String key) {
        ObList configParams = this.module.getModuleParameter();
        for (IConfigParam configParam : configParams) {
            if (!configParam.getName().equals(key)) continue;
            return configParam.getValue();
        }
        return null;
    }

    public Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        ObList configParams = this.module.getModuleParameter();
        for (IConfigParam configParam : configParams) {
            parameters.put(configParam.getName(), configParam.getValue());
        }
        return parameters;
    }

    public void setParameterValue(String key, String value) {
        ObList configParams = this.module.getModuleParameter();
        for (IConfigParam configParam : configParams) {
            if (!configParam.getName().equals(key)) continue;
            configParam.setValue(value);
        }
    }

    public void updateFrom(Map<String, String> parameters) {
        ObList moduleParameters = this.module.getModuleParameter();
        int i = 0;
        while (i < moduleParameters.size()) {
            IConfigParam moduleParameter = (IConfigParam)moduleParameters.get(i);
            String value = parameters.get(((IConfigParam)moduleParameters.get(i)).getName());
            if (value != null) {
                moduleParameter.setValue(value);
            }
            ++i;
        }
    }

    public File getWorkspacePath() {
        return this.workspacePath;
    }

    public File getProjectSpacePath() {
        return this.projectSpacePath;
    }

    public File getModuleResourcesPath() {
        return this.deploymentPath;
    }

    public List<File> getDocpath() {
        return this.docpath;
    }
}

