/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mdainfra.mdacs.store;

import com.modeliosoft.modelio.api.mdac.MdacException;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.mdainfra.mdacs.core.ModuleInfos;
import com.modeliosoft.modelio.mdainfra.mdacs.store.IMdacArchive;
import com.modeliosoft.modelio.mdainfra.mdacs.store.Manifest;
import com.modeliosoft.modelio.mdainfra.mdacs.store.MdacArchiveInfo;
import com.modeliosoft.modelio.mdainfra.plugin.MdaInfra;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.w3c.dom.Element;

public class JarArchive
implements IMdacArchive {
    private final File archiveFile;
    private Manifest cachedManifest;
    private static final String MANIFEST_RAMC_ELT = "ramc";
    private static final String MODULE_FILENAME = "module.xml";

    public JarArchive(File archiveFile) {
        this.archiveFile = archiveFile;
    }

    public void extract(File destPath) throws MdacException {
        try {
            ZipFile f = new ZipFile(this.archiveFile);
            Enumeration<? extends ZipEntry> entries = f.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryRelativPath = entry.getName();
                entryRelativPath = entryRelativPath.replace("\\", "/");
                File outPath = new File(destPath, entryRelativPath);
                if (entry.isDirectory()) {
                    this.makeDirectory(outPath);
                    continue;
                }
                this.extractFile(f, entry, outPath);
            }
        }
        catch (IOException e) {
            throw new MdacException(MdaInfra.I18N.getMessage("L13_error_extracting_archive", new String[]{e.getMessage()}), (Throwable)e);
        }
    }

    public Manifest getManifest() throws MdacException {
        if (this.cachedManifest == null) {
            try {
                Throwable throwable = null;
                Object var2_6 = null;
                try (ZipFile f = new ZipFile(this.archiveFile);){
                    Enumeration<? extends ZipEntry> entries = f.entries();
                    ZipEntry moduleEntry = null;
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        if (!entry.getName().endsWith(MODULE_FILENAME)) continue;
                        moduleEntry = entry;
                        break;
                    }
                    if (moduleEntry == null) {
                        throw new MdacException(MdaInfra.I18N.getString("L12_no_manifest_xml_file"));
                    }
                    Throwable throwable2 = null;
                    Object var7_13 = null;
                    try (InputStream s = f.getInputStream(moduleEntry);){
                        this.cachedManifest = this.parseManifest(s);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException e) {
                throw new MdacException(MdaInfra.I18N.getMessage("L16_file_missing", new String[]{e.getMessage()}), (Throwable)e);
            }
            catch (IOException e) {
                throw new MdacException(MdaInfra.I18N.getMessage("L13_error_extracting_archive", new String[]{this.archiveFile.getPath(), e.getMessage()}), (Throwable)e);
            }
            catch (Exception e) {
                throw new MdacException(MdaInfra.I18N.getMessage("L13_error_extracting_archive", new String[]{this.archiveFile.getPath(), e.getMessage()}), (Throwable)e);
            }
        }
        return this.cachedManifest;
    }

    public File getPath() {
        return this.archiveFile;
    }

    private void extractFile(ZipFile f, ZipEntry entry, File outFile) throws MdacException, IOException {
        FileOutputStream out;
        int BufSize = 2156;
        File outDir = outFile.getParentFile();
        this.makeDirectory(outDir);
        InputStream in = f.getInputStream(entry);
        try {
            out = new FileOutputStream(outFile);
        }
        catch (IOException e) {
            String msg = MdaInfra.I18N.getMessage("L14_cannot_create_file", new String[]{outFile.getPath(), e.getLocalizedMessage()});
            throw new MdacException(msg, (Throwable)e);
        }
        try {
            try {
                int bytesIn;
                byte[] readBuffer = new byte[2156];
                while ((bytesIn = in.read(readBuffer)) != -1) {
                    out.write(readBuffer, 0, bytesIn);
                }
            }
            catch (IOException e) {
                String msg = MdaInfra.I18N.getMessage("L15_cannot_write_file", new String[]{outFile.getPath(), e.getLocalizedMessage()});
                throw new MdacException(msg, (Throwable)e);
            }
        }
        finally {
            out.close();
        }
    }

    private void initRamcs(Element el, MdacArchiveInfo mdac, Manifest theManifest) throws MdacException {
    }

    private void makeDirectory(File outPath) throws IOException {
        outPath.mkdirs();
        if (!outPath.isDirectory()) {
            LOG.error((String)"org.modelio.mda.infra", (String)("Error creating the '" + outPath.getPath() + "' directory"));
            throw new IOException(MdaInfra.I18N.getMessage("L9_cannot_create_directory", new String[]{outPath.getPath()}));
        }
    }

    private Manifest parseManifest(InputStream s) throws MdacException {
        Manifest newManifest = new Manifest();
        ModuleInfos moduleInfos = new ModuleInfos(s);
        MdacArchiveInfo mdac = new MdacArchiveInfo((IMdacArchive)this);
        mdac.name = moduleInfos.getName();
        mdac.version = moduleInfos.getVersion();
        mdac.toolVersion = moduleInfos.getBinaryVersion();
        mdac.mainClass = moduleInfos.getMainClassName();
        mdac.siteIdentifier = moduleInfos.getUid();
        mdac.licenseRequired = moduleInfos.isLicenseRequired();
        mdac.requiredModules = new ArrayList(moduleInfos.getDependencies());
        mdac.weakReferenceModules = new ArrayList(moduleInfos.getWeakDependencies());
        mdac.classPath = new ArrayList(moduleInfos.getClasspath());
        newManifest.mdacs.add(mdac);
        return newManifest;
    }
}

