/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mdainfra.mdacs.store;

import com.modeliosoft.modelio.api.mdac.IMdacDescriptor;
import com.modeliosoft.modelio.api.mdac.MdacException;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.mdainfra.mdacs.store.IMdacArchive;
import com.modeliosoft.modelio.mdainfra.mdacs.store.JarArchive;
import com.modeliosoft.modelio.mdainfra.mdacs.store.Manifest;
import com.modeliosoft.modelio.mdainfra.mdacs.store.MdacArchiveInfo;
import com.modeliosoft.modelio.mdainfra.mdacs.store.MdacArchiveRepository;
import com.modeliosoft.modelio.mdainfra.mdacs.store.ModuleArchiveSorter;
import com.modeliosoft.modelio.mdainfra.mdacs.store.UnresolvedReference;
import com.modeliosoft.modelio.mdainfra.mdacs.store.UnresolvedReferenceException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class MdacArchiveRepository {
    private File repositoryPath;
    private List<MdacArchiveInfo> archivedMdacs = new ArrayList();
    private List<IMdacArchive> archives = new ArrayList();

    public MdacArchiveRepository(File repositoryPath) throws IllegalArgumentException {
        this.repositoryPath = repositoryPath;
        this.init(repositoryPath);
    }

    public MdacArchiveRepository(Collection<File> archiveFiles) {
        this.repositoryPath = null;
        for (File f : archiveFiles) {
            this.addFile(f);
        }
    }

    public void addFile(File archiveFile) throws IllegalArgumentException {
        JarArchive mdacArchive = null;
        if (!archiveFile.getAbsolutePath().endsWith(".jmdac")) {
            throw new IllegalArgumentException("Non module archive: " + archiveFile.getPath());
        }
        mdacArchive = new JarArchive(archiveFile);
        this.archives.add(mdacArchive);
        try {
            Manifest manifest = mdacArchive.getManifest();
            for (MdacArchiveInfo mdac : manifest.mdacs) {
                this.archivedMdacs.add(mdac);
            }
        }
        catch (MdacException e) {
            LOG.error((String)"org.modelio.mda.infra", (Throwable)e);
        }
    }

    public Map<String, MdacArchiveInfo> getLatestModules() {
        HashMap<String, MdacArchiveInfo> sortedAdapters = new HashMap<String, MdacArchiveInfo>();
        MdacArchiveInfo currentModuleAdapter = null;
        for (MdacArchiveInfo archivedMdac : this.archivedMdacs) {
            currentModuleAdapter = (MdacArchiveInfo)sortedAdapters.get(archivedMdac.name);
            if (currentModuleAdapter == null) {
                sortedAdapters.put(archivedMdac.name, archivedMdac);
                continue;
            }
            if (!currentModuleAdapter.version.isOlderThan(archivedMdac.version)) continue;
            sortedAdapters.put(archivedMdac.name, archivedMdac);
        }
        return sortedAdapters;
    }

    public MdacArchiveInfo getLatestVersion(String name) {
        MdacArchiveInfo latestVersion = null;
        for (MdacArchiveInfo adapter : this.archivedMdacs) {
            if (!name.equals(adapter.getName())) continue;
            if (latestVersion == null) {
                latestVersion = adapter;
                continue;
            }
            if (!latestVersion.getVersion().isOlderThan(adapter.getVersion())) continue;
            latestVersion = adapter;
        }
        return latestVersion;
    }

    public LocalizedData getLocalization(MdacArchiveInfo mdac) throws IOException, FileNotFoundException {
        IMdacArchive archive = mdac.getArchive();
        if (archive == null) {
            throw new FileNotFoundException("No archive file for the '" + mdac.name + "' module");
        }
        if (archive instanceof JarArchive) {
            ZipFile zipFile = new ZipFile(mdac.getArchive().getPath());
            String dirSep = "/";
            String moduleLangName = String.valueOf(mdac.name) + "/" + "module_" + O.getDefault().getLang() + ".properties";
            String moduleCommonName = String.valueOf(mdac.name) + "/" + "module.properties";
            String moduleLangNameVersion = String.valueOf(mdac.name) + "/" + mdac.version.toString() + "/" + "module_" + O.getDefault().getLang() + ".properties";
            String moduleCommonVersion = String.valueOf(mdac.name) + "/" + mdac.version.toString() + "/" + "module.properties";
            ZipEntry entry = this.getZipEntry(zipFile, moduleLangName);
            if (entry == null) {
                entry = this.getZipEntry(zipFile, moduleCommonName);
            }
            if (entry == null) {
                entry = this.getZipEntry(zipFile, moduleLangNameVersion);
            }
            if (entry == null) {
                entry = this.getZipEntry(zipFile, moduleCommonVersion);
            }
            if (entry == null) {
                return null;
            }
            PropertyResourceBundle moduleBundle = new PropertyResourceBundle(zipFile.getInputStream(entry));
            return new LocalizedData(moduleBundle.getString("MdacLabel"), moduleBundle.getString("MdacDescription"));
        }
        return new LocalizedData(mdac.name, "");
    }

    public List<MdacArchiveInfo> getModules() {
        return this.archivedMdacs;
    }

    public Set<MdacArchiveInfo> getRequiredMdacs(MdacArchiveInfo archivedMdac) throws UnresolvedReferenceException {
        HashSet<MdacArchiveInfo> requiredMdacs = new HashSet<MdacArchiveInfo>();
        ArrayList missing = new ArrayList();
        this.addRequiredMdacs(archivedMdac, requiredMdacs, missing);
        if (!missing.isEmpty()) {
            throw new UnresolvedReferenceException(missing);
        }
        return requiredMdacs;
    }

    public File installArchiveFromURL(URL url, String category) throws IOException {
        File dir = new File(this.repositoryPath, category);
        dir.mkdirs();
        File archive = new File(dir, new File(url.getPath()).getName());
        InputStream in = null;
        OutputStream fout = null;
        try {
            if (archive.exists()) {
                archive.delete();
            }
            in = url.openStream();
            fout = new FileOutputStream(archive);
            int nread = 0;
            byte[] buffer = new byte[1024];
            while ((nread = in.read(buffer)) > 0) {
                fout.write(buffer, 0, nread);
            }
            fout.close();
            fout = null;
            in.close();
            in = null;
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException iOException) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return archive;
    }

    @Deprecated
    public List<MdacArchiveInfo> orderListForDeployement(Collection<MdacArchiveInfo> adapters) {
        return ModuleArchiveSorter.sort(adapters);
    }

    private void addRequiredMdacs(MdacArchiveInfo archivedMdac, Set<MdacArchiveInfo> to, List<UnresolvedReference> missing) {
        for (IMdacDescriptor requiredRef : archivedMdac.getRequiredMdacs()) {
            MdacArchiveInfo requiredMdac = this.getLatestVersion(requiredRef.getName());
            if (requiredMdac == null) {
                missing.add(new UnresolvedReference(requiredRef, null, archivedMdac));
                continue;
            }
            if (requiredMdac.getVersion().isOlderThan(requiredRef.getVersion())) {
                missing.add(new UnresolvedReference(requiredRef, requiredMdac, archivedMdac));
                continue;
            }
            if (!to.add(requiredMdac)) continue;
            this.addRequiredMdacs(requiredMdac, to, missing);
        }
    }

    private void init(File mdacStoreDir) throws IllegalArgumentException {
        if (!mdacStoreDir.isDirectory()) {
            throw new IllegalArgumentException("'" + mdacStoreDir + "' module store directory does not exist or is not a directory.");
        }
        List archiveFiles = this.listMdacArchives(mdacStoreDir);
        for (File archiveFile : archiveFiles) {
            this.addFile(archiveFile);
        }
    }

    private List<File> listMdacArchives(File mdacStoreDir) {
        File[] currentList;
        ArrayList<File> files = new ArrayList<File>();
        File[] fileArray = currentList = mdacStoreDir.listFiles((FileFilter)new /* Unavailable Anonymous Inner Class!! */);
        int n = currentList.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                files.addAll(this.listMdacArchives(file));
            } else if (file.isFile()) {
                files.add(file);
            }
            ++n2;
        }
        return files;
    }

    private ZipEntry getZipEntry(ZipFile zipFile, String entryName) throws IllegalStateException {
        ZipEntry ret = zipFile.getEntry(entryName);
        if (ret != null) {
            return ret;
        }
        return zipFile.getEntry(entryName.replace('/', '\\'));
    }
}

