/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mdainfra.mdacs.store;

import com.modeliosoft.modelio.api.mdac.IMdacDescriptor;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.mdainfra.mdacs.store.MdacArchiveInfo;
import com.modeliosoft.modelio.mdainfra.mdacs.store.MdacArchiveRepository;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ModuleArchiveSorter {
    private List<MdacArchiveInfo> sorted;
    private Collection<MdacArchiveInfo> visited;
    private Collection<MdacArchiveInfo> initial;

    public ModuleArchiveSorter(Collection<MdacArchiveInfo> adapters) {
        this.initial = adapters;
        this.sorted = new ArrayList(adapters.size());
        this.visited = new ArrayList(adapters.size());
    }

    public void run() {
        for (MdacArchiveInfo m : this.initial) {
            if (!m.name.equals("ModelerModule")) continue;
            this.topo(m);
        }
        for (MdacArchiveInfo m : this.initial) {
            this.topo(m);
        }
    }

    public static List<MdacArchiveInfo> sort(Collection<MdacArchiveInfo> adapters) {
        ModuleArchiveSorter sorter = new ModuleArchiveSorter(adapters);
        sorter.run();
        return sorter.getSorted();
    }

    public static List<MdacArchiveInfo> sortArchiveFiles(Collection<File> files) {
        MdacArchiveRepository repos = new MdacArchiveRepository(files);
        ModuleArchiveSorter sorter = new ModuleArchiveSorter(repos.getLatestModules().values());
        sorter.run();
        return sorter.getSorted();
    }

    public List<MdacArchiveInfo> getSorted() {
        return this.sorted;
    }

    private void topo(MdacArchiveInfo x) {
        if (this.visited.contains(x)) {
            return;
        }
        this.visited.add(x);
        HashSet requiredMdacRefs = new HashSet();
        this.addRequiredModuleRefs(x, requiredMdacRefs);
        for (IMdacDescriptor l : requiredMdacRefs) {
            for (MdacArchiveInfo m : this.initial) {
                if (!m.name.equals(l.getName()) || !m.version.equals((Object)l.getVersion()) && !m.version.isNewerThan(l.getVersion())) continue;
                this.topo(m);
            }
        }
        LOG.info((String)"org.modelio.mda.infra", (String)(" trace: sorted " + x.name + " " + x.version + " module"));
        this.sorted.add(x);
    }

    private void addRequiredModuleRefs(MdacArchiveInfo archivedMdac, Set<IMdacDescriptor> to) {
        for (IMdacDescriptor requiredRef : archivedMdac.getRequiredMdacs()) {
            MdacArchiveInfo requiredMdac;
            if (!to.add(requiredRef) || (requiredMdac = this.getLatestVersion(requiredRef.getName())) == null || requiredMdac.getVersion().isOlderThan(requiredRef.getVersion())) continue;
            this.addRequiredModuleRefs(requiredMdac, to);
        }
        for (IMdacDescriptor weakRef : archivedMdac.getWeakReferenceModules()) {
            MdacArchiveInfo weakReferenceModule;
            if (!to.add(weakRef) || (weakReferenceModule = this.getLatestVersion(weakRef.getName())) == null || weakReferenceModule.getVersion().isOlderThan(weakRef.getVersion())) continue;
            this.addRequiredModuleRefs(weakReferenceModule, to);
        }
    }

    private MdacArchiveInfo getLatestVersion(String name) {
        MdacArchiveInfo latestVersion = null;
        for (MdacArchiveInfo adapter : this.initial) {
            if (!name.equals(adapter.getName())) continue;
            if (latestVersion == null) {
                latestVersion = adapter;
                continue;
            }
            if (!latestVersion.getVersion().isOlderThan(adapter.getVersion())) continue;
            latestVersion = adapter;
        }
        return latestVersion;
    }
}

