/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mdainfra.mdacs.store;

import com.modeliosoft.modelio.mdainfra.mdacs.store.UnresolvedReference;
import java.util.List;

public class UnresolvedReferenceException
extends Exception {
    private static final long serialVersionUID = 1L;
    private List<UnresolvedReference> missingRefs;

    public UnresolvedReferenceException(List<UnresolvedReference> missing) {
        this.missingRefs = missing;
    }

    public List<UnresolvedReference> getMissingReferences() {
        return this.missingRefs;
    }

    @Override
    public String getMessage() {
        StringBuilder s = new StringBuilder();
        s.append("The following modules are missing:\n");
        for (UnresolvedReference ref : this.missingRefs) {
            s.append(" - ");
            s.append(ref.getMissingReference().getName());
            s.append(" V");
            s.append(ref.getMissingReference().getVersion());
            if (ref.getFoundModule() != null) {
                s.append(" (");
                s.append(ref.getFoundModule().name);
                s.append(ref.getFoundModule().version);
                s.append(" found module is too old)");
            }
            if (ref.getImpactedModule() != null) {
                s.append(" needed by ");
                s.append(ref.getImpactedModule().name);
                s.append(ref.getImpactedModule().version);
            }
            s.append("\n");
        }
        return s.toString();
    }
}

